<form class="row g-3 auto-width" action="{{ route('career-vacancy.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
    <div class="col-md-6">
        <label for="position" class="form-label">Position <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="position" name="position" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_position" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="qualification" class="form-label">Qualification<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="qualification" name="qualification" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_qualification" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="specialty" class="form-label">Specialty</label>
        <input type="text" class="form-control" id="specialty" name="specialty" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_specialty" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="experience" class="form-label">Experience</label>
        <input type="text" class="form-control" id="experience" name="experience" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_experience" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="location" class="form-label">Location</span></label>
        <input type="text" class="form-control" id="location" name="location" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_location" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="work_type" class="form-label">Work Type</label>
        <div class="input-group">
            <select class="single-select form-control" name="work_type">
                <option value="Full-Time">Full Time</option>
                <option value="Part-Time">Part Time</option>
                <option value="Remote">Remote</option>
                <option value="Contract">Contract</option>
            </select>
        </div>
        <span class="text-danger error_work_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="no_of_vacancies" class="form-label">No Of  Vacancies</label>
        <input type="number" class="form-control" id="no_of_vacancies" name="no_of_vacancies" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_work_type" style="display:none;">This field is required.</span>
    </div>
     <div class="col-md-6">
        <label for="job_apply_link" class="form-label">Job Apply Link</label>
        <input type="text" class="form-control" id="job_apply_link" name="job_apply_link" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_job_apply_link" style="display:none;">This field is required.</span>
    </div> 
    <div class="col-md-6">
        <label for="start_date" class="form-label">Start Date</label>
        <div class="input-group">
            <input type="text" name="start_date" class="form-control" id="start_date" autocomplete="off" readonly style="cursor: pointer;" value="{!! date('d-m-Y') !!}">
        </div>
        <span class="text-danger error_start_date" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="end_date" class="form-label">End Date</label>
        <input type="text" name="end_date" class="form-control" id="end_date" autocomplete="off" readonly style="cursor: pointer;" value="{!! date('d-m-Y') !!}">
        <span class="text-danger error_end_date" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority</label>
        <input type="text" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
</form>
<script type="text/javascript">
      $("#priority").on('input', function() {
          const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
          $("#priority").val(onlyNumbers);
      });
</script>