<form class="row g-3 auto-width" action="{{ route('career-vacancy.update',$vacancy->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-6">
        <label for="position" class="form-label">Position <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="position" name="position" aria-describedby="inputGroupPrepend" required value="{{$vacancy->position}}">
        <span class="text-danger error_position" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="qualification" class="form-label">Qualification</label>
        <input type="text" class="form-control" id="qualification" name="qualification" aria-describedby="inputGroupPrepend" required value="{{$vacancy->qualification}}">
        <span class="text-danger error_qualification" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="specialty" class="form-label">Specialty</label>
        <input type="text" class="form-control" id="specialty" name="specialty" aria-describedby="inputGroupPrepend" required value="{{$vacancy->specialty}}">
        <span class="text-danger error_specialty" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="experience" class="form-label">Experience</label>
        <input type="text" class="form-control" id="experience" name="experience" aria-describedby="inputGroupPrepend" required value="{{$vacancy->experience}}">
        <span class="text-danger error_experience" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="location" class="form-label">Location</span></label>
        <input type="text" class="form-control" id="location" name="location" aria-describedby="inputGroupPrepend" required value="{{$vacancy->location}}">
        <span class="text-danger error_experience" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="location" class="form-label">Location</label>
        <input type="text" class="form-control" id="location" name="location" aria-describedby="inputGroupPrepend" required value="{{$vacancy->location}}">
        <span class="text-danger error_location" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="work_type" class="form-label">Work Type</label>
        <div class="input-group">
            <select class="single-select form-control" name="work_type">
                <option value="Full-Time" {{ $vacancy->work_type ==  'Full-Time' ? 'selected' : '' }}>Full Time</option>
                <option value="Part-Time" {{ $vacancy->work_type ==  'Part-Time' ? 'selected' : '' }}>Part Time</option>
                <option value="Remote"{{ $vacancy->work_type == 'Remote'  ? 'selected' : '' }}>Remote</option>
                <option value="Contract"{{ $vacancy->work_type == 'Contract' ? 'selected' : '' }}>Contract</option>
            </select>
        </div>
        <span class="text-danger error_work_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="no_of_vacancies" class="form-label">No Of Vacancies</label>
        <input type="number" class="form-control" id="no_of_vacancies" name="no_of_vacancies" aria-describedby="inputGroupPrepend" required value="{{$vacancy->no_of_vacancies}}">
        <span class="text-danger error_no_of_vacancies" style="display:none;">This field is required.</span>
    </div>
     <div class="col-md-6">
        <label for="job_apply_link" class="form-label">Job Apply Link</label>
        <input type="text" class="form-control" id="job_apply_link" name="job_apply_link" aria-describedby="inputGroupPrepend" required value="{{$vacancy->job_apply_link}}">
        <span class="text-danger error_job_apply_link" style="display:none;">This field is required.</span>
    </div> 
    <div class="col-md-6">
        <label for="start_date" class="form-label">Start Date</label>
       <input type="" name="start_date" class="form-control" id="start_date" autocomplete="off"  readonly style="cursor: pointer;" required value="{{ !empty($vacancy->start_date) ? date('m/d/Y', strtotime($vacancy->start_date)) : '' }}">
        <span class="text-danger error_start_date" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="end_date" class="form-label">End Date</label>
        <input type="" name="end_date" class="form-control" id="end_date" autocomplete="off"  readonly style="cursor: pointer;" required value="{{ !empty($vacancy->end_date) ? date('m/d/Y', strtotime($vacancy->end_date)) : '' }}">
        <span class="text-danger error_end_date" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority</label>
        <input type="text" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend" required value="{{$vacancy->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
</form>
<script type="text/javascript">
      $("#priority").on('input', function() {
          const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
          $("#priority").val(onlyNumbers);
      });
</script>