@extends('layouts.app')
@section('title','Cash Flow Statement')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
  .thbutton {
    width: 7% !important;
}
</style>
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

    <!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6">Cash Flow Statement</div>
    <div class="col-md-6">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb justify-content-md-end mb-0">
                <li class="breadcrumb-item">
                    <i
                        class="bi bi-info-circle-fill text-info show-help-support"
                        data-id="40"
                        data-bs-toggle="modal"
                        data-bs-target="#commonModal"
                    ></i>
                </li>
                <li class="breadcrumb-item" aria-current="page">Accounts</li>
                <li class="breadcrumb-item active" aria-current="page">
                    <i class="bi bi-dot"></i> Cash Flow Statement
                </li>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="{{ route('all-transactions.index') }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                    </div>
                </div>
            </ol>
        </nav>
    </div>
</div>
<!--end breadcrumb-->
  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row">
            <div class="col-2" style="width: 20%"></div>
            <div class="col-7" style="text-align: center">
                <p style="color: #0b5ed7; font-size: 18px; margin-bottom: -4px !important;"><b></b></p>
                <p style="font-size: 14px; text-decoration: underline">
                    <b>CASH FLOW STATEMENT</b>
                </p>
                <p style="padding-bottom: 5px; font-size: 11px">
                    <b>Cashbook Entries </b>
                    <b>From Date <span style="color: #698aff" id=""> 31-08-2024</span> TO Date <span style="color: #698aff" id="">31-08-2024</span></b>
                </p>
            </div>
            <div class="col-2" style="text-align: right; width: 20%"></div>
        </div>

        <div>
            <table class="table table-borderless report-container">
                <tbody class="report-content">
                    <tr>
                        <td class="report-content-cell">
                            <div class="row">
                                <div class="col-12">
                                    <!-- 1st Table -->
                                    <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                        <thead>
                                            <tr class="text-uppercase">
                                                <h5 class="text-center" style="text-decoration: underline;">Inflow Amount
                                                </h5>
                                                <th style="text-align: left">Sl No</th>
                                                <th style="text-align: left">Voucher Type</th>
                                                <th style="text-align: left">Cash Amount</th>
                                                <th style="text-align: left">Bank Amount</th>
                                                <th style="text-align: left">Online Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="border-1">
                                                <td style="text-align: left"></td>
                                                <td style="text-align: left">Pathology Billing<br /></td>
                                                <td style="text-align: left">10750.00</td>
                                                <td style="text-align: left">8500.00<br /></td>
                                                <td style="text-align: left">14350.00</td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">1</td>
                                                <td style="text-align: left">OPD Billing<br /></td>
                                                <td style="text-align: left">4000.00</td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">1500.00</td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">2</td>
                                                <td style="text-align: left">IPD Billing<br /></td>
                                                <td style="text-align: left">18000.00</td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">3</td>
                                                <td style="text-align: left">IPD Advance<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">4</td>
                                                <td style="text-align: left">Manual Money Receipt<br /></td>
                                                <td style="text-align: left">1725.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">666.00<br /></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">5</td>
                                                <td style="text-align: left">Contra Payment<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">93500.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left"></td>
                                                <td style="text-align: left"><b>Total</b> <br /></td>
                                                <td style="text-align: left"><b> 34475.00</b> <br /></td>
                                                <td style="text-align: left"><b> 102000.00 </b><br /></td>
                                                <td style="text-align: left"><b> 16516.00</b><br /></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- 2nd Table  -->
                                    <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                        <thead>
                                            <tr class="text-uppercase">
                                                <h5 class="text-center" style="text-decoration: underline;">Outflow Amount</h5>
                                                <th style="text-align: left"></th>
                                                <th style="text-align: left"></th>
                                                <th style="text-align: left">Cash Amount</th>
                                                <th style="text-align: left">Bank Amount</th>
                                                <th style="text-align: left">Online Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="border-1">
                                                <td style="text-align: left">6</td>
                                                <td style="text-align: left">Expenditure<br /></td>
                                                <td style="text-align: left">6355.00</td>
                                                <td style="text-align: left">0.00 <br /></td>
                                                <td style="text-align: left">0.00 <br /></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">7</td>
                                                <td style="text-align: left">Contra Payment<br /></td>
                                                <td style="text-align: left">93500.00</td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td> 
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">8</td>
                                                <td style="text-align: left">Doctors Pay<br/></td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                                <td style="text-align: left">0.00<br /></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left"></td>
                                                <td style="text-align: left"><b>Total</b> <br /></td>
                                                <td style="text-align: left"><b> 99855.00</b> <br /></td>
                                                <td style="text-align: left"><b> 0.00 </b><br /></td>
                                                <td style="text-align: left"><b> 0.00 </b><br /></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <!-- 3rd Table  -->
                                    <table class="table table-bordered-print w-100 table-only-header-full-width mb-1 mt-3" id="quotation_products">
                                        <thead></thead>
                                        <tbody>
                                            <tr class="border-1">
                                                <td style="text-align: left">Opening Cash :</td>
                                                <td style="text-align: left">107915.14</td>
                                                <td style="text-align: left">Opening Bank :</td>
                                                <td style="text-align: left">7273699.00</td>
                                                <td style="text-align: left">Opening Online :</td>
                                                <td style="text-align: left">2512967.00</td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">Cash Inflow :</td>
                                                <td style="text-align: left">34475.00</td>
                                                <td style="text-align: left">Bank Inflow :</td>
                                                <td style="text-align: left">102000.00</td>
                                                <td style="text-align: left">Online Inflow :</td>
                                                <td style="text-align: left">16516.00</td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left">Cash Outflow :</td>
                                                <td style="text-align: left">99855.00</td>
                                                <td style="text-align: left">Bank Outflow :</td>
                                                <td style="text-align: left">0.00</td>
                                                <td style="text-align: left">Online Outflow :</td>
                                                <td style="text-align: left">0.00</td>
                                            </tr>
                                            <tr class="border-1">
                                                <td style="text-align: left"><b>Closing Cash : </b></td>
                                                <td style="text-align: left"><b>42535.14 </b>
                                                </td><td style="text-align: left"><b>Closing Bank : </b></td>
                                                <td style="text-align: left"><b>7375699.00 </b></td>
                                                <td style="text-align: left"><b>Closing Online : </b></td>
                                                <td style="text-align: left"><b>2529483.00 </b></td>
                                            </tr>
                                            <tr class="border-1">
                                                <td colspan="2" style="text-align: left"><b >Cash A/c : <span class="text-success">Cash Account (Link-Cash)</span></b>
                                                </td>
                                                <td colspan="2" style="text-align: left"><b>Bank A/c :<span class="text-success">SBI (CC) Link-Card</span></b>
                                                </td>
                                                <td colspan="2" style="text-align: left"><b>Online A/c :<span class="text-success">SBI (Current A/C)LInk-UPI</span></b>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
  <script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }


    $(document).ready(function(){
      $( function() {
          $('.datepicker').datepicker({
            format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
            autoclose: true,
        })
        .on('changeDate', function (ev) {
            $(this).datepicker('hide');

            var page  = $('[name="hidden_page"]').val();
            var query = $('#search').val()?$('#search').val():'';
            var sort_type = $('#hidden_sort_type').val();
            var column_name = $('.sorting').val()?$('.sorting').val():'';
            fetch_data(page,sort_type,column_name, query)
        })

      });

      function fetch_data(page, sort_type, sort_by, query){
        var start_date   = $('#start_date').val();
        var end_date     = $('#end_date').val();
        var voucher_type = $('#voucher_type').val();

        $.ajax({
          url:"?page="+page+"&query="+query+"&start_date="+start_date+"&end_date="+end_date+"&voucher_type="+voucher_type+"&sort_by="+sort_by,
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

       /******** searching ********/
    $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        fetch_data(page, sort_type, column_name, query);
    }, 700));


      $('body').on('change', '#voucher_type', function(){
        var query = $('#search').val();
        var page = 1;

        if (query.length < 2 && query.length != 0) {
          return;
        }
        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        fetch_data(page, sort_type, column_name, query);
      });
      $('body').on('change', '.sorting', function(){

        var column_name = $(this).val();
        console.log('perpage',column_name);
        var order_type = $(this).data('sorting_type');
        var reverse_order = '';
        var page = 1?1:(this).attr('href').split('page=')[1];
        var query = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
        });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page  = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type = $('#hidden_sort_type').val();
        var query = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');

        fetch_data(page, sort_type, column_name, query);
      });
    });
  </script>
@endsection
