 <div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Addresses</h5>
        @if(in_array('company-addresses-create', $authRolePermissions))
        <button type="button" class="btn btn-info" id="createAddress"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Address</th>
                <th>Priority</th>
                <th class="thbutton">Default</th>
                <th class="thbutton">Status</th>
                <!-- <th class="thbutton">Details</th> -->
                @if(in_array('company-addresses-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('company-addresses-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{1 + $key}}</td>
                        <td>
                           <u> <h6> {{$list->address_types}}:</h6></u>

                            {!! $list->address_1 != '' ? $list->address_1 . ',' : '' !!}
                            {!! $list->address_2 != '' ? $list->address_2 . ',' : '' !!}<br>
                            {!! $list->district_name != '' ? '<strong>District</strong>: ' . $list->district_name . ', ' : '' !!}
                            {!! $list->taluka_name != '' ? '<strong>Taluka</strong>: ' . $list->taluka_name . ', ' : '' !!}
                            {!! $list->country != '' ? '<strong>Country</strong>: ' . $list->country . ', ' : '' !!}
                            {!! $list->state != '' ? '<strong>State/Province</strong>: ' . $list->state . ', ' : '' !!}<br>
                            {!! $list->city != '' ? '<strong>City</strong>: ' . $list->city  : '' !!},
                            {!! $list->pin_code != '' ? '<strong>PIN/ZIP</strong>: ' . $list->pin_code . '' : '' !!}
                        </td>
                        <!-- <td class="text-center">
                            <a href="{{route('companies-addresses.show',$list->id)}}" class="btn btn-info" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-search text-white"></i>
                            </a>
                        </td> -->
                        <td class="thbutton">{{ $list->priority }}</td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus address" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('companies-addresses.changedefault')}}" data-id="{{$list->id}}" data-status="{{$list->is_default=='0' ? '1' : '0'}}" {{ $list->is_default=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus address" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('companies-addresses.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('company-addresses-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $list->id }}" class="btn btn-warning editAddress" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('company-addresses-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('companies-addresses.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData address" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="5">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

