<form class="row g-3 auto-width license" action="{{ route('company-documents.update', $license->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <div>
            <label for="license_type_id" class="form-label">Company Document Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="license_type_id">
                @foreach($types as $list)
                <option value="{{ $list->id }}" {{$license->license_type_id == $list->id ? 'selected' : ''}}>{{ $list->license_type_name }}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_license_types" type="button" style="border-radius: 20px;"> + </button>
            </div>
        </div>
        <span class="text-danger error_license_type_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="license_number" class="form-label">License Number <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="license_number" name="license_number" aria-describedby="inputGroupPrepend" required value="{{$license->license_number}}">
        <span class="text-danger error_license_number" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="attachment" class="form-label">Attachment <span class="text-danger"><b>*</b></span></label>
        <input type="file" class="form-control" id="attachment" name="attachment" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_attachment" style="display: none;">This field is required.</span>
    </div>
    @if($license->attachment != '')
    <div class="col-md-6 d-flex align-items-end">
        <a class="btn btn-info" href="{!! $license->attachment !!}" download="true">Previous Attachment</a>
    </div>
    @endif
    <div class="col-md-6">
        <label for="valid_from" class="form-label">Valid From </label>
        <input type="text" class="form-control datepicker" id="valid_from" name="valid_from" value="{{ date('d-m-Y', strtotime($license->valid_from)) }}" readonly>
        <span class="text-danger error_valid_from" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="valid_upto" class="form-label">Valid Upto </label>
        <input type="text" class="form-control datepicker" id="valid_upto" name="valid_upto" value="{{ date('d-m-Y', strtotime($license->valid_upto)) }}" readonly>
        <span class="text-danger error_valid_upto" style="display: none;">This field is required.</span>
    </div>
    <div class="col-12 justify-content-center mb-3">
    <div style="" class="accordion-item">
        <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                license style
            </button>
        </h2>
        <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
            <div class="accordion-body">
                <div class="row">
                    <div class="col-md-6">
                        <label for="page_position" class="form-label">Page Position </label>
                        <select class="form-control" name="page_position">
                            <option value="Header" {!! $license->page_position=='Header'?'selected':'' !!}>Header</option>
                            <option value="Footer" {!! $license->page_position=='Footer'?'selected':'' !!}>Footer</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="view_priority" class="form-label">View Priority </label>
                        <select class="form-control" name="view_priority">
                            <option value="Top" {!! $license->view_priority=='Top'?'selected':'' !!}>Top</option>
                            <option value="Bottom" {!! $license->view_priority=='Bottom'?'selected':'' !!}>Bottom</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
