 <div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Bussiness Documents</h5>
        @if(in_array('company-documents-create', $authRolePermissions))
            <button type="button" class="btn btn-info" id="createLicenses"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>License</th>
                <th>Validity Period</th>
                <th class="thbutton">Attachment</th>
                <th class="thbutton">Status</th>
                @if(in_array('company-documents-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('company-documents-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{1 + $key}}</td>
                        <td>
                            <strong>{!! $list->license_type_name !!}</strong><br>
                            {!! $list->license_number !!}
                        </td>
                        <td>
                            @php $auth_format = \Session::get('company_data')['date_format'] ?? ''; @endphp

                            {{ date($auth_format, strtotime($list->valid_from)) }} - {{ date($auth_format, strtotime($list->valid_upto)) }}
                        </td>
                        <td>
                            @if($list->file_url != '')
                                <a class="btn btn-info" href="{{ route('bucket_file_download', ['filename' => $list->file_url]) }}">Download</a>

                            @endif
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus licenses" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('company-documents.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->license_status=='0' ? '1' : '0'}}" {{ $list->license_status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('company-documents-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $list->id }}" class="btn btn-warning editLicenses" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('company-documents-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('company-documents.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData licenses" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="5" >No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

