<form class="row g-3 auto-width company_images company_image_update" action="{{ route('companies-images.update', $data->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <!-- Image Url -->
    @if($data->image_url != '')
    <div class="col-md-12 d-flex align-items-end">
        <a href="{{ route('bucket_file_download', ['filename' => $data->file_url]) }}"><img src="{!! $data->file_url !!}" height="auto" id="createImage" data-bs-toggle="modal" data-bs-target="#commonModal" style="cursor: pointer;max-width: 40%;width: 40%;"></a>
    </div>
    @endif
    <div class="col-md-12">
        <label for="image_url" class="form-label">New Image Url <span class="text-danger"><b>*</b></span></label>
        <input type="file" class="form-control" id="image_url" name="image_url" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_image_url" style="display: none;">This field is required.</span>
    </div>
    <!-- Image Type -->

    <div class="col-md-12">
        <label for="image_type" class="form-label">Image Type/Position <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" aria-label="image_type" name="image_type">
            <option value="logo" {{ matchSelected($data->image_type,'logo') }}>LOGO</option>
            <option value="header" {{ matchSelected($data->image_type,'header') }}>HEADER</option>
            <option value="footer" {{ matchSelected($data->image_type,'footer') }}>FOOTER</option>
            <option value="watermark" {{ matchSelected($data->image_type,'watermark') }}>WATERMARK</option>
        </select>
        <span class="text-danger error_image_type" style="display:none;">This field is required.</span>
    </div>

    <!-- Height  -->
    <div class="col-md-6">
        <label for="height" class="form-label">Image Height<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="height" name="height" aria-describedby="inputGroupPrepend" placeholder="Enter Height" required value="{{$data->height}}">
        <span class="text-danger error_height" style="display:none;">This field is required.</span>
    </div>
    <!-- Width  -->
    <div class="col-md-6">
        <label for="width" class="form-label">Image Width<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="width" name="width" aria-describedby="inputGroupPrepend" placeholder="Enter Width" required value="{{$data->width}}">
        <span class="text-danger error_width" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="margin" class="form-label">Margin <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="number" id="top_margin" name="top_margin" class="form-control" placeholder="Top Margin" maxlength="4"  value="{{$data->top_margin}}">
            <input type="number" id="bottom_margin" name="bottom_margin" class="form-control" placeholder="Bottom Margin" value="{{$data->bottom_margin}}">
            <input type="number" id="left_margin" name="left_margin" class="form-control" placeholder="Left Margin" value="{{$data->left_margin}}">
            <input type="number" id="right_margin" name="right_margin" class="form-control" placeholder="Right Margin" value="{{$data->right_margin}}">
        </div>
        <div class="d-flex justify-content-around">
            <div>Top Margin</div>
            <div>Left Margin</div>
            <div>Right Margin</div>
            <div>Bottom Margin</div>
        </div>
        <span class="text-danger error_margin" style="display:none;">The field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="padding" class="form-label">Padding <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="number" id="top_padding" name="top_padding" class="form-control" placeholder="Top Padding" maxlength="4" value="{{$data->top_padding}}">
            <input type="number" id="bottom_padding" name="bottom_padding" class="form-control" placeholder="Bottom Padding" value="{{$data->bottom_padding}}">
            <input type="number" id="left_padding" name="left_padding" class="form-control" placeholder="Left Padding" value="{{$data->left_padding}}">
            <input type="number" id="right_padding" name="right_padding" class="form-control" placeholder="Right Padding" value="{{$data->right_padding}}">
        </div>
        <div class="d-flex justify-content-around">
            <div>Top Padding</div>
            <div>Left Padding</div>
            <div>Right Padding</div>
            <div>Bottom Padding</div>
        </div>
        <span class="text-danger error_padding" style="display:none;">The field is required.</span>
    </div>
    <!-- Alignment  -->
    <div class="col-md-6">
        <label for="alignment" class="form-label">Alignment <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" aria-label="alignment" name="alignment">
            <option value="left" {{ matchSelected($data->alignment,'left') }}>Left</option>
            <option value="center" {{ matchSelected($data->alignment,'center') }}>Center</option>
            <option value="right" {{ matchSelected($data->alignment,'right') }}>Right</option>
            <option value="justify" {{ matchSelected($data->alignment,'justify') }}>Justify</option>
        </select>
        <span class="text-danger error_alignment" style="display:none;">This field is required.</span>
    </div>
    <!-- Priority  -->
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{{$data->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>


</form>
