<form class="g-3 auto-width row" action="{{ route('license.store')}}" method="post" enctype='multipart/form-data'>
  <!-- For validation comment on -->
  @csrf
  <div class="col-md-12">
    <label for="validationCustom01" class="form-label">Country Name <span class="text-danger"><b>*</b></span></label>
    <select class="form-control single-select" name="country_id">
      <option value="">Select</option>
      @foreach($countries as $list)
      <option value="{{ $list->id }}" {!! matchSelected($list->id, $country_id) !!}>{{ $list->name }}</option>
      @endforeach
    </select>
    <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
  </div>
  <div class="col-md-12">
    <label for="validationTextarea" class="form-label">Document Type Name <span class="text-danger"><b>*</b></span></label>
    <input type="text" class="form-control" placeholder="Ex.GST License" name="license_type_name"  value="{{old('license_type_name')}}"/>
    <span class="text-danger error_license_type_name" style="display:none;">This field is required.</span>
  </div>
  <div class="col-md-6">
    <label for="validationTextarea" class="form-label">Document Code <span class="text-danger"><b>*</b></span></label>
    <input type="text" class="form-control" placeholder="Ex.CODE123" name="license_code" value="{{old('license_code')}}" />
    <span class="text-danger error_license_code" style="display:none;">This field is required.</span>
  </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="data_length" class="form-label">Data Length <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="data_length" name="data_length" aria-describedby="inputGroupPrepend" required placeholder="Data Length" value="20">
        <span class="text-danger error_data_length" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="value_type" class="form-label">Value Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" name="value_type">
            <option value="number">Numbers</option>
            <option value="text">Text</option>
            <option value="number_and_text" selected>Numbers and Text</option>
        </select>
        <span class="text-danger error_value_type" style="display:none;">This field is required.</span>
    </div>
</form>