@extends('layouts.app')
@section('title','Add New Company')
@section('pages')

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="bradcrumb-title pe-3"><i class="bi bi-list"></i> Company</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcumb mb-0 p-0" style="list-style-type:none">
                
                <li class="breadcrumb-item active" aria-current="page">Add New License</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{route('companies.add.license')}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        @csrf
                        <div class="col-md-6">
                        <div class="card">
                            <div class="card-body g-3 row">
                                <h5>Company License Types</h5>
                                <div class="col-md-12">
                                    <label for="validationTextarea" class="form-label">License Type Name</label>
                                    <input type="text" class="form-control" placeholder="Ex.GST License" name="license_type_name"  value="{{old('license_type_name')}}"/>
                                </div>
                                <div class="col-md-12">
                                    <label for="validationTextarea" class="form-label">License Code</label>
                                    <input type="text" class="form-control" placeholder="Ex.CODE123" name="license_code" value="{{old('license_code')}}" />
                                </div>
                                <div class="col-12">
                                    <!-- <button class="btn btn-light me-2" type="reset"><i class="bx bx-revision ms-0 me-1"></i>Clear</button> -->
                                    <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Save Data</button>
                                </div>
                            </div>
                        </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
<script>

    function changecontry()
    {
        let country=$('#country').val();

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getstate') }}",
            data: {country:country},
            success: function (data) {
                $('#states').html(data);
            },
            error: function (data) {
                //console.log(data);
            }
        });
    }

    function getcity()
    {
        let states_id=$('#states').val();

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcity') }}",
            data: {states_id:states_id},
            success: function (data) {
                $('#cities').html(data);
            },
            error: function (data) {
                //console.log(data);
            }
        });
    }
</script>
@endsection