@if(!empty($letterHead) && $letterHead->full_image == '1' && !empty($letterHead->image_url))
    @php
        $letterHead->image_style     = is_string($letterHead->image_style) ? json_decode($letterHead->image_style, true) : $letterHead->image_style;
        $letterHead->title_style     = is_string($letterHead->title_style) ? json_decode($letterHead->title_style, true) : $letterHead->title_style;
        $letterHead->sub_title_style = is_string($letterHead->sub_title_style) ? json_decode($letterHead->sub_title_style, true) : $letterHead->sub_title_style;
    @endphp
    <style type="text/css">
        .company_letter_head {
            height: {!! $letterHead->image_style['image_height'] ?? '' !!}px !important;
            width: {!! $letterHead->image_style['image_width'] ?? '' !!}px !important;

            {!! isset($letterHead->image_style['image_margin']) && $letterHead->image_style['image_margin'] != '' ? 'margin:' . $letterHead->image_style['image_margin'] . 'px;' : '' !!}
            {!! isset($letterHead->image_style['image_padding']) && $letterHead->image_style['image_padding'] != '' ? 'padding:' . $letterHead->image_style['image_padding'] . 'px;' : '' !!}
        }
    </style>
@else
    <style type="text/css">
        .company_letter_head {
            height: {!! $company->getCompanyImage->height ?? '' !!}px !important;
            width: {!! $company->getCompanyImage->width ?? '' !!}px !important;
            {!! isset($company->getCompanyImage->top_margin) && $company->getCompanyImage->top_margin != '' ? 'margin-top:' . $company->getCompanyImage->top_margin . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->bottom_margin) && $company->getCompanyImage->bottom_margin != '' ? 'margin-bottom:' . $company->getCompanyImage->bottom_margin . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->left_margin) && $company->getCompanyImage->left_margin != '' ? 'margin-left:' . $company->getCompanyImage->left_margin . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->right_margin) && $company->getCompanyImage->right_margin != '' ? 'margin-right:' . $company->getCompanyImage->right_margin . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->top_padding) && $company->getCompanyImage->top_padding != '' ? 'padding-top:' . $company->getCompanyImage->top_padding . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->bottom_padding) && $company->getCompanyImage->bottom_padding != '' ? 'padding-bottom:' . $company->getCompanyImage->bottom_padding . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->left_padding) && $company->getCompanyImage->left_padding != '' ? 'padding-left:' . $company->getCompanyImage->left_padding . 'px;' : '' !!}
            {!! isset($company->getCompanyImage->right_padding) && $company->getCompanyImage->right_padding != '' ? 'padding-right:' . $company->getCompanyImage->right_padding . 'px;' : '' !!}
        }
    </style>
@endif
@if(!empty($letterHead) && isset($letterHead->status) && $letterHead->status == 1)
<div class="row mx-0" id="header">
    @php
        $img_url = !empty($letterHead->custom_logo_url) ? getTempUrl($letterHead->custom_logo_url) : (isset($company->file_url) && $company->file_url != '' ? $company->file_url : '');
        if ($letterHead->hide_logo == '1') {
            $img_url = '';
        }
    @endphp

    @if($letterHead->hide_logo == '0' && $letterHead->full_image == '1' && !empty($letterHead->image_url))
        @php
            $img_url = !empty($letterHead->image_url) ? getTempUrl($letterHead->image_url) : '';
        @endphp
        <div class="col-12 text-left gx-1 letter-head-logo h-100 my-auto" style="padding-right: 0px;">
            @if ($img_url != '' && request()->segment(1) != 'sale-invoice')
                <img class="img-thumbnail border-0 company-logo-thumbnail company_letter_head" src="{!! $img_url !!}" alt="Logo" style="max-height: 100%;">
            @endif
        </div>
    @else
        @if($letterHead->logo_position == 'left')
        <div class="col-4 text-left gx-1 letter-head-logo h-100 my-auto" style="padding-right: 0px;">
            @if ($img_url != '' && request()->segment(1) != 'sale-invoice')
                <img class="img-thumbnail border-0 company-logo-thumbnail company_letter_head" src="{!! $img_url !!}" alt="Logo" style="max-height: 100%;">
            @endif
        </div>
        @endif
        <div class="col-8 gx-1 letter-head-company-details" style="{!! $letterHead->content_alignment == 'right' ? 'text-align: right;' : ''; !!}">
            <span class="m-0 p-0" style="font-size: 20px;"><b>{!! !empty($voucherTypeDetails) && $voucherTypeDetails->code == 'SALES' ? ($voucherTypeDetails->page_title ?? '') : ($company->name ?? '') !!}</b></span>{!! $letterHead->custom_logo_url !!}
            <div class="row">

                <div class="col-md-12">
                    @php
                        $licenses = companyLicenses($company->id);
                        $count = count($licenses);
                    @endphp
                    @foreach (companyLicenses($company->id) as $index => $value)
                        <b>{!! $value->license_type_name !!} - {!! $value->license_number !!}</b>
                        @if ($index < $count - 1)
                            ,&nbsp;
                        @endif
                    @endforeach
                </div>
                <div class="col-md-12">
                    @php
                    $address = generate_comma_separated_string(
                    ['address'=> $company->getCompanyAddress->address_1,
                    'city' => $company->getCompanyAddress->getComapnyCity->name,
                    'state' => $company->getCompanyAddress->getComapnyState->name,
                    'country' => $company->getCompanyAddress->getComapnyCountry->name,
                    'pincode' => $company->getCompanyAddress->pin_code]);
                    @endphp

                    {!! $address !!}
                </div>
                <div class="col-md-12">
                    @php $companyNumber = generate_comma_separated_string(
                    ['mobile_number' => $company->mobile_number,
                    'phone_number' => $company->phone_number,
                    'whatsapp_no' => $company->whatsapp_no?('Whatsapp'.': '.$company->whatsapp_no):'',
                    ]);
                    @endphp
                    PHONE- {!! $companyNumber !!}

                </div>
                <div class="col-md-12">
                    @php
                    $companyEmail = generate_comma_separated_string(
                    ['email' => $company->email,
                    'website' => $company->website,
                    ]);
                    @endphp
                    EMAIL- {!! $companyEmail !!}
                </div>

            </div>
        </div>
        @if($letterHead->logo_position != 'left')
        <div class="col-4 text-right gx-1 text-end letter-head-logo h-100 my-auto" style="padding-right: 0px;">
            @if ($img_url != '' && request()->segment(1) != 'sale-invoice')
                <img class="img-thumbnail border-0 company-logo-thumbnail company_letter_head" src="{!! $img_url !!}" alt="Logo" style="max-height: 100%;">
            @endif
        </div>
        @endif
    @endif
</div>
@else
<style type="text/css">
    .company_letter_head {
        height: {!! $company->getCompanyImage->height ?? '' !!}px !important;
        width: {!! $company->getCompanyImage->width ?? '' !!}px !important;
        {!! isset($company->getCompanyImage->top_margin) && $company->getCompanyImage->top_margin != '' ? 'margin-top:' . $company->getCompanyImage->top_margin . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->bottom_margin) && $company->getCompanyImage->bottom_margin != '' ? 'margin-bottom:' . $company->getCompanyImage->bottom_margin . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->left_margin) && $company->getCompanyImage->left_margin != '' ? 'margin-left:' . $company->getCompanyImage->left_margin . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->right_margin) && $company->getCompanyImage->right_margin != '' ? 'margin-right:' . $company->getCompanyImage->right_margin . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->top_padding) && $company->getCompanyImage->top_padding != '' ? 'padding-top:' . $company->getCompanyImage->top_padding . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->bottom_padding) && $company->getCompanyImage->bottom_padding != '' ? 'padding-bottom:' . $company->getCompanyImage->bottom_padding . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->left_padding) && $company->getCompanyImage->left_padding != '' ? 'padding-left:' . $company->getCompanyImage->left_padding . 'px;' : '' !!}
        {!! isset($company->getCompanyImage->right_padding) && $company->getCompanyImage->right_padding != '' ? 'padding-right:' . $company->getCompanyImage->right_padding . 'px;' : '' !!}
    }
</style>
<div class="row mx-0" id="header">
    <div class="col-8 gx-1 letter-head-company-details">
        <span class="m-0 p-0" style="font-size: 20px;"><b>{!! !empty($voucherTypeDetails) && $voucherTypeDetails->code == 'SALES' ? ($voucherTypeDetails->page_title ?? '') : ($company->name ?? '') !!}</b></span>
        <div class="row">

            <div class="col-md-12">
                @foreach (companyLicenses($company->id) as $value)
                <b>{!! $value->license_type_name !!} - {!! $value->license_number !!}</b>, &nbsp;
                @endforeach
            </div>
            <div class="col-md-12">
                @php
                $address = generate_comma_separated_string(
                ['address'=> $company->getCompanyAddress->address_1,
                'city' => $company->getCompanyAddress->getComapnyCity->name,
                'state' => $company->getCompanyAddress->getComapnyState->name,
                'country' => $company->getCompanyAddress->getComapnyCountry->name,
                'pincode' => $company->getCompanyAddress->pin_code]);
                @endphp

                {!! $address !!}
            </div>
            <div class="col-md-12">
                @php $companyNumber = generate_comma_separated_string(
                ['mobile_number' => $company->mobile_number,
                'phone_number' => $company->phone_number,
                'whatsapp_no' => $company->whatsapp_no?('Whatsapp'.': '.$company->whatsapp_no):'',
                ]);
                @endphp
                PHONE- {!! $companyNumber !!}

            </div>
            <div class="col-md-12">
                @php
                $companyEmail = generate_comma_separated_string(
                ['email' => $company->email,
                'website' => $company->website,
                ]);
                @endphp
                EMAIL- {!! $companyEmail !!}
            </div>

        </div>
    </div>

    <div class="col-4 text-right gx-1 text-end letter-head-logo h-100 my-auto" style="padding-right: 0px;">
        @if (isset($company->file_url) && $company->file_url != '' && request()->segment(1) != 'sale-invoice')
            <img class="img-thumbnail border-0 company-logo-thumbnail company_letter_head" src="{!! $company->file_url !!}" alt="Logo" style="max-height: 100%;">
        @endif
    </div>
</div>
@endif