<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<style>
   .clear{
    clear:both;
    margin-top: 20px;
    }

    .autocomplete{
        position: relative;
    }
    .autocomplete .searchResult{
        list-style: none;
        padding: 0px;
        width: 50%;
        position: absolute;
        margin: 0;
        margin-top: 40px;
        background: white;
        z-index: 5;
    }

    .autocomplete .searchResult li{
        background: #F2F3F4;
        padding: 10px;
        margin-bottom: 1px;
        white-space: break-spaces;
    }

    .autocomplete .searchResult li:nth-child(even){
        background: #E5E7E9;
        color: black;
    }

    .autocomplete .searchResult li:hover{
        cursor: pointer;
        background: #CACFD2;
    }
</style>
<div class="card-header py-3" style="border-radius:0px;">
    <div class="row gx-2 custom_grid align-items-end gx-0 mt-4 mb-3">

      <div class="col-lg-3 col-md-3 col-3">
        <div class="input-group">
          <label class="form-label">Company Name<span class="text-danger"><b></b></span></label>
          <select name="branch" class="form-control" id="branch">
            <option value="">-Select-</option>
            @foreach(allCompanies() as $key => $value)
            <option value="{!! $value->id !!}" {!! $value->is_default==1?'selected':'' !!}>{!! $value->name !!}</option>
            @endforeach
          </select>
        </div>
      </div>
 
      <div class="col-lg-2 col-md-2 col-2">
        <div class="input-group">
          <label class="form-label">User Name / ID<span class="text-danger"><b></b></span></label>
          <select name="created_by" class="form-control" id="created_by">
            @if(auth::user()->user_type=='admin')
            <option value="" selected>All User</option>
            @endif
              
            @foreach(allActiveUsers() as $key => $value)
           
            @if(auth::user()->user_type=='admin')
              <option value="{!! $value->id !!}" {!! $value->id==auth::user()->id && auth::user()->user_type!='admin'?'selected':''  !!}>{!! $value->name !!} ({!! $value->email !!})</option>
              @elseif($value->id==auth::user()->id)
              <option value="{!! $value->id !!}" {!! $value->id==auth::user()->id && auth::user()->user_type!='admin'?'selected':''  !!}>{!! $value->name !!} ({!! $value->email !!})</option>
              @endif
            @endforeach
          </select>
        </div>
      </div>

      <div class="col-lg-2 col-md-2 col-2">
        <div class="input-group">
          <label class="form-label">From Date <span class="text-danger"><b></b></span></label>
          <input class="form-control" type="text" id="from_date" name="from_date" placeholder="dd/mm/YY" value="">
        </div>
      </div>

      <div class="col-lg-2 col-md-2 col-2">
        <div class="input-group">
          <label class="form-label">To Date <span class="text-danger"><b></b></span></label>
          <input class="form-control" type="text" id="to_date" name="to_date" placeholder="dd/mm/YY" value="">
        </div>
      </div>

      <div class="col-lg-3 col-md-3 col-3">
        <div class="input-group autocomplete">
          <label class="form-label">Account Name<span class="text-danger"><b></b></span></label>
            <input type="text" id="account" class="account-select form-control" placeholder="Search account" value="">
            <ul class="searchResult"></ul>
            <a href="javascript:void(0)" class="hiddenReferral fw-bold" id="add_reference" style="padding: 10px;"><i class="bx bx-plus"></i></a>
            <input type="hidden" name="account" value="">
        </div>
      </div>
      <div class="col-lg-3 col-md-3 col-4">
      <div class="references mt-3" style="display:none;">
      <label class="form-label">Voucher Type</label>
            <select class="form-control" id="voucher_type" aria-controls="example">
              <option value="">All Voucher Type</option>
              @foreach(allVoucherTypes() as $key => $value)
                <option value="{!! $value->code !!}">{!! $value->name !!}</option>
              @endforeach
            </select>
      </div>
      </div>
      <div class="col-md-3">
        <div class="references mt-3" style="display:none;">
            <label class="form-label">Payment Mode</label>
            <select class="form-control" name="payment_mode" id="payment_mode">
              <option value=" ">Select All</option>
              @foreach(allPaymentAccountingGroups() as $list)
              @if(isset($list->chart_of_account_sub_type->paymentModes))
              @foreach($list->chart_of_account_sub_type->paymentModes as $value)
                  <option value="{!! $value->id !!}">{!! $value->mode !!}</option>
              @endforeach
              @endif
              @endforeach
            </select>
            <span class="text-danger error_refferal_id" style="display:none;">This field is required.</span>
        </div>
    </div>
     

    </div>

    <div class="row mt-2">
      <div class="col-lg-12 col-md-12 col-12 text-center">
        <button class="btn btn-primary" id="submit" type="button" style="height: 40px; width: 25% !important;"><i class="bi bi-search"></i> Search</button>
      </div>
    </div>

  </div>

  <script>
    
    $(document).on('click', '#add_reference', function() {
        if ($('#add_reference').hasClass('hiddenReferral')) {
            $('.references').show();
            $('#add_reference').html('<i class="bx bx-minus"></i>');
            $('#add_reference').removeClass('hiddenReferral');
        } else {
            $('.references').hide();
            $('#add_reference').html('<i class="bx bx-plus"></i>');
            $('#add_reference').addClass('hiddenReferral');
            $('.refferal-select').val('');
            $('.collection-select').val('');
            $('[name="refferal_id"]').val('');
            $('[name="collection_id"]').val('');
        }
      });
$(document).ready(function() {
$('.account-select').autocomplete({
        autoFocus: true,
        minLength: 0,
        source: function(request, response) {
            if (request.term.length < 2) {
                $('[name="account"]').val('');
                return false;
            }

            $.ajax({
                url: "{{ route('receipt-voucher-search-account') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'get_patients_for_billing',
                    search_text: request.term
                },
                success: function(json) {
                    if (json.error) {
                        $('[name="account"]').val('');
                        return false;
                    }
                    response($.map(json.result, function(item) {
                        return {
                            id: item.id,
                            name: item.name,
                            code: item.code,
                            phone_no: item.phone_no,
                        
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            event.preventDefault();
            var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
            var code = ui.item.code != null ? ', ' + ui.item.code : '';

            $(this).val(ui.item.name + code +  phone_no + "");
            $('[name="account"]').val(ui.item.id);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
        var code = item.code != null ? ', ' + item.code : '';

        return $("<li>")
            .append("<a>" + item.name + code  + phone_no + "</a>")
            .appendTo(ul);
    };

  });
  </script>