@if($voucherType=='PATHOLOGY_LAB_BILLING' || $voucherType=='PATHOLOGY' || $voucherType=='IPD_ADMISSION' || $voucherType=='SALES')
<div class="row border border-dark border-bottom-0 text-uppercase mx-0 font-12 mt-2" style="border-top: 1px solid #565656;border-bottom: 1px solid #565656; ">
    <div class="col-4"><b>Invoice No :
            {!! $sale_invoice->main_invoice_no ?? '' !!}</b>
    </div>
    <div class="col-4 text-center"><b>Date :
            {!! $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '' !!}</b>
    </div>
    <div class="col-4 text-center">
        <b style="margin-left: -22px !important;">Reff No. : {!! $sale_invoice->reff_no ?? '' !!}</b>
    </div>
</div>
@elseif($voucherType=='CONTRA' || $voucherType=='JOURNAL')
<div class="row border border-dark border-bottom-1 text-uppercase mx-0 font-12 mt-2" style="border-top: 1px solid #565656;border-bottom: 1px solid #565656; ">
    <div class="col-4"><b>Voucher No : {!! $sale_invoice->voucher_no ?? '' !!}</b>
    </div>
    <div class="col-4 text-center"><b>
            Date : {!! ($sale_invoice->transaction_date ? formatedDate($sale_invoice->transaction_date) : '') !!}</b>
    </div>
    <div class="col-4 text-center">
        <b style="margin-left: -22px !important;">Reff No. : {!! $sale_invoice->reference !!}</b>
    </div>
</div>
@elseif($voucherType=='OPD_BOOKING')
<div class="row border border-dark border-bottom-0 text-uppercase mx-0 font-12" style="border-top: 1px solid #565656;border-bottom: 1px solid #565656; width: auto !important;" >
    <div class="col-4 font-12" style="text-align: left;"><b>Invoice No : {!! $sale_invoice->booking_no ?? '' !!}</b></div>
    <div class="col-4 text-center font-12"><b>Date : {!! $sale_invoice->booking_date_time ? formatedDate($sale_invoice->booking_date_time) : '' !!}</b></div>
    <div class="col-4 text-right font-12" style="text-align: right;"> <b>Serial No. : {!! $sale_invoice->appointment_serial_no ?? '' !!}</b>
    </div>
</div>
<div class="row border border-dark border-bottom-0 text-uppercase mx-0 font-12" style="border-top: 1px solid #565656;border-bottom: 1px solid #565656; width: auto !important;">
    <div class="col-4 font-12" style="text-align: left;">
        <b>Appointment Date : {!! ($sale_invoice->appointment_date_time ? formatedDate($sale_invoice->appointment_date_time) : '') !!}</b>

    </div>
    <div class="col-4 text-center font-12"><b style="margin-left: -10px;">Time : {!! ($sale_invoice->appointment_date_time ? date('h:i A',strtotime($sale_invoice->appointment_date_time)) : '') !!}</b></div>
    <div class="col-4 text-left font-12" style="text-align: right;"><b>Ref. : {!! 'Walk In' !!}</b></div>
</div>
@endif
@if($voucherType=='PATHOLOGY_LAB_BILLING' || $voucherType=='PATHOLOGY' || $voucherType=='IPD_ADMISSION' || $voucherType=='SALES' || $voucherType=='OPD_BOOKING')
@php
$patient = $sale_invoice->getPatient;
$patientContact = $patient->account_contact ?? null;
$patientTitle = $patient->account_title??null;
$patientAddress = $patient->first_account_address ?? null;
$dateOfBirth = $patientContact->date_of_birth ?? '';
$age = $dateOfBirth != '' ? age($dateOfBirth) : 0;
$generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();

if($voucherType=='OPD_BOOKING')
{
    $ref_doctor = $sale_invoice->getDoctorAccount ? ucfirst(@$sale_invoice->getDoctorAccount->name) : 'Self';
    $doctorTitle = $sale_invoice->getDoctorAccount->account_title??null;
    $doctorQualification = $sale_invoice->getDoctorAccount->account_contact??null;
    $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
    $mainInvoiceNo = $sale_invoice->booking_no ?? '';
    $collectionAgent = $sale_invoice->getCollectionAgent? ucfirst(@$sale_invoice->getCollectionAgent->name):'';
    $collectionAgentTitle = $sale_invoice->getCollectionAgent->account_title??null;

    $referralLab = $sale_invoice->getRefferalLab?ucfirst(@$sale_invoice->getRefferalLab->name):'';
    $referralLabTitle = $sale_invoice->getRefferalLab->account_title??null;
}
else
{
    $ref_doctor = $sale_invoice->getDoctor ? ucfirst(@$sale_invoice->getDoctor->name) : 'Self';
    $doctorTitle = $sale_invoice->getDoctor->account_title??null;
    $doctorQualification = $sale_invoice->getDoctor->account_contact??null;

    $collectionAgent = $sale_invoice->getCollectionAgent? ucfirst(@$sale_invoice->getCollectionAgent->name):'';
    $collectionAgentTitle = $sale_invoice->getCollectionAgent->account_title??null;

    $referralLab = $sale_invoice->getRefferalLab?ucfirst(@$sale_invoice->getRefferalLab->name):'';
    $referralLabTitle = $sale_invoice->getRefferalLab->account_title??null;
    $mainInvoiceNo = $sale_invoice->main_invoice_no ?? '';
}
$barcodeData = '';

if(!empty($mainInvoiceNo)) {
    $barcodeData = base64_encode($generatorPNG->getBarcode($mainInvoiceNo, $generatorPNG::TYPE_CODE_128));
}
@endphp
<div class="row">
    <div class="col-12">
        <table class="table table-borderless table-sm mb-1" id="account_to">
            <tbody>
                <tr>
                    <td>
                        <div class="row border border-dark mx-0" style="padding-top: 4px; padding-bottom: 4px;border-bottom: 1px solid #565656;">
                            <div class="col-4 border-right border-dark">
                                <table class="table table-borderless mb-1 w-100 table-line-height1-2">
                                    <tbody>
                                        <tr class="fw-bold">
                                            <td style="width:20%">Patient Name</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">
                                                {!! !empty($patientTitle) ? $patientTitle->name:'' !!} {{ !empty($patientTitle) ? $patient->name : '' }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>{!! $patient->unique_register_no?'ABHA':'Patient' !!} ID</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">
                                                <b>{{ $patient->unique_register_no?$patient->unique_register_no:$patient->code }}</b>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Address</td>
                                            <td>:</td>
                                            <td style="padding-left: 2px">
                                                @php
                                                $address = $patientAddress->city->name;
                                                @endphp

                                                {!! $address !!}
                                            </td>
                                        </tr>
                                        <tr class="">
                                            <td width="35%">Consultant</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! $doctorTitle->name??'' !!} {{ $ref_doctor }}</td>
                                        </tr>
                                        <tr class="fw-bold">
                                            <td style="width:30%">Admission No</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">
                                                {!! isset($admission) && !empty($admission->ipd_admission_no) ? $admission->ipd_admission_no : (isset($sale_invoice->getIpdAdmission->ipd_admission_no) && $sale_invoice->getIpdAdmission->ipd_admission_no!=''?$sale_invoice->getIpdAdmission->ipd_admission_no:'') !!}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td width="35%">Admission Date</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">
                                                {{ \Carbon\Carbon::parse($sale_invoice->getIpdAdmission->admission_date_time ?? '')->format($sale_invoice->getCompany->date_format) }}
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="col-5 line-height1-2">
                                @if($voucherType!='SALES')
                                <table class="table table-borderless mb-1 w-100 table-line-height1-2" style="margin-left: -3.9px;">
                                    <tbody>
                                        {{-- <tr class="fw-bold">
                                            <td width="35%">Ref. Doctor</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! $doctorTitle->name??'' !!} {{ $ref_doctor }}</td>
                                        </tr> --}}
                                        <tr class="fw-bold">
                                            <td width="35%">Invoice Date</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! formatedDate($sale_invoice->invoice_date) ??'' !!} {!! formatedTime($sale_invoice->invoice_date) ??'' !!}</td>
                                        </tr>
                                          @if ($patientContact)
                                        <tr>
                                            <td>Gender</td>
                                            <td>:</td>
                                            <td style="padding-left: 2px">{{ $patientContact->gender->name ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <td>Age</td>
                                            <td>:</td>
                                            <td style="padding-left: 2px"> @if ($age > 0)
                                                {{ $age }} Years
                                                @endif</td>
                                        </tr>
                                        @endif
                                        @foreach (accountLicenses($patient->id) as $value)
                                        <tr>
                                            <td>{!! $value->name !!}</td>
                                            <td>:</td>
                                            <td style="padding-left: 2px">{!! $value->license_number !!}</td>
                                        </tr>
                                        @endforeach

                                         <tr class="font-weight-bold">
                                            <td>Phone No</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! $patientContact->phone_no ?? '' !!}
                                                @if ($patientContact->whatsapp_no)
                                                WhatsApp : {!! $patientContact->whatsapp_no !!}
                                                @endif
                                            </td>
                                        </tr> 
                                        {{-- @if($doctorQualification)
                                        <tr>
                                            <td width="35%">Qualification</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! $doctorQualification->qualifications??'' !!}</td>
                                        </tr>
                                        @endif --}}
                                        <tr>
                                            <td width="35%">Bed No</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! $sale_invoice->bed_name ??'' !!}</td>
                                        </tr>
                                        <tr>
                                            <td width="35%">TPA/Corporate</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px"> {!! $sale_invoice->account_name ??'' !!}</td>
                                        </tr>
                                        <tr>
                                            <td width="35%">Discharge Date</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">
                                                @if(!empty($data->discharge_datetime))
                                                    {!! !empty($data->discharge_datetime) ? formatedDate($data->discharge_datetime) : '' !!} {!! !empty($data->discharge_datetime) ? formatedTime($data->discharge_datetime) : '' !!}
                                                @else
                                                    {!! !empty($sale_invoice->discharge_date) ? formatedDate($sale_invoice->discharge_date) : '' !!} {!! !empty($sale_invoice->discharge_date) ? formatedTime($sale_invoice->discharge_date) : '' !!}
                                                @endif
                                            </td>
                                        </tr>

                                        @if($collectionAgent)
                                        <tr class="font-weight-bold">
                                            <td>Collection Agent</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">{!! $collectionAgentTitle->name??'' !!} {{ $collectionAgent }} </td>
                                        </tr>
                                        @endif
                                        @if($referralLab)
                                        <tr class="font-weight-bold">
                                            <td>Ref. Partner</td>
                                            <td>:</td>
                                            <td colspan="3" style="padding-left: 2px">
                                                {!! $referralLabTitle->name??'' !!} {{ $referralLab }}
                                            </td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                                @endif
                            </div>
                            <div class="col-2 border-right border-dark my-auto line-height1-2">
                                <div class="text-end">
                                    <div class="text-center">
                                        @if($voucherType=='IPD_ADMISSION')
                                        {!! DNS1D::getBarcodeHTML($sale_invoice->main_invoice_no, 'C93') !!}
                                        @else
                                        <img class="barcodeStyle" src="data:image/png;base64,{{ $barcodeData }}">
                                        @endif
                                    </div>
                                    <div class="text-center">
                                        <span class="font-14"><b>{!! $mainInvoiceNo !!}</b></span>
                                    </div>
                                </div>
                            </div>

                            
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
@endif

<div class="row {!! request()->segment(2) == 'discharge-statement' ? '' : 'mb-1' !!}">
    <div class="col-12 text-center">
        @if(request()->segment(2) == 'discharge-statement')
        <span class="text-bold my-auto font-14">
            DISCHARGE CERTIFICATE
        </span>
        <div style="width:100%;border-bottom: 1px solid black"></div>
        @else
        <span class="text-bold my-auto font-14">{!! $voucherTitle ?? '' !!} 
            @if(empty($data->discharge_datetime)) 
            (Provisional)
            @endif
        </span>
        @endif
    </div>
</div>
