<div class="row">
    @php  
    if(isset($sale_invoice->getSaleInvoiceDiscount))
    {
        $discount = $sale_invoice->getSaleInvoiceDiscount[0]->discount_amount;
    }
    else
    {
        $discount = 0;
    }
    
    
    if($discount>0 || $voucher_type->tax_applicable == '1')
    {
        $rowspan = 2;
    }else{
        $rowspan = 1;
    }
    @endphp
    <div class="col-12">
        <table class="table table-bordered-print w-100" id="quotation_products">
            <thead>
                <tr class="text-uppercase">
                    <th width="2%" class="text-center" rowspan="{!! $rowspan !!}">Sl.No</th>
                    <th width="30%" rowspan="{!! $rowspan !!}">Item Name &amp; Details</th>
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <th class="text-center" rowspan="{!! $rowspan !!}">HSN/SAC</th>
                    @endif
                    <th width="5%" class="text-end" rowspan="{!! $rowspan !!}">MRP</th>
                    <th width="3%" class="text-end" rowspan="{!! $rowspan !!}">Qty</th>
                    <th width="3%" class="text-end" rowspan="{!! $rowspan !!}">UOM</th>
                    <th width="4%" class="text-end" rowspan="{!! $rowspan !!}">Rate</th>
                    @if($discount>0)
                    <th width="10%" class="text-center" colspan="2">Discount</th>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <th class="text-end" rowspan="2">Taxable Amt</th>
                    <th class="text-center" colspan="2">CGST</th>
                    <th class="text-center" colspan="2">SGST</th>
                    <th class="text-center" colspan="2">IGST</th>
                    <th class="text-center" colspan="2">CESS</th>
                    @endif
                    <th width="5%" class="text-end" rowspan="2">Total</th>
                </tr>
                <tr class="text-uppercase font-weight-bold">
                    @if($discount>0)
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    @endif
                </tr>
            </thead>
            <tbody>
                @php
                $total_gst_amount = 0;
                $IGST = $CGST = $SGST = $CESS = 0;
                $totalMrp = 0;
                $totalQnt = 0;
                $totalValue = 0;
                $totalValueAmount = 0;
                $totalDiscountAmount = 0;
                $totalAmount = 0;
                $IgstAmount = $CgstAmount = $SgstAmount = $CessAmount = 0;
                $totalIgstAmount = $totalCgstAmount = $totalSgstAmount = $totalCessAmount = 0;
                @endphp
                @foreach ($sale_invoice->getOpdBookingDetails as $key => $value)
                @php $totalMrp +=$value->product_price;
                $totalQnt+=1;
                $totalValue+=$value->product_price*1;
                $totalValueAmount = $value->product_price*1;
                $totalDiscountAmount+=$value->flat_discount;
                @endphp

                <tr>
                    <td class="text-center"> {!! $key + 1 !!}</td>
                    <td>{!! $value->getProduct->name ?? '' !!}</td>
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td class="text-center">{!! $value->getProduct->hsncode ?? '' !!}</td>
                    @endif
                    <td class="text-end">
                        {!! isset($value->product_price)? convertDecimelPoint($value->product_price): '' !!}
                    </td>
                    <td class="text-end">
                        {!! '1' !!}
                    </td>
                    <td class="text-end">
                        {!! isset($value->getProduct->getProductPrimaryUnit->code)? $value->getProduct->getProductPrimaryUnit->code: '' !!}
                    </td>
                    <td class="text-end">
                        {!! isset($value->product_price)? convertDecimelPoint($value->product_price): '' !!}
                    </td>
                    @if($discount>0)
                    <td class="text-end">{!! $value->per_discount ?? '' !!}</td>
                    <td class="text-end">{!! isset($value->flat_discount) ? convertDecimelPoint($value->flat_discount) : '' !!}</td>
                    @endif

                    @php
                    $gst =
                    $value->getProduct->getTaxMaster
                    ->total_percentage ?? 0;
                    $gst_amount = taxAmountCalculate($gst,$totalValueAmount);
                    $total_gst_amount += $gst_amount;
                    @endphp
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td class="text-end">{!! convertDecimelPoint($totalValueAmount-$value->flat_discount) !!}</td>

                    @php
                    if (
                    isset(
                    $value->getProduct
                    ->getTaxMaster
                    ->getTaxMasterSub,
                    )
                    ) {
                    foreach ($value->getProduct->getTaxMaster->getTaxMasterSub as $tax) {
                    if ($tax->name == 'IGST') {
                    $IGST = $tax->percentage ??0;
                    $IgstAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                    $totalIgstAmount+=$IgstAmount;
                    } elseif (
                    $tax->name == 'CGST'
                    ) {
                    $CGST = $tax->percentage ??0;
                    $CgstAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                    $totalCgstAmount+=$CgstAmount;
                    } elseif (
                    $tax->name == 'SGST'
                    ) {
                    $SGST = $tax->percentage ?? 0;
                    $SgstAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                    $totalSgstAmount+=$SgstAmount;
                    }elseif($tax->name == 'CESS')
                    {
                    $CESS = $tax->percentage ??0;
                    $CessAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                    $totalCessAmount+=$CessAmount;
                    }
                    }
                    }
                    @endphp

                    <td class="text-end">{!! $CGST !!}</td>
                    <td class="text-end">{!! $CgstAmount?convertDecimelPoint($CgstAmount):0.00 !!}</td>
                    <td class="text-end">{!! $SGST !!}</td>
                    <td class="text-end">{!! $SgstAmount?convertDecimelPoint($SgstAmount):0.00 !!}</td>
                    <td class="text-end">{!! $IGST !!}</td>
                    <td class="text-end">{!! $IgstAmount?convertDecimelPoint($IgstAmount):0.00 !!}</td>
                    <td class="text-end">{!! $CESS !!}</td>
                    <td class="text-end">{!! $CessAmount?convertDecimelPoint($CessAmount):0.00 !!}</td>
                    @endif
                    <td class="text-end">
                        {!! convertDecimelPoint($totalValueAmount + $gst_amount - $value->flat_discount) ?? '' !!}
                        @php $newAmount = $totalValueAmount + $gst_amount - $value->flat_discount;
                        $totalAmount+=$newAmount;
                        @endphp
                    </td>
                </tr>
                @endforeach
                <tr>
                    <td></td>
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td></td>
                    @endif
                    <td align="right"><b>TOTAL</b></td>
                    <td align="right"><b>{!! $totalMrp?convertDecimelPoint($totalMrp):'' !!}</b></td>
                    <td align="right"><b>{!! $totalQnt?convertDecimelPoint($totalQnt):'' !!}</b></td>
                    <td></td>
                    <td></td>
                    @if($discount>0)
                    <td></td>
                    <td align="right"><b>{!! $totalDiscountAmount?convertDecimelPoint($totalDiscountAmount):'' !!}</b></td>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td align="right"><b>{!! $total_gst_amount?convertDecimelPoint($total_gst_amount):'' !!}</b></td>
                    <td></td>
                    <td align="right"><b>{!! $totalCgstAmount?convertDecimelPoint($totalCgstAmount):0.00 !!}</b></td>
                    <td></td>
                    <td align="right"><b>{!! $totalSgstAmount?convertDecimelPoint($totalSgstAmount):0.00 !!}</b></td>
                    <td></td>
                    <td align="right"><b>{!! $totalIgstAmount?convertDecimelPoint($totalIgstAmount):0.00 !!}</b></td>
                    <td></td>
                    <td align="right"><b>{!! $totalCessAmount?convertDecimelPoint($totalCessAmount):0.00 !!}</b></td>
                    @endif
                    <td align="right"><b>{!! $totalAmount?convertDecimelPoint($totalAmount):0.00 !!}</b></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>