<div class="row border border-dark border-bottom-0 text-uppercase mx-0 font-12 mt-2" style="border-top: 1px solid #565656;border-bottom: 1px solid #565656; ">
    <div class="col-4"><b>Invoice No :
            {!! $purchase_invoice->supplier_invoice_number ?? '' !!}</b>
    </div>
    <div class="col-4 text-center"><b>Date :
            {!! $purchase_invoice->invoice_date ? formatedDate($purchase_invoice->invoice_date) : '' !!}</b>
    </div>
    <div class="col-4 text-center">
        <b style="margin-left: -22px !important;">Reff No. : {!! $purchase_invoice->main_invoice_no ?? '' !!}</b>
    </div>
</div>


@php
$patient = $purchase_invoice->getPatient;
$patientContact = $patient->account_contact ?? null;
$patientTitle = $patient->account_title??null;
$patientAddress = $patient->first_account_address ?? null;
$dateOfBirth = $patientContact->date_of_birth ?? '';
$age = $dateOfBirth != '' ? age($dateOfBirth) : 0;
$generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();


    $ref_doctor = $purchase_invoice->getDoctor ? ucfirst(@$purchase_invoice->getDoctor->name) : 'Self';
    $doctorTitle = $purchase_invoice->getDoctor->account_title??null;
    $doctorQualification = $purchase_invoice->getDoctor->account_contact??null;

    $collectionAgent = $purchase_invoice->getCollectionAgent? ucfirst(@$purchase_invoice->getCollectionAgent->name):'';
    $collectionAgentTitle = $purchase_invoice->getCollectionAgent->account_title??null;

    $referralLab = $purchase_invoice->getRefferalLab?ucfirst(@$purchase_invoice->getRefferalLab->name):'';
    $referralLabTitle = $purchase_invoice->getRefferalLab->account_title??null;
    $mainInvoiceNo = $purchase_invoice->main_invoice_no ?? '';

$barcodeData = base64_encode($generatorPNG->getBarcode($mainInvoiceNo, $generatorPNG::TYPE_CODE_128));
@endphp

<div class="row">
    <div class="col-12">
        <table class="table table-borderless table-sm mb-1" id="account_to">
            <tbody>
                <tr>
                    <td>
                        <div class="row border border-dark mx-0" style="padding-top: 4px; padding-bottom: 4px;border-bottom: 1px solid #565656;">
                            <div class="col-8 border-right border-dark">
                                <table class="table table-borderless mb-1 w-100 table-line-height1-2">
                                    <tbody>
                                    <tr class="">
                                            <td colspan="5" style="padding-left: 2px">
                                                Supplier Details:<br>
                                                <span class="font-14 fw-bold">{!! $patientTitle?$patientTitle->name:'' !!} {{ $patient->name }}</span>
                                                <br>
                                                @php
                                                $address = generate_comma_separated_string([
                                                'city'=>$patientAddress->city->name?? '',
                                                'state'=>$patientAddress->state->name?? '',
                                                'country'=>$patientAddress->country->name?? '']);
                                                @endphp
                                                Address: {!! $address !!}
                                                <br>
                                                Phone: {{ $patient->account_contact->phone_no??'' }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                           
                            <div class="col-4 border-right border-dark my-auto line-height1-2">
                                <div class="text-end">
                                    <div class="text-center">
                                        <img class="barcodeStyle" src="data:image/png;base64,{{ $barcodeData }}">
                                    </div>
                                    <div class="text-center">
                                        <span class="font-14"><b>{!! $mainInvoiceNo !!}</b></span>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<div class="row mb-1">
    <div class="col-12 text-center">
        <span class="text-bold my-auto font-14">{!! $voucherTitle ?? '' !!}
        </span>
    </div>
</div>
