<div class="row">
    @php
    $discount = isset($sale_invoice->getSaleInvoiceDiscounts) && $sale_invoice->getSaleInvoiceDiscounts!=''?$sale_invoice->getSaleInvoiceDiscounts->discount_amount:'';

    $patient        = $sale_invoice->getPatient ?? null;
    $patientAddress = $patient->first_account_address ?? null;
    $patientState   = $patientAddress->state->name ?? '';
    $company        = @$sale_invoice->getCompany;
    $comapnyState   = $company->getCompanyAddress->getComapnyState->name ?? '';

    if($discount>0 || $voucher_type->tax_applicable == '1')
    {
        $rowspan = 2;
    }else{
        $rowspan = 1;
    }
    @endphp
    <div class="col-12">
        <table class="table table-bordered-print w-100" id="quotation_products">
            <thead>
                <tr class="text-uppercase">
                    <th width="2%" class="text-center" rowspan="{!! $rowspan !!}">Sl.No</th>
                    <th width="30%" rowspan="{!! $rowspan !!}">Item Name &amp; Details</th>
                    @if(request()->segment(1)!='pathology-invoice')
                    <th width="10%" rowspan="{!! $rowspan !!}">Batch No</th>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <th class="text-center" rowspan="{!! $rowspan !!}">HSN/SAC</th>
                    @endif
                    @if(request()->segment(1)!='pathology-invoice' && request()->segment(1)!='sale-invoice')
                    <th width="7%" class="" rowspan="{!! $rowspan !!}">Date Time</th>
                    @endif
                    <th width="5%" class="text-end" rowspan="{!! $rowspan !!}">MRP</th>
                    <th width="3%" class="text-end" rowspan="{!! $rowspan !!}">Qty</th>
                    <th width="3%" class="text-end" rowspan="{!! $rowspan !!}">UOM</th>
                    <!-- <th width="4%" class="text-end" rowspan="{!! $rowspan !!}">BASIC</th> -->
                    @if($discount>0)
                    <th width="10%" class="text-center" colspan="2">Discount</th>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <th class="text-end" rowspan="2">Taxable Amt</th>
                        @if($patientState == $comapnyState)
                            <th class="text-center" colspan="2">CGST</th>
                            <th class="text-center" colspan="2">SGST</th>
                        @else
                            <th class="text-center" colspan="2">IGST</th>
                        @endif
                    <th class="text-center" colspan="2">CESS</th>
                    @endif
                    <th width="5%" class="text-end" rowspan="2">Total</th>
                </tr>
                <tr class="text-uppercase font-weight-bold">
                    @if($discount>0)
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                        @if($patientState == $comapnyState)
                            <td width="2%" class="text-end">%</td>
                            <td width="3%" class="text-end">Amt</td>
                            <td width="2%" class="text-end">%</td>
                            <td width="3%" class="text-end">Amt</td>
                        @else
                            <td width="2%" class="text-end">%</td>
                            <td width="3%" class="text-end">Amt</td>
                        @endif
                    <td width="2%" class="text-end">%</td>
                    <td width="3%" class="text-end">Amt</td>
                    @endif
                </tr>
            </thead>
            <tbody>
                @php
                $total_gst_amount = 0;
                $IGST = $CGST = $SGST = $CESS = 0;
                $totalMrp = 0;
                $totalQnt = 0;
                $totalValue = 0;
                $totalValueAmount = 0;
                $totalDiscountAmount = 0;
                $totalAmount = 0;
                $mrp = 0;
                $IgstAmount = $CgstAmount = $SgstAmount = $CessAmount = 0;
                $totalIgstAmount = $totalCgstAmount = $totalSgstAmount = $totalCessAmount = 0;
                @endphp
                {{-- @dd($sale_invoice); --}}
                @foreach ($sale_invoice->getSaleInvoiceDetails as $key => $value)
                @php
                $totalMrp +=$value->price;
                $totalQnt+=$value->main_qty??0;
                $totalValue+=$value->price*$value->main_qty;
                $totalValueAmount = $value->price*$value->main_qty;
                $totalDiscountAmount+=$value->discount_amount;
                $mrp = ($value->main_qty>0)?$value->customer_amount/$value->main_qty:0;
                @endphp

                <tr>
                    <td class="text-center"> {!! $key + 1 !!}</td>
                    <td>
                            <b>{!! $value->getProduct->name ?? '' !!}</b> 
                            {!! !empty($value->getProduct->additional_info) ? '<br>' . $value->getProduct->additional_info : '' !!}
                            @if(request()->segment(1)!='pathology-invoice')
                            {!! isset($value->item_batch) && $value->item_batch!='N/A'  ? '<br>'.$value->item_batch : '' !!}
                            @endif
                    </td>

                    @if(request()->segment(1)!='pathology-invoice')
                    <td>{!! $value->getBatch->invoice_batch_no ?? '' !!}</td>
                    @endif

                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td class="text-center">{!! $value->getProduct->hsncode ?? '' !!}</td>
                    @endif

                    @if(request()->segment(1)!='pathology-invoice' && request()->segment(1)!='sale-invoice')
                        <td>
                            {!! isset($value->getBatch->invoice_batch_date) && $value->getBatch->invoice_batch_date != '' 
                                ? date('d-m', strtotime($value->getBatch->invoice_batch_date)) . ', ' . date('h:i A', strtotime($value->getBatch->invoice_batch_date)) 
                                : '' !!}
                        </td>
                    @endif
                    <td class="text-end">
                        {!! isset($mrp)? convertDecimelPoint($mrp): '' !!}
                    </td>
                    <td class="text-end">
                        {!! isset($value->main_qty) ? convertDecimelPoint($value->main_qty) : '' !!}
                    </td>
                    <td class="text-end">
                       
                        {!! isset($value->getProduct->getProductPrimaryUnit->name)? $value->getProduct->getProductPrimaryUnit->name: '' !!}
                    </td>
                    {{--<td class="text-end">
                        {!! isset($value->price)? convertDecimelPoint($value->price): '' !!}
                    </td>--}}
                    @if($discount>0)
                    <td class="text-end">{!! convertDecimelPoint($value->discount_percentage) ?? '' !!}</td>
                    <td class="text-end">{!! isset($value->discount_amount) ? convertDecimelPoint($value->discount_amount) : '' !!}</td>
                    @endif

                    @php
                    $gst =
                    $value->getProduct->getTaxMaster
                    ->total_percentage ?? 0;
                    $gst_amount = taxAmountCalculate($gst,$totalValueAmount);
                    $total_gst_amount += $gst_amount;
                    @endphp
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td class="text-end">{!! convertDecimelPoint($totalValueAmount-$value->discount_amount) !!}</td>

                    @php
                    if (
                    isset(
                    $value->getProduct
                    ->getTaxMaster
                    ->getTaxMasterSub,
                    )
                    ) {
                        foreach ($value->getProduct->getTaxMaster->getTaxMasterSub as $tax) {
                            if ($tax->name == 'IGST') {
                                $IGST = $tax->percentage ??0;
                                $IgstAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                                $totalIgstAmount+=$IgstAmount;
                            } elseif (
                                $tax->name == 'CGST'
                            ) {
                                $CGST = $tax->percentage ??0;
                                $CgstAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                                $totalCgstAmount+=$CgstAmount;
                            } elseif (
                                $tax->name == 'SGST'
                            ) {
                                $SGST = $tax->percentage ?? 0;
                                $SgstAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                                $totalSgstAmount+=$SgstAmount;
                            }elseif($tax->name == 'CESS')
                            {
                                $CESS = $tax->percentage ??0;
                                $CessAmount = taxAmountCalculate($tax->percentage,$totalValueAmount);
                                $totalCessAmount+=$CessAmount;
                            }
                        }
                    }
                    @endphp

                    @if($patientState == $comapnyState)
                    <td class="text-end">{!! $CGST !!}</td>
                    <td class="text-end">{!! $CgstAmount?convertDecimelPoint($CgstAmount):0.00 !!}</td>
                    <td class="text-end">{!! $SGST !!}</td>
                    <td class="text-end">{!! $SgstAmount?convertDecimelPoint($SgstAmount):0.00 !!}</td>
                    @else
                    <td class="text-end">{!! $IGST !!}</td>
                    <td class="text-end">{!! $IgstAmount?convertDecimelPoint($IgstAmount):0.00 !!}</td>
                    @endif
                    <td class="text-end">{!! $CESS !!}</td>
                    <td class="text-end">{!! $CessAmount?convertDecimelPoint($CessAmount):0.00 !!}</td>
                    @endif
                    <td class="text-end">
                        {!! convertDecimelPoint($value->total_amount) ?? '' !!}
                        @php $newAmount = $totalValueAmount + $gst_amount - $value->discount_amount;
                        $totalAmount+=$value->total_amount;
                        @endphp
                    </td>
                </tr>
                @endforeach
                <tr>
                    <td></td>
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td></td>
                    @endif
                    @if(request()->segment(1)!='pathology-invoice')
                    <td align="right" colspan="2"><b>TOTAL</b></td>
                    @else
                    <td align="right" colspan="1"><b>TOTAL</b></td>
                    @endif
                    @if(request()->segment(1)!='pathology-invoice' && request()->segment(1)!='sale-invoice')
                    <td></td>
                    @endif
                    <td align="right"><b>{{-- {!! $totalMrp?convertDecimelPoint($totalMrp):'' !!} --}}</b></td>
                    <td align="right"><b>{!! $totalQnt?convertDecimelPoint($totalQnt):'' !!}</b></td>

                    <td></td>
                    @if($discount>0)
                    <td></td>
                    <td align="right"><b>{!! $totalDiscountAmount?convertDecimelPoint($totalDiscountAmount):'' !!}</b></td>
                    @endif
                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                    <td align="right"><b> {{-- {!! $total_gst_amount?convertDecimelPoint($total_gst_amount):'' !!} --}}</b></td>
                    <td></td>
                    @if($patientState == $comapnyState)
                    <td align="right"><b>{!! $totalCgstAmount?convertDecimelPoint($totalCgstAmount):0.00 !!}</b></td>
                    <td></td>
                    <td align="right"><b>{!! $totalSgstAmount?convertDecimelPoint($totalSgstAmount):0.00 !!}</b></td>
                    <td></td>
                     @else
                    <td align="right"><b>{!! $totalIgstAmount?convertDecimelPoint($totalIgstAmount):0.00 !!}</b></td>
                    <td></td>
                    @endif
                    <td align="right"><b>{!! $totalCessAmount?convertDecimelPoint($totalCessAmount):0.00 !!}</b></td>
                   
                    @endif
                    <td align="right"><b>{!! $totalAmount?convertDecimelPoint($totalAmount):0.00 !!}</b></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
