<form class="row g-3 auto-width create_client" id="create_client" enctype='multipart/form-data'>
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    <div class="col-md-12">
        <label for="validationCustomUsername" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="validationCustomUsername" name="name" aria-describedby="inputGroupPrepend" required>
        @if ($errors->has('name'))
        <span class="text-danger">{{ $errors->first('name') }}</span>
        @endif
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label class="form-label">Organization </label>
        <input type="text" class="form-control" placeholder="" name="organization" id="organization" />
        @if ($errors->has('organization'))
        <span class="text-danger">{{ $errors->first('organization') }}</span>
        @endif
    </div>
    <div class="col-md-4">
        <label class="form-label">Country</label>
        <select class="single-select form-control" id="country" name="country_id" onchange="changecontry()" required>
            <option value=" "> Select Country</option>
            @foreach($country as $list)
            <option value="{{ $list->id}}">{{$list->name}}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-4">
        <label class="form-label">State</label>
        <select class="single-select form-control" name="state_id" id="states" onchange="getcity()">
        <option value=" ">--Select--</option>
        </select>
    </div>
    <div class="col-md-4">
        <label class="form-label">City</label>
        <select class="single-select form-control" name="city_id" id="cities">
        <option value=" ">--Select--</option>
        </select>
    </div>
    <div class="col-md-12 phone_no_col">
        <label class="form-label">Phone no<span class="text-danger"><b>*</b></span></label>
        <input type="tel" class="form-control w-100" placeholder="" id="phone_no" />
        <input type="hidden" name="phone_no">

        @if ($errors->has('phone_no'))
        <span class="text-danger">{{ $errors->first('phone_no') }}</span>
        @endif
        <span class="text-danger error_phone" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-12 whatsapp_no_col">
        <label class="form-label">Whatsapp no </label>
        <input type="tel" class="form-control" placeholder="" id="whatsapp_no" />
        <input type="hidden" name="whatsapp_no">
        @if ($errors->has('whatsapp_no'))
        <span class="text-danger">{{ $errors->first('whatsapp_no') }}</span>
        @endif
    </div>
    <h5 class="mt-4 mb-0 cursor-pointer" id="additional_details_toggle"><i class="more-less bi bi-plus h3"></i> Additional Details</h5>
    <hr class="mt-0">
    <div class="details-toggle row">
        <div class="col-md-12 alternative_no_col mb-3">
            <label class="form-label">Alternative no</label>
            <input type="tel" class="form-control" placeholder="" id="alternative_no" />
            <input type="hidden" name="alternative_no">
            @if ($errors->has('alternative_no'))
            <span class="text-danger">{{ $errors->first('alternative_no') }}</span>
            @endif
        </div>
        <div class="col-md-12 mb-3">
            <label class="form-label">Email </label>
            <input type="text" class="form-control" placeholder="" name="email" />
            @if ($errors->has('email'))
            <span class="text-danger">{{ $errors->first('email') }}</span>
            @endif
        </div>
        <div class="col-md-12 mb-3">
            <label class="form-label">Address </label>
            <textarea name="address" class="form-control"></textarea>
            @if ($errors->has('address'))
            <span class="text-danger">{{ $errors->first('address') }}</span>
            @endif
        </div>
        <div class="col-md-12 mb-3">
            <label class="form-label">Website URL </label>
            <input type="text" class="form-control" placeholder="" name="website_url" id="website_url" />
            @if ($errors->has('website_url'))
            <span class="text-danger">{{ $errors->first('website_url') }}</span>
            @endif
        </div>
    </div>
</form>

<script>
    $('.details-toggle').hide();
    var toggle = true;

    $("#additional_details_toggle").on('click', function() {
        console.log('additional_details_toggle button was clicked');
        console.log(toggle);
        $(".details-toggle").slideToggle();

        if (toggle !== true) {
            $(this).parent().find('.more-less').removeClass('bi-dash');
            $(this).parent().find('.more-less').addClass('bi-plus');
            toggle = true;
        } else {
            $(this).parent().find('.more-less').removeClass('bi-plus');
            $(this).parent().find('.more-less').addClass('bi-dash');
            toggle = false;
        }
    });

    $("#phone_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#phone_no").val(onlyNumbers);
    });
    $("#whatsapp_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#whatsapp_no").val(onlyNumbers);
    });
    $("#alternative_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#alternative_no").val(onlyNumbers);
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }


    function changecontry()
    {
        let country = $('#country').val();

        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getstate') }}", 
            data: {
                country:country
            },
            success: function (data) {
                $('#states').html(data);
            },
            error: function (data) {
                //console.log(data);
            }
        });

        // GET COUNTRY CODE OF SELECTED COUNTRY
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcountrycode') }}", 
            data: {
                country:country
            },
            success: function (countryCode) {
                // Call reinitializeTelInput and pass the received country code
                reinitializeTelInput(countryCode);
            }
        });
    }

    function getcity()
    {
        let states_id=$('#states').val();

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcity') }}",
            data: {states_id:states_id},
            success: function (data) {
                $('#cities').html(data);
            },
        });
    }
</script>