 <div class="table-responsive">
  <table id="example" class="table table-bordered align-middle" style="width:100%">
    <thead class="table-light">
      <tr>
        <th class="thbutton">Serial No</th>
        <th>Contact Name</th>
        <th>Phone No</th>
        <th>Email</th>
        <th width="15%">
            City,
            State,
            Country</th>
        <th class="thbutton">WA</th>
        @if(in_array('account-contacts-edit', $authRolePermissions))
        <th class="thbutton">Edit</th>
        @endif
        @if(in_array('account-contacts-delete', $authRolePermissions))
        <th class="thbutton">Delete</th>
        @endif
    </tr>
</thead>
<tbody>
    @php $i=1;@endphp
    @if(count($data)>0)
    @foreach($data as $key=> $list)
    <tr>
        <td>{{$data->firstItem() + $key}}</td>
        <td>
            {{ucfirst($list->name)}}<br>
            {{$list->organization}}
        </td>
        <td>
            <a href="tel:{{$list->phone_no}}">{{$list->phone_no}}</a><br>
            <a href="tel:{{$list->alternative_no}}">{{$list->alternative_no}}</a>
        </td>
        <td>{{$list->email}}</td>
        <td width="15%">
            <p>
                @if($list->city)
                    {{ $list->city }}
                    @if($list->state)
                        , {{ $list->state }}
                    @endif
                    @if($list->country)
                        , {{ $list->country }}
                    @endif
                @elseif($list->state)
                    {{ $list->state }}
                    @if($list->country)
                        , {{ $list->country }}
                    @endif
                @elseif($list->country)
                    {{ $list->country }}
                @endif
            </p>
        </td>

        <td class="text-center">
            @if($list->whatsapp_no != '')
            <a class="btn btn-success btn-sm" href="https://wa.me/{{$list->whatsapp_no}}?text=Hello%20{{$list->name}}!" target="_blank"><i class="bi bi-whatsapp text-white"></i></a>
            @endif
        </td>
        @if(in_array('account-contacts-edit', $authRolePermissions))
        <td>
            <a href="{{route('contacts.edit',$list->id)}}" class="btn btn-outline-secondary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                <i class="bi bi-pencil-square"></i>
            </a>
        </td>
        @endif
        @if(in_array('account-contacts-delete', $authRolePermissions))
        <td>
            <a data-url="{{route('contacts.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                <i class="bi bi-trash text-white"></i>
            </a>
        </td>
        @endif
    </tr>
    @php $i++; @endphp
    @endforeach
    @else
    <tr>
        <td colspan="8">No Data Found</td>
    </tr>
    @endif
</tbody>
</table>
</div>

<nav class="row align-items-center mt-2">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('contacts.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>

