 <div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Country Name</th>
                <th>currency Name &symbol</th>
                <th>Financial Year  Start - End</th>
                <th>Format</th>
                <th class="thbutton">Edit</th>
                <th class="thbutton">Status</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{{ $list->name }}({{ $list->code }})</td>
                        <td>{{ $list->currency_fullname }}({{ $list->currency_fullname }})</td>
                        @php
                        $startDate  = !empty($list->financial_year_start_date) ? $list->financial_year_start_date : null;
                        $startMonth = !empty($list->financial_year_start_month) ? DateTime::createFromFormat('!m', $list->financial_year_start_month)->format('F') : null;
                        $endDate    = !empty($list->financial_year_end_date) ? $list->financial_year_end_date : null;
                        $endMonth   = !empty($list->financial_year_end_month) ? DateTime::createFromFormat('!m', $list->financial_year_end_month)->format('F') : null;
                        @endphp

                        @if ($startDate && $startMonth && $endDate && $endMonth)
                            <td>{{ $startDate }}-{{ $startMonth }} <br>{{ $endDate }}-{{ $endMonth }}</td>
                        @else
                            <td></td>
                        @endif

                        <td>{{ $list->formats }}</td>
                        <td class="text-center">
                            <button type="button" class="btn btn-warning edit" data-id="{!! $list->id !!}" id="edit"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-pencil-square text-white"></i></button>
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{ $i }}">
                                <input class="form-check-input{{ $i }} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{ $i }}" data-url="{{ route('countries.changestatus') }}" data-id="{{ $list->id }}" data-status="{{ $list->status == '0' ? '1' : '0' }}" {{ $list->status == '1' ? 'checked' : '' }}>
                            </div>
                        </td>
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="13">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="float-start mt-2">
    <ul class="pagination">
        {!! $data->onEachSide(0)->render('countries.pagination') !!}
    </ul>
</nav>
</div>

