@extends('layouts.app')
@section('title','Edit Course')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
    .more-less {
        float: right;
        color: #212121;
    }

    .select2-selection__rendered {
        padding: 4px !important;
        padding-left: 8px !important;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
  <link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Courses</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Course</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            <!-- <a href="javascript:;" class="btn btn-primary"><i class="bx bx-file ms-0 me-1"></i>Save Course</a> -->
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" method="post" enctype='multipart/form-data' id="store-form">
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                            @csrf
                            @method('PUT')
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Basic Information</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-12">
                                            <div>
                                                <label for="course_title" class="form-label">Course Title  <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="validationCustomTitle" name="course_title" aria-describedby="inputGroupPrepend" value="{!! $data->course_title !!}" required>
                                            </div>
                                            @if ($errors->has('course_title'))
                                                <span class="text-danger">{{ $errors->first('course_title') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="category_id" class="form-label">Select Category <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select select-2" name="category_id" required>
                                                    <option value="">Select Category</option>
                                                    @foreach ($categories as $key => $category)
                                                        <option value="{!! $category->id !!}" {!! ($category->id == $data->category_id) ? 'selected' : '' !!}>{!! $category->title !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_category" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('category_id'))
                                                <span class="text-danger">{{ $errors->first('category_id') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_type" class="form-label">Course Type <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select select-2" name="course_type" required>
                                                    <option value="">Select Type</option>
                                                    @foreach ($types as $key => $type)
                                                        <option value="{!! $type->id !!}"{!! ($type->id == $data->course_type) ? 'selected' : '' !!}>{!! $type->title !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_course_type" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('course_type'))
                                                <span class="text-danger">{{ $errors->first('course_type') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="language_id" class="form-label">Language <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select select-2" name="language_id" required>
                                                    <option value="">Select Language</option>
                                                    @foreach ($languages as $key => $language)
                                                        <option value="{!! $language->id !!}"{!! ($language->id == $data->language_id) ? 'selected' : '' !!}>{!! $language->name !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_language" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('language_id'))
                                                <span class="text-danger">{{ $errors->first('language_id') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="subject_id" class="form-label">Select Subject <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select select-2" name="subject_id" required>
                                                    <option value="">Select Subject</option>
                                                    @foreach ($subjects as $key => $subject)
                                                        <option value="{!! $subject->id !!}"{!! ($subject->id == $data->subject_id) ? 'selected' : '' !!}>{!! $subject->title !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_subject" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('subject_id'))
                                                <span class="text-danger">{{ $errors->first('subject_id') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_level" class="form-label">Course Level <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select select-2" name="course_level" required>
                                                    <option value="">Select Level</option>
                                                    @foreach ($levels as $key => $level)
                                                        <option value="{!! $level->id !!}"{!! ($level->id == $data->course_level) ? 'selected' : '' !!}>{!! $level->title !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_course_level" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('course_level'))
                                                <span class="text-danger">{{ $errors->first('course_level') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6 tagsP">
                                            <div>
                                                <label for="tags" class="form-label">Course Tags  <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="multi-select-tags" multiple name="tags[]" required>
                                                    @foreach($tags as $tag)
                                                    <option {!! in_array($tag->title, explode(',', $data->tags)) ? 'selected' : '' !!}>{!! $tag->title !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_tag" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('tags'))
                                                <span class="text-danger">{{ $errors->first('tags') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_duration" class="form-label">Course Duration  <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="validationCustomTitle" name="course_duration" placeholder="75" aria-describedby="inputGroupPrepend" value="{!! $data->course_duration !!}" required>
                                            </div>
                                            @if ($errors->has('course_duration'))
                                                <span class="text-danger">{{ $errors->first('course_duration') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="course_duration" class="form-label">Duration Type  <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select name="duration_type" class="form-control single-select">
                                                    <option value="Hours" {!! ($data->duration_type == 'Hours') ? 'selected' : '' !!}>Hours</option>
                                                    <option value="Days" {!! ($data->duration_type == 'Days') ? 'selected' : '' !!}>Days</option>
                                                    <option value="Months" {!! ($data->duration_type == 'Months') ? 'selected' : '' !!}>Months</option>
                                                </select>
                                            </div>
                                            @if ($errors->has('course_duration'))
                                                <span class="text-danger">{{ $errors->first('course_duration') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="class_id" class="form-label">Class <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select class_id" name="class_id" required>
                                                    <option value="">Select Class</option>
                                                    @foreach ($classes as $key => $record)
                                                        <option value="{!! $record->id !!}" {!! ($record->id == $data->class_id) ? 'selected' : '' !!}>{!! $record->class_name !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_class" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('class_id'))
                                                <span class="text-danger">{{ $errors->first('class_id') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <label for="section_id" class="form-label">Section <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <select class="single-select section_id" name="section_id" required>
                                                    <!-- <option value="">Select Section</option> -->
                                                    @foreach ($sections as $key => $record)
                                                        <option value="{!! $record->academics_section_id !!}" {!! ($record->academics_section_id == $data->section_id) ? 'selected' : '' !!}>{!! $record->section !!}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append" style="margin: auto 10px;">
                                                    <button class="btn btn-success add_btn" id="create_section" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"> + </button>
                                                </div>
                                            </div>
                                            @if ($errors->has('section_id'))
                                                <span class="text-danger">{{ $errors->first('section_id') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="short_description" class="form-label">Short Description <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group">
                                                <textarea id="short_description" name="short_description" class="form-control" style="min-height: 100px; resize: none;" required>{!! $data->short_description !!}</textarea>
                                            </div>
                                            @if ($errors->has('short_description'))
                                                <span class="text-danger">{{ $errors->first('short_description') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <div>
                                                <label for="tags" class="form-label">Description <span class="text-danger"><b>*</b></span></label>
                                            </div>
                                            <div class="input-group" style="display: flex; flex-direction: column; flex-wrap: nowrap;">
                                                <textarea id="description" name="description" required>{!! $data->description !!}</textarea>
                                            </div>
                                            @if ($errors->has('description'))
                                                <span class="text-danger">{{ $errors->first('description') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-12">
                                            <br>
                                            <div class="d-grid gap-2 with-100">
                                                <button type="button" class="btn btn-primary save_course">Save Course</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php /*
                                <div class="col-md-12">
                                    <div class="card" style="padding-bottom: 15px;">
                                        <div class="card-body g-3 row">
                                            <h5 class="mb-0">Company</h5>
                                            <hr class="mb-0">
                                            <div class="col-md-12">
                                                <!-- <label for="company_id" class="form-label">Select Company <span class="text-danger"><b>*</b></span></label> -->
                                            <select class="single-select" name="company_id" disabled>
                                                <option value="">Select Company</option>
                                                @foreach ($companies as $key => $company)
                                                    <option value="{!! $company->id !!}" {!! ($company->id == auth()->user()->company_id) ? 'selected' : '' !!}>{!! $company->name !!}</option>
                                                @endforeach
                                            </select>
                                            @if ($errors->has('company_id'))
                                                <span class="text-danger">{{ $errors->first('company_id') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div> */ ?>
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Media & Images</h5>
                                        <hr class="mb-0">
                                        <div class="col-md-6">
                                            <label for="video_type" class="form-label">Video Source/Type </label>
                                            <select class="single-select video_type" name="video_type">
                                                <option value="upload" {!! (isset($data->video_source) && $data->video_source->video_type == 'upload') ? 'selected' : '' !!}>Upload</option>
                                                <option value="youtube" {!! (isset($data->video_source) && $data->video_source->video_type == 'youtube') ? 'selected' : '' !!}>Youtube</option>
                                                <option value="vimeo" {!! (isset($data->video_source) && $data->video_source->video_type == 'vimeo') ? 'selected' : '' !!}>Vimeo</option>
                                                <option value="mp4" {!! (isset($data->video_source) && $data->video_source->video_type == 'mp4') ? 'selected' : '' !!}>MP4</option>
                                            </select>
                                            @if ($errors->has('video_type'))
                                                <span class="text-danger">{{ $errors->first('video_type') }}</span>
                                            @endif
                                            <span class="text-danger error_enquiry_date" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="upload-video">
                                                <label for="source" class="form-label" style="width: 100% !important; {!! (isset($data->video_source) && $data->video_source->video_type != 'upload') ? 'display:none;' : '' !!}">Upload Video
                                                <input type="file" name="source" class="form-control">
                                            </div>
                                            <div class="video-link" style="{!! (isset($data->video_source) && $data->video_source->video_type == 'upload') ? 'display:none;' : '' !!}">
                                                <label for="source" class="form-label" style="width: 100% !important">Video Link
                                                <input type="text" name="source" class="form-control" value="{!! isset($data->video_source) ? $data->video_source->source : '' !!}" placeholder="Enter Video Link" {!! (isset($data->video_source) && $data->video_source->video_type == 'upload') ? 'disabled' : '' !!}>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label for="video_type" class="form-label">Thumbnail (402x248) </label>
                                            <input type="file" name="thumbnail" class="form-control">
                                        </div>
                                        <div class="col-md-12">
                                            <label for="validationCustomOrder" class="form-label"><strong>Downloadable </strong></label>
                                            <input name="is_downloadable" class="form-check-inputFeatured btn-lg is_downloadable" type="checkbox" id="inlineCheckboxFeatured" value="1" {!! ($data->is_downloadable == 1) ? 'checked' : '' !!}>
                                            @if ($errors->has('is_downloadable'))
                                            <span class="text-danger">{{ $errors->first('is_downloadable') }}</span>
                                            @endif
                                            <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="card" style="padding-bottom: 15px;">
                                        <div class="card-body g-3 row">
                                            <h5 class="mb-0">Pricing</h5>
                                            <hr class="mb-0">
                                            <div class="col-md-12">
                                                <label for="validationCustomOrder" class="form-label"><strong>This Course is Free </strong></label>
                                                <input name="is_free" class="form-check-inputFeatured btn-lg is_free" type="checkbox" id="inlineCheckboxFeatured" value="1" {!! ($data->is_free == 1) ? 'checked' : '' !!}>
                                                @if ($errors->has('is_free'))
                                                <span class="text-danger">{{ $errors->first('is_free') }}</span>
                                                @endif
                                                <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                            </div>
                                            <div class="col-md-12 course_price" style="{!! ($data->is_free == 1) ? 'display:none;' : '' !!}">
                                                <div>
                                                    <label for="course_price" class="form-label">Course Price  <span class="text-danger"><b>*</b></span></label>
                                                </div>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" id="validationCustomTitle" name="course_price" aria-describedby="inputGroupPrepend" value="{!! $data->course_price !!}">
                                                </div>
                                                @if ($errors->has('course_price'))
                                                    <span class="text-danger">{{ $errors->first('course_price') }}</span>
                                                @endif
                                                <span class="text-danger error_enquiry_category_id" style="display:none;">This field is required.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="card" style="padding-bottom: 15px;">
                                        <div class="card-body g-3 row">
                                            <h5 class="mb-0">SEO</h5>
                                            <hr class="mb-0">
                                            <div class="col-md-6">
                                                <label for="validationCustomMetaTitle" class="form-label">Meta Title </label>
                                                <input type="text" class="form-control" id="validationCustomMetaTitle" name="meta_title" aria-describedby="inputGroupPrepend" required value="{!! $data->meta_title !!}">
                                                @if ($errors->has('meta_title'))
                                                <span class="text-danger">{{ $errors->first('meta_title') }}</span>
                                                @endif
                                                <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                            </div>
                                            <div class="col-md-6">
                                                <label for="validationCustomMetaKeywords" class="form-label">Meta Keywords </label>
                                                <input type="text" class="form-control" id="validationCustomMetaKeywords" name="meta_keywords" aria-describedby="inputGroupPrepend" required value="{!! $data->meta_keywords !!}">
                                                @if ($errors->has('meta_keywords'))
                                                <span class="text-danger">{{ $errors->first('meta_keywords') }}</span>
                                                @endif
                                                <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationTextarea" class="form-label">Open Graph Image(1200x630)</label>
                                                <input type="file" class="form-control" name="open_graph_image" aria-label="file example">
                                                <div class="invalid-feedback">Example invalid form file </div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustomMetaDescription" class="form-label">Meta Description </label>
                                                <textarea class="form-control" id="validationCustomMetaDescription" name="meta_description" aria-describedby="inputGroupPrepend" required>{!! $data->meta_description !!}</textarea>
                                                @if ($errors->has('meta_description'))
                                                <span class="text-danger">{{ $errors->first('meta_description') }}</span>
                                                @endif
                                                <span class="text-danger error_name" style="display: none;">This field is required.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                      </form>
                  </div>
              </div>
          </div>
      </div>
  </div>
  <!--end row-->
@endsection

@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
{{-- <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script> --}}
<script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create( document.querySelector( '#description') )
        .then( newEditor => {
            editor = newEditor;
        })
        .catch( error => {
            console.error( error );
        });

        $(".ck-dropdown").find(`[data-cke-tooltip-text='Insert media']`).css("display", "none");
  </script>

<script>
    $(document).ready(function() {

        $(document).on('click', '#create_category', function() {
            $('#commonModalLabel').text('Add New Category');
            $('.save_button_span').text('Save Category Details');
            $.ajax({
                url:"{!! route('course-categories.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                    $('.single-select').select2({
                        dropdownParent: $('#commonModal'),
                        theme: 'bootstrap4',
                        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                        placeholder: $(this).data('placeholder'),
                        allowClear: Boolean($(this).data('allow-clear')),
                    });

                    $.switcher('.categories .isFeatured');
                }
            });
        });

        $(document).on('click', '#create_course_type', function() {
            $('#commonModalLabel').text('Add New Course Type');
            $('.save_button_span').text('Save Course Type Details');
            $.ajax({
                url:"{!! route('course-types.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        });

        $(document).on('click', '#create_language', function() {
            $('#commonModalLabel').text('Add New Language');
            $('.save_button_span').text('Save Language Details');
            $.ajax({
                url:"{!! route('languages.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        });

        $(document).on('click', '#create_subject', function() {
            $('#commonModalLabel').text('Add New Course Level');
            $('.save_button_span').text('Save Subject Details');
            $.ajax({
                url:"{!! route('subjects.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        });

        $(document).on('click', '#create_course_level', function() {
            $('#commonModalLabel').text('Add New Course Level');
            $('.save_button_span').text('Save Course Level Details');
            $.ajax({
                url:"{!! route('course-levels.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        });

        $(document).on('click', '#create_tag', function() {
            $('#commonModalLabel').text('Add New Tag');
            $('.save_button_span').text('Save Tag Details');
            $.ajax({
                url:"{!! route('tags.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        });

        $(document).on('click', '#create_class', function() {
            $('#commonModalLabel').text('Add New Class');
            $('.save_button_span').text('Save Class Details');
            $.ajax({
                url:"{!! route('classes.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                    $('.sections-select').select2({
                        dropdownParent: $('#commonModal'),
                        theme: 'bootstrap4',
                        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                        placeholder: $(this).data('placeholder'),
                        allowClear: Boolean($(this).data('allow-clear')),
                    });
                }
            });
        });

        $(document).on('click', '#create_section', function() {
            $('#commonModalLabel').text('Add New Section');
            $('.save_button_span').text('Save Section Details');
            $.ajax({
                url:"{!! route('sections.create') !!}",
                success:function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                }
            });
        });

        $(document).on('click', '.save_button', function(event){
            event.preventDefault();

            let formdata = new FormData($('#commonModal').find('form')[0]);

            $.ajax({
                url: $('#commonModal').find('form').attr('action'),
                data: formdata,
                processData: false,
                contentType: false,
                type: 'POST',
                success: function (response) {
                    if (response.success === true) {
                        toastr.success(response.message, 'Success.');

                        if ($('#commonModal').find('form').hasClass('categories')) {
                            $('[name="category_id"]').append(`<option value="${response.data.id}" selected>${response.data.title}</option>`);
                        }

                        if ($('#commonModal').find('form').hasClass('course-types')) {
                            $('[name="course_type"]').append(`<option value="${response.data.id}" selected>${response.data.title}</option>`);
                        }

                        if ($('#commonModal').find('form').hasClass('languages')) {
                            $('[name="language_id"]').append(`<option value="${response.data.id}" selected>${response.data.name}</option>`);
                        }

                        if ($('#commonModal').find('form').hasClass('subjects')) {
                            $('[name="subject_id"]').append(`<option value="${response.data.id}" selected>${response.data.title}</option>`);
                        }

                        if ($('#commonModal').find('form').hasClass('course-levels')) {
                            $('[name="course_level"]').append(`<option value="${response.data.id}" selected>${response.data.title}</option>`);
                        }

                        if ($('#commonModal').find('form').hasClass('tags')) {
                            $('.multi-select-tags').append(`<option value="${response.data.id}" selected>${response.data.title}</option>`);
                            $('.multi-select-tags').select2({
                                theme: 'bootstrap4',
                                dropdownParent: $(".tagsP"),
                                placeholder: "Course Tags",
                                allowClear: Boolean($(this).data('allow-clear')),
                            });
                        }

                        if ($('#commonModal').find('form').hasClass('classes')) {
                            $('[name="class_id"]').append(`<option value="${response.data.id}" selected>${response.data.class_name}</option>`);
                            $('[name="class_id"]').trigger('change');
                        }

                        if ($('#commonModal').find('form').hasClass('sections')) {
                            // $('[name="section_id"]').append(`<option value="${response.data.id}" selected>${response.data.section}</option>`);
                        }

                        $('.single-select').select2({
                            theme: 'bootstrap4',
                            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                            placeholder: $(this).data('placeholder'),
                            allowClear: Boolean($(this).data('allow-clear')),
                        });

                        // hide modal
                        $('#commonModal').modal('hide');
                        $('#commonModal').find('.modal-body').html('');

                    } else {
                        toastr.error(response.message, 'Error!');
                    }
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.log('AJAX request failed:', textStatus, errorThrown);
                toastr.error('An error occurred during the request.', 'Error!');

                // hide modal
                $('#commonModal').modal('hide');
                $('#commonModal').find('.modal-body').html('');
            });
        })

        $(document).on('click', '.save_course', function() {
            let formdata = new FormData($('#store-form')[0]);

            $.ajax({
                url:"{!! route('courses.update', $data->id) !!}",
                data: formdata,
                processData: false,
                contentType: false,
                type: 'POST',
                success:function(response) {
                    if (response.success == false) {
                        toastr.error(response.message, 'Error!');
                    }

                    if (response.success == true) {
                        toastr.success(response.message, 'Success.');

                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    }
                }
            }).fail(function(jqXHR, textStatus, errorThrown) {
                toastr.error('An error occurred during the request.', 'Error!');
            });
        });


        $('.select-2').select2({
            minimumInputLength: 2,
            // dropdownParent: $('.modal'),
            theme: 'bootstrap4',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            allowClear: Boolean($(this).data('allow-clear')),
        });

        $('.multi-select-tags').select2({
            theme: 'bootstrap4',
            dropdownParent: $(".tagsP"),
            placeholder: "Course Tags",
            // width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            allowClear: Boolean($(this).data('allow-clear')),
        });

        $(".is_free").on("change", function() {
            if ($(this).is(':checked')) {
                $('.course_price').hide();
            } else {
                $('.course_price').show();
                // alert('not checked')
            }
        });

        $(".class_id").on("change", function() {
            var classId = $(this).val();

            // Get sections against selected class.
            $.ajax({
                url:"{!! route('class.sections') !!}",
                // data: formdata,
                /*processData: false,
                contentType: false,*/
                type: 'GET',
                data: {'class': classId},
                success:function(response) {
                    if (response.success == false) {
                        toastr.error(response.message, 'Error!');
                    }

                    if (response.success == true && response.data && response.data != '') {
                        var options = ``;
                        $.each(response.data, function(index, record) {
                            options += `<option value="` + record.academics_section_id + `">` + record.section + `</option>`;
                        });

                        $(".section_id").html(options);

                        $('.section_id').select2({
                            theme: 'bootstrap4',
                            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                            placeholder: $(this).data('placeholder'),
                            allowClear: Boolean($(this).data('allow-clear')),
                        });

                        // toastr.success(response.message, 'Success.');
                    } else {
                        $(".section_id").html('');
                    }
                }
            }).fail(function(jqXHR, textStatus, errorThrown) {
                toastr.error('An error occurred during the request.', 'Error!');
            });
        });

        $(".video_type").on("change", function() {
            if ($(this).val() == 'upload') {
                // upload-video
                $('.upload-video').show();
                $('.video-link').hide();
                $('.upload-video').find('input').attr('disabled', false);
                $('.video-link').find('input').attr('disabled', true);
            } else {
                // video-link
                $('.upload-video').hide();
                $('.video-link').show();
                $('.upload-video').find('input').attr('disabled', true);
                $('.video-link').find('input').attr('disabled', false);
            }
        })
    });
</script>
@endsection
