<style type="text/css">
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
</style>
<form class="row g-3 auto-width create_doctor" id="create_doctor_form" enctype='multipart/form-data' action="{!! route('doctor-account-store') !!}">
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    <div class="col-md-12">
        <div>
            <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="account_title" name="account_title_id" style="width:70px;">
                <option value=""></option>
                @foreach($account_title as $list)
                <option value="{{ $list->id }}" {!! matchSelected(old('account_title_id'), $list->id) !!}>{{ $list->name }}</option>
                @endforeach
            </select>
            <input type="text" name="name" class="form-control" value="{!! old('name') !!}">
        </div>
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label class="form-label">Qualifications </label>
        <input type="text" class="form-control" placeholder="" name="qualifications" id="qualifications" />
    </div>
    <div class="col-md-12">
        <label class="form-label">Organization </label>
        <input type="text" class="form-control" placeholder="" name="organization" id="organization" />
    </div>
    <div class="col-md-6">
        <label class="form-label">Country <span class="text-danger"><b>*</b></span></label>
        <select class="single-select form-control" id="country" onchange="changecontry()"  name="country_id" required>
            <option value=" "> Select Country</option>
            @foreach($country as $list)
            <option value="{{ $list->id}}" {!! matchSelected(old('country_id', $country_id), $list->id) !!}>{{$list->name}}</option>
            @endforeach
        </select>
        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6 phone_no_col">
        <div>
            <label class="form-label">Phone no<span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control w-100" placeholder="" id="phone_no" />
            <input type="hidden" name="phone_no">
        </div>
        <span class="text-danger error_phone" style="display:none;">This field is required.</span>
    </div>
</form>

<script>
    $("#phone_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#phone_no").val(onlyNumbers);
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }

    function changecontry()
    {
        let country = $('#country').val();

        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // GET COUNTRY CODE OF SELECTED COUNTRY
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcountrycode') }}", 
            data: {
                country:country
            },
            success: function (countryCode) {
                // Call reinitializeTelInput and pass the received country code
                reinitializeTelInput(countryCode);
            }
        });
    }
</script>
@if($country_id)
    <script>
        changecontry();
    </script>
@endif