@extends('layouts.app')
@section('title','Departments - Permission')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Department Permission for <b>{{ $user->name ?? 'user' }}</b> 
      </div>
      <div class="col-md-6">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb justify-content-md-end mb-0">
            <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="84" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
            <li class="breadcrumb-item" aria-current="page">Test Manager</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Lab Department</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Permission</li>
          </ol>
        </nav>
      </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">

            @include('layouts.partials.nav-menu')

            <div class="row gx-2">

                <div class="col-lg-3 col-md-3 col-8">
                  <div class="position-relative">
                      <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                      <input class="form-control ps-5" type="search" id="search" placeholder="Search">
                  </div>
                </div>
                <div class="col-lg-3 col-md-3 col-8">
                  <div class="parent-checkbox px-3 mt-1 d-sm-flex">
                      <h5 class="pe-2">All Permissions</h5>
                      <input type="checkbox" class='header-checkbox form-control' id="check-all" data-url="{{ route('departments.permission-update', $user->id)}}">
                  </div>
                </div>

                <div class="col-lg-6 col-md-6">
                    <div class="ms-auto float-md-end">
                      <div class="btn-group">
                          <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                      </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body" id="tables">
            @include('departments.permission-edit-table')
        </div>
    </div>
    <!-- end main -->

@endsection
@section('js')
<script>
  $(document).ready(function(){

    function clear_icon(){
      $('#id_icon').html('');
      $('#post_title_icon').html('');
    }

    function fetch_data(query){
      $.ajax({
        url:"?query="+query,
        success:function(data){
         $('#tables').html('');
         $('#tables').html(data);
         $(document).ready(function(){$.switcher('.changeStatusCustom');});
       }
      })
    }

    $('body').on('input change', '#search', function(){
        var query = $('#search').val();
        fetch_data(query);
    });

    var a = $('.body-checkbox');
    if (a.length == a.filter(":checked").length){
      $('.header-checkbox').prop('checked', true);
      $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', true);
    } else {
      $('.header-checkbox').prop('checked', false);
      $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', false);
    }

    $(document).on('change', '.body-checkbox', function() {
      var a = $('.body-checkbox');
      if (a.length == a.filter(":checked").length){
        $('.header-checkbox').prop('checked', true);
        $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', true);
      } else {
        $('.header-checkbox').prop('checked', false);
        $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', false);
      }
    });

    $(document).on('change', '#check-all', function() {
      var parent = $('#permission-tables');
      if ($(this).is(':checked')) {
          parent.find('input[type="checkbox"]').prop('checked', true);
          parent.find('.ui-switcher').attr('aria-checked', true);
      } else {
          parent.find('input[type="checkbox"]').prop('checked', false);
          parent.find('.ui-switcher').attr('aria-checked', false);
      }

      var dataString = {"id":"all","status":$('.check-all').data('status')};
      var UrlValue   = $(this).data('url');

        $.ajax({
            url     : UrlValue,
            method  : 'post',
            data    :dataString,
            headers:
            {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            beforeSend: function( xhr ) {
                // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
            },
            success : function(response){
              if(response.success){
                $(this).Toastshow('success',response.message);

                if($('.check-all').data('status') == '0') {
                  $('.check-all').data('status',1);
                } else {
                  $('.check-all').data('status',0);
                }
              } else {
                  var ErroMsg = $(this).printErrorMsg(response.message);
                  if (ErroMsg === '') {
                      ErroMsg = "Something went wrong!";
                  }
                  $(this).Toastshow('error',ErroMsg);
              }
            }
        });
    });

  });

$(document).ready(function(){

    /*********change status**********/
    $(document).on("click",'.changeStatusCustom', function(event){
      dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
      var UrlValue     = $(this).data('url');
      var status       = $(this).data('status');
      var changeStatus = $(this);
      var btn = $(this);

      $.ajax({
          url     : UrlValue,
          method  : 'post',
          data    :dataString,
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          beforeSend: function( xhr ) {
              // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
          },
          success : function(response){
            console.log(response.success);
              if(response.success){
                $(this).Toastshow('success',response.message);
              } else {
                  var ErroMsg = $(this).printErrorMsg(response.message);
                  if (ErroMsg === '') {
                      ErroMsg = "Something went wrong!";
                  }
                  $(this).Toastshow('error',ErroMsg);

                  if (status == 1) {
                      changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                  } else {
                      changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                  }
              }
          },
          error: function (data) {
              console.log("error ",data);

              if (status == 1) {
                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
              } else {
                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
              }
          }
      });
    });
});
</script>
@endsection