<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
		        <th>Name</th>
		        {{-- <th>Code</th>
		        <th>Description</th> --}}
                <th class="thbutton" style="text-align: right">Priority</th>
		        <th style="width: 5%;">Page Break</th>
		        <th style="width: 8%;">Show In report</th>
		        <th style="width: 10%;">Show Report Heading</th>
		        <th class="thbutton">Status</th>
                @if(in_array('department-edit', $authRolePermissions))
		          <th class="thbutton">Edit</th>
                @endif
                @if(in_array('department-delete', $authRolePermissions))
		          <th class="thbutton">Delete</th>
                @endif
		    </tr>
	    </thead>
	    <tbody>
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $department)
				    <tr>
				        <td class="text-center">{{$data->firstItem() + $key}}</td>
				        <td style="white-space: break-spaces;">{{ $department->name }}</td>
				        {{-- <td>{{ $department->code }}</td>
				        <td style="white-space: break-spaces;">{{ $department->description }}</td> --}}
                        <td style="text-align: right">{{ $department->priority }}</td>
				        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('departments.pagebreakstatus')}}" data-id="{{$department->id}}" data-status="{{$department->page_break=='0' ? '1' : '0'}}" {{ $department->page_break=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('departments.showreport')}}" data-id="{{$department->id}}" data-status="{{$department->show_in_report=='0' ? '1' : '0'}}" {{ $department->show_in_report=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('departments.reportHeading')}}" data-id="{{$department->id}}" data-status="{{$department->show_report_heading=='0' ? '1' : '0'}}" {{ $department->show_report_heading=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('departments.changestatus')}}" data-id="{{$department->id}}" data-status="{{$department->status=='0' ? '1' : '0'}}" {{ $department->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('department-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $department->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('department-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('departments.destroy')}}" data-id="{{$department->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="5">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>
<nav class="row mt-3">
    <div class="col-lg-8 col-md-8 col-8 float-start">
        {!! $data->onEachSide(0)->render('departments.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
    @if(auth()->user()->can('department-import'))
      <div class="col-md-2" style="text-align: right;">
        <div class="btn-group mb-0">
            <a class="btn btn-outline-primary" href="{!! route('departments.import-create') !!}"><i class="bi bi-upload"></i> Upload from Excel</a>
        </div>
      </div>
    @endif
</nav>
</div>
