<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
		        <th>Name</th>
		        <th>Code</th>
		        <th class="thbutton">Priority</th>
		        <th class="thbutton">Discharge</th>
		        <th class="thbutton">Default</th>
		        <th class="thbutton">Status</th>
				
		         @if(in_array('discharge-types-edit', $authRolePermissions))
		        	<th class="thbutton">Edit</th>
		        @endif
		        @if(in_array('discharge-types-delete', $authRolePermissions))
		        	<th class="thbutton">Delete</th>
		        @endif
		    </tr>
	    </thead>
	    <tbody> 
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $type)
				    <tr>
				        <td>{{$data->firstItem() + $key}}</td>
				        <td>{{ $type->name }}</td>
				        <td>{{ $type->code }}</td>
				        <td>{{ $type->priority }}</td>
				        <td>
			         	<a class="btn btn-outline-primary button-large bg-primary text-white" href="{{route('ipd-discharge-type-settings-list' , $type->id)}}">
                        <i class="bi bi-gear-fill"></i> 
                        Settings  
                    	</a>
                	 	</td>
				        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('discharge-types.isdefault')}}" data-id="{{$type->id}}" data-status="{{$type->is_default=='0' ? '1' : '0'}}" {{ $type->is_default=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
				        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('discharge-types.changestatus')}}" data-id="{{$type->id}}" data-status="{{$type->status=='0' ? '1' : '0'}}" {{ $type->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                         @if(in_array('discharge-types-edit', $authRolePermissions))
                        <td>
                            <button data-id="{{ $type->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('discharge-types-delete', $authRolePermissions))
                        <td>
                            <a data-url="{{route('discharge-types.destroy')}}" data-id="{{$type->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="6">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>

<nav class="row align-items-center mt-2">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('discharge-types.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>