<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Doctor</th>
                <th>Shift</th>
                <th>Consulting Fee</th>
                <th class="thbutton">Status</th>
                @if(auth()->user()->can('doctor-fee-edit'))
                <th class="thbutton">Edit</th>
                @endif
                @if(auth()->user()->can('doctor-fee-delete'))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                <tr>
                        <td>{{$data->firstItem() + $key}}</td>
                        <td>{{ $list->getDoctor->getAccount->name ?? '-' }}</td>
                        <td>{{ $list->getShift->name ?? '-' }}</td>
                        <td>{{ $list->consulting_fees }}</td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('doctor-fee.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                         @if(auth()->user()->can('doctor-fee-edit'))
                        <td>
                            <button data-id="{{ $list->id }}" class="btn btn-warning edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                         @if(auth()->user()->can('doctor-fee-delete'))
                        <td>
                            <a data-url="{{route('doctor-fee.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="5">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="float-start mt-2">
    <ul class="pagination">
        {!! $data->onEachSide(0)->render('doctor-fee.pagination') !!}
    </ul>
</nav>
</div>

