<div class="card-body">
    <div class="table-responsive">
        <form action="" method="post" enctype='multipart/form-data'>

            @csrf
            @method('patch')
            <table class="table table-bordered align-middle" style="width:100%">
                <thead class="table-light">
                    <tr>
                        <th class="thbutton">Sl No</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Shift</th>
                        @if(in_array('opd-doctor-holiday-edit', $authRolePermissions))
                        <th class="thbutton">Edit</th>
                        @endif
                        @if(in_array('opd-doctor-holiday-delete', $authRolePermissions))
                        <th class="thbutton">Delete</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                   
                   @if(count($holiday_shifts)>0)
                    @foreach ($holiday_shifts as $key => $rows)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{formatedDate($rows->from_date)}}</td>
                            <td>{{formatedDate($rows->to_date)}}</td>
                            <td><span class="badge bg-info">{{$rows->getShift?$rows->getShift->name:''}}</span></td>
                            @if(in_array('opd-doctor-holiday-edit', $authRolePermissions))
                            <td class="text-center">
                                <a class="btn btn-outline-secondary edit" data-id="{{$rows->id}}" data-bs-toggle="modal"
                                    data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                                </a>
                            </td>
                            @endif
                            @if(in_array('opd-doctor-holiday-delete', $authRolePermissions))
                            <td class="text-center">
                                <a data-url="{{route('doctor-holiday-shifts.destroy',$rows->account_id)}}" data-id="{{$rows->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                </a>
                            </td>
                            @endif
                        </tr>
                    @endforeach
                    @else
                        <tr>
                            <td colspan="7">No Data Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </form>
    </div>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $holiday_shifts->onEachSide(0)->render('appointment-doctor-fees.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>