@extends('layouts.app')
@section('title', 'Doctors')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px;
        width: 30px;
        border-radius: 100%;
        padding: 0
    }

    .intl-tel-input {
        width: 100%;
    }

    .more-less {
        float: right;
        color: #212121;
    }

    .select2-selection--multiple {
        width: 98% !important;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>OPD Doctor List</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add New Doctor</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->
<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width doctor" action="{{ route('doctor.store') }}" method="post" enctype='multipart/form-data' id="doctor">
                        @csrf
                        <!-- validated columns -->
                        <!-- <form class="row g-3 was-validated"> -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Doctor Details</h5>
                                    <hr class="mb-0">

                                    {{-- Doctor Name --}}
                                    <div class="col-md-12">
                                        <div>
                                            <label for="account_id" class="form-label">Doctor Name <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="single-select-clients" name="account_id">
                                                <option value="">Select</option>
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a href="{{route('accounts.create')}}?redirect_back=true&type=doctor" class="btn btn-success" style="border-radius: 28.5px">+</a>
                                            </div>
                                        </div>
                                        @if ($errors->has('account_id'))
                                        <span class="text-danger">{{ $errors->first('account_id') }}</span>
                                        @endif
                                        <span class="text-danger error_account_id" style="display:none;">This field is required.</span>
                                    </div>

                                    <div class="col-md-11">
                                    <div>
                                        <label for="doctors_chamber_id" class="form-label">Doctor Chamber Name<span class="text-danger"><b></b></span></label>
                                    </div>
                                    <div class="input-group">
                                        <select class="single-select form-control" name="doctors_chamber_id">
                                            <option value=" "> Select Chamber</option>
                                            @foreach ($chambers as $list)
                                            <option value="{{ $list->id }}" {!! $list->is_default==1?'selected':'' !!}>{{ $list->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>

                                    {{-- Appointment Schedule --}}
                                    <div class="col-md-6">
                                        <div>
                                            <label for="opd_schedule_types_id" class="form-label">Appointment Schedule <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="single-select form-control" name="opd_schedule_types_id">
                                                @foreach ($opd as $list)
                                                <option value="{{ $list->id }}">{{ $list->name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <button class="btn btn-success add_btn" id="create_schedule_type" type="button" data-bs-toggle="modal" data-bs-target="#commonModal">+ </button>
                                            </div>
                                        </div>
                                        <span class="text-danger error_opd_schedule_types_id" style="display: none;">This field is required.</span>
                                    </div>
                                    <!-- Organization Department -->
                                    <div class="col-md-5">
                                        <label for="gap_between_two_patient" class="form-label">Time Gap Between Two Patient <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="gap_between_two_patient" name="gap_between_two_patient" aria-describedby="inputGroupPrepend" value="10" required>
                                    </div>
                                    <!-- Qualification -->

                                    <div class="col-md-12">
                                        <div>
                                            <label class="form-label">Consultation Fees <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group autocomplete">
                                            <select class="form-control multi-select-product" id="product_id" multiple="multiple" name="product_id[]">

                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a class="btn btn-success add_btn" href="{{route('products.create')}}?redirect_back=true&type=doctor&division=OPD">+ </a>
                                            </div>
                                        </div>
                                        <span class="text-danger error_product_id" style="display:none;">This field is required.</span>
                                        <!-- <input type="hidden" name="product_id"> -->
                                    </div>

                                </div>
                                <div class="card-body g-3 row additional_fields">
                                    <div class="card">
                                        <div class="card-body g-3 row">
                                            <h5 class="mb-0">Additional Information </h5>
                                            <a href="javascript:void(0)" class="hiddenReferral fw-bold" id="add_reference"><i class="bx bx-plus"></i> Add Additional Information</a>
                                            <hr class="mb-0">

                                            {{-- Specialist In --}}
                                            <div class="col-md-6 references" style="display:none;">
                                                <label for="specialist_in" class="form-label">Specialist In </label>
                                                <input type="text" class="form-control" id="specialist_in" name="specialist_in" aria-describedby="inputGroupPrepend">
                                                <span class="text-danger error_specialist_in" style="display:none;">This field is required.</span>
                                            </div>

                                            {{-- Medical License No --}}
                                            <div class="col-md-6 references" style="display:none;">
                                                <label for="medical_license_no" class="form-label">Medical License No </label>
                                                <input type="text" class="form-control" id="medical_license_no" name="medical_license_no" aria-describedby="inputGroupPrepend">
                                                <span class="text-danger error_medical_license_no" style="display:none;">This field is required.</span>
                                            </div>

                                            {{-- API Salt Key --}}
                                            <div class="col-md-6 references" style="display:none;">
                                                <label for="api_salt_key" class="form-label">API Salt Key </label>
                                                <input type="text" class="form-control" id="api_salt_key" name="api_salt_key" aria-describedby="inputGroupPrepend">
                                                <span class="text-danger error_api_salt_key" style="display:none;">This field is required.</span>
                                            </div>

                                            {{-- Priority --}}
                                            <div class="col-md-6 references" style="display:none;">
                                                <label for="priority" class="form-label">Priority</label>
                                                <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
                                                <span class="text-danger error_priority" style="display:none;">This field is required.</span>
                                            </div>


                                            <div class="col-md-6 references" style="display:none;">
                                                <label for="language_id" class="form-label">Language <span class="text-danger"><b></b></span></label>
                                                <select class="single-select form-control" name="language_id">
                                                    <option value=" "> Select Language</option>
                                                    @foreach ($languages as $list)
                                                    <option value="{{ $list->id }}">{{ $list->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>



                                            <div class="col-md-6 references" style="display:none;">
                                                <label for="experience" class="form-label">Experience <span class="text-danger"><b></b></span></label>
                                                <input type="text" class="form-control" placeholder="Experience" name="experience">
                                            </div>
                                            <div class="col-md-12 references" style="display:none;" id="test_items">
                                                <label for="organization_department_id" class="form-label">Organization Department </label>
                                            </div>
                                            <div class="input-group references" style="display:none;">
                                                <select class="multi-select-tests" multiple name="organization_department_id[]">
                                                    @foreach ($department as $list)
                                                    <option value="{{ $list->id }}">{{ $list->name }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="input-group-append col-md-1">
                                                    <button class="btn btn-success add_btn" id="create_orgazination_department" type="button" data-bs-toggle="modal" data-bs-target="#commonModal" style="margin-right: 10px;">+ </button>
                                                </div>
                                            </div>
                                            <span class="text-danger error_organization_department_id" style="display: none;">This field is required.</span>

                                        </div>
                                    </div>
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                            <button class="btn btn-primary save_doctor">Save Doctor</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body row">

                                    <div class="col-md-12 mt-1">
                                        <table class="table table-bordered align-middle border" style="width:100%" id="tableshift">
                                            <thead class="table-light">
                                                <tr>
                                                    <th class="thbutton">#</th>
                                                    <th>
                                                        <div class="row">
                                                            <div class="col-md-5">
                                                                Shifts
                                                            </div>
                                                            <div class="col-md-7 text-right" align="right">(Allow All Shifts)</div>
                                                        </div>
                                                    </th>
                                                    <td class="thbutton" style="color:#6c757d"><b>Status</b>
                                                        <div class="parent-checkbox d-sm-flex">
                                                            <input type="checkbox" class='header-checkbox' class="form-control" id="check-all">
                                                        </div>
                                                    </td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(count($appointment_shifts) > 0)
                                                @foreach ($appointment_shifts as $key => $shift)
                                                <tr>
                                                    <td>{{$key+1}}</td>
                                                    <td>{{ ucfirst($shift->name) }}</td>
                                                    <td class="text-center">
                                                        <input class="body-checkbox shifts_click" data-shift_id="{{$shift->id}}" type="checkbox" name="shift_id[]" value="{{$shift->id}}">
                                                    </td>
                                                </tr>
                                                @endforeach
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <div class="col-md-12">
                                        <table class="table table-bordered  border align-middle" style="width:100%" id="tabledays">
                                            <thead class="table-light">
                                                <tr>
                                                    <th class="thbutton">#</th>
                                                    <th>
                                                        <div class="row">
                                                            <div class="col-md-5">Days</div>
                                                            <div class="col-md-7 text-right" align="right">(Allow All Days)</div>
                                                        </div>
                                                    </th>
                                                    <td class="thbutton" style="color:#6c757d">
                                                        <b>Status</b>
                                                        <input type="checkbox" class='header-checkbox' class="form-control" id="check-all-days">
                                                    </td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach (daysOfWeek() as $key => $day)
                                                <tr>
                                                    <td>{{$key+1}}</td>
                                                    <td>
                                                        {!! $day !!}
                                                    </td>
                                                    <td class="text-center">
                                                        <input class="body-checkbox days_click" data-day_id="{{$key}}" type="checkbox" name="day_id[]" value="{{ $key }}">
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script>
    $(document).on('change', '#check-all', function() {
        var parent = $('#tableshift');
        if ($(this).is(':checked')) {
            parent.find('input[type="checkbox"]').prop('checked', true);
            parent.find('.ui-switcher').attr('aria-checked', true);
        } else {
            parent.find('input[type="checkbox"]').prop('checked', false);
            parent.find('.ui-switcher').attr('aria-checked', false);
        }
    });

    $(document).on('change', '#check-all-days', function() {
        var parent = $('#tabledays');
        if ($(this).is(':checked')) {
            parent.find('input[type="checkbox"]').prop('checked', true);
            parent.find('.ui-switcher').attr('aria-checked', true);
        } else {
            parent.find('input[type="checkbox"]').prop('checked', false);
            parent.find('.ui-switcher').attr('aria-checked', false);
        }
    });

    $(document).on('click', '#add_reference', function() {
        if ($('#add_reference').hasClass('hiddenReferral')) {
            $('.references').show();
            $('#add_reference').html('<i class="bx bx-minus"></i> Hide Additional Information');
            $('#add_reference').removeClass('hiddenReferral');
        } else {
            $('.references').hide();
            $('#add_reference').html('<i class="bx bx-plus"></i> Add Additional Information');
            $('#add_reference').addClass('hiddenReferral');
        }
    });

    $('.single-select-clients').select2({
        theme: 'bootstrap4',
        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(this).data('placeholder'),
        allowClear: Boolean($(this).data('allow-clear')),
        ajax: {
            url: "{!! route('get-Accounts') !!}",
            dataType: 'json',
            delay: 250,
            processResults: function(data) {
                return {
                    results: $.map(data, function(item) {
                        return {
                            text: item.name,
                            id: item.id
                        }
                    })
                };
            },
            cache: true
        }
    });

    $('.multi-select-tests').select2({
        theme: 'bootstrap4',
        dropdownParent: $("#test_items"),
        placeholder: "Select Test Items",
        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        allowClear: Boolean($(this).data('allow-clear')),
    });






    // Adding  Schedule Type
    $(document).on('click', '#create_schedule_type', function() {
        $('#commonModalLabel').text('Add New Appointment Schedule');
        $('.save_button_span').text('Save Appointment Schedule');
        $.ajax({
            url: "{!! route('opd-schedule-type.create') !!}",
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        })
    })
    // Adding Organization Department
    $(document).on('click', '#create_orgazination_department', function() {
        $('#commonModalLabel').text('Add New Organization Department');
        $('.save_button_span').text('Save Organization Department');
        $.ajax({
            url: "{!! route('organization-department.create') !!}",
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        })
    })

    $(document).on('click', '.save_button', function(event) {
        event.preventDefault();
        var error = 0;
        if ($('#commonModal').find('form').hasClass('schedule_type')) {
            $('.error_name').hide();
            if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
                $('.error_name').show();
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({
                        url: $('#commonModal').find('form').attr('action'),
                        data: formdata,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        success: function(response) {


                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');
                                $('[name="opd_schedule_types_id"]').append(`<option value="${response.data.id}" selected>${response.data.name}</option>`);
                                $('[name="opd_schedule_types_id"]').trigger('change');

                                // hide modal
                                $('#commonModal').modal('hide');
                                $('#commonModal').find('.modal-body').html('');
                                setTimeout(function() {
                                    //  alert('test');
                                    $('#create').trigger('click');
                                }, 1000);
                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');

                        // hide modal
                        $('#commonModal').modal('hide');
                        $('#commonModal').find('.modal-body').html('');
                    });
            }

        } else if ($('#commonModal').find('form').hasClass('orgazination_department')) {
            $('.error_name').hide();
            if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
                $('.error_name').show();
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({
                        url: $('#commonModal').find('form').attr('action'),
                        data: formdata,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        success: function(response) {


                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');
                                $('[name="organization_department_id"]').append(`<option value="${response.data.id}" selected>${response.data.name}</option>`);
                                $('[name="organization_department_id"]').trigger('change');
                                // hide modal
                                $('#commonModal').modal('hide');
                                $('#commonModal').find('.modal-body').html('');
                                setTimeout(function() {
                                    //  alert('test');
                                    $('#create').trigger('click');
                                }, 1000);
                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');

                        // hide modal
                        $('#commonModal').modal('hide');
                        $('#commonModal').find('.modal-body').html('');
                    });
            }

        }

    })
    $(document).on('click', '.save_doctor', function(e) {
        e.preventDefault();
        $('.error_account_id').hide();
        $('.error_opd_schedule_types_id').hide();
        $('.error_shift_id').hide();
        $('.error_organization_department_id').hide();
        $('.qualification').hide();
        var error = 0;

        if ($('select[name="account_id"]').val() == null || $('select[name="account_id"]').val() == '') {
            $('.error_account_id').show();
            error = 1;
        }
        if ($('select[name="opd_schedule_types_id"]').val() == null || $(
                'select[name="opd_schedule_types_id"]')
            .val() == '') {
            $('.error_opd_schedule_types_id').show();
            error = 1;
        }
        var selectedValues = $('select[name="organization_department_id[]"]').val();

        // Check if no values are selected
        // if (!selectedValues || selectedValues.length === 0) {
        //     $('.error_organization_department_id').show(); // Show the error message
        //     error = 1;
        // }

        // if ($('input[name="qualification"]').val() == null || $('input[name="qualification"]').val().trim() ==
        //     '') {
        //     $('.error_qualification').show();
        //     error = 1;
        // }
        if (error == 0) {
            let formdata = new FormData($('#doctor')[0]);
            $.ajax({
                    url: "{{ route('doctor.store') }}",
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function(response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            window.location.href = "{{ route('doctor.index') }}";
                            // Replace with the URL you want to redirect to
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
        }
        error = 1;
    });



    $(document).ready(function() {
        $('.multi-select-product').select2({
            theme: 'bootstrap4',
            dropdownParent: $("#test_items"),
            placeholder: "Search Product Items",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            allowClear: Boolean($(this).data('allow-clear')),
        });
        $('#product_id').select2({
            minimumInputLength: 2,
            ajax: {
                url: "{{ route('doctor-fee-search-products') }}",
                type: 'POST',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search_text: params.term,
                    }
                },
                processResults: function(data) {
                    return {
                        results: $.map(data.result, function(item) {
                            return {
                                id: item.id,
                                text: item.name + " - (" + item.mrp + ")",
                            }
                        })
                    }
                },
            }

        });
    })
</script>
@endsection
