@extends('layouts.app')
@section('title', 'Doctors')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px;
        width: 30px;
        border-radius: 100%;
        padding: 0
    }

    .intl-tel-input {
        width: 100%;
    }

    .more-less {
        float: right;
        color: #212121;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>OPD Doctor List</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Update Doctor</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('doctor.update', $doc->id) }}" method="POST" enctype='multipart/form-data' id="tax_master_sub_form">
                        @csrf
                        @method('patch')
                        <!-- validated columns -->
                        <!-- <form class="row g-3 was-validated"> -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Doctor Details</h5>
                                    <hr class="mb-0">

                                    {{-- Doctor Name --}}
                                    <div class="col-md-12">
                                        <div>
                                            <label for="account_id" class="form-label">Doctor Name <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="single-select-clients" name="account_id" disabled>
                                                @foreach ($account as $list)
                                                <option value="{{ $list->id }}" {{ $list->id == $doc->account_id ? 'selected' : '' }}>
                                                    {{ $list->name }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($errors->has('account_id'))
                                        <span class="text-danger">{{ $errors->first('account_id') }}</span>
                                        @endif
                                        <span class="text-danger error_account_id" style="display:none;">This field is required.</span>
                                    </div>

                                    <div class="col-md-12">
                                        <label for="doctors_chamber_id" class="form-label">Doctor Chamber Name <span class="text-danger"><b></b></span></label>
                                        <select class="single-select form-control" name="doctors_chamber_id">
                                            <option value=" "> Select Chamber</option>
                                            @foreach ($chambers as $list)
                                            <option value="{{ $list->id }}" {!! $doc->doctors_chamber_id==$list->id?'selected':'' !!}>{{ $list->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    {{-- else --}}
                                    {{-- <div class="col-md-12">
                                            <label for="account_id" class="form-label">Doctor Name <span class="text-danger"><b>*</b></span></label>
                                            <input type="text" class="form-control" value="{{ $doc->account_id }}" disabled>
                                    @if ($errors->has('account_id'))
                                    <span class="text-danger">{{ $errors->first('account_id') }}</span>
                                    @endif
                                </div> --}}

                                {{-- Appointment Schedule --}}
                                <div class="col-md-6">
                                    <div>
                                        <label for="opd_schedule_types_id" class="form-label">Appointment Schedule
                                            <span class="text-danger"><b>*</b></span></label>
                                    </div>
                                    <div class="input-group">
                                        <select class="single-select form-control" name="opd_schedule_types_id">
                                            @foreach ($opd as $list)
                                            <option value="{{ $list->id }}" {{ $list->id == $doc->opd_schedule_types_id ? 'selected' : '' }}>
                                                {{ $list->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <span class="text-danger error_opd_schedule_types_id" style="display: none;">This field is required.</span>
                                </div>
                                {{-- Organization Department --}}
                                <div class="col-md-6" id="test_items">
                                    <label for="organization_department_id" class="form-label">Organization Department </label>
                                    @php
                                    $days = explode(',', $doc->organization_department_id);
                                    @endphp
                                    <select class="multi-select-tests" name="organization_department_id[]">

                                        @foreach ($department as $key => $list)
                                        <option list="{{ $list->id }}" {{  (in_array($list->id,$days))? 'selected' : '' }}
                                            value="{{ $list->id }}">
                                        {{ $list->name }}</option>
                                        </option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger error_organization_department_id" style="display: none;">This field is required.</span>
                                </div>

                                <div class="col-md-12">
                                    <label for="gap_between_two_patient" class="form-label">Time Gap Between Two Patient <span class="text-danger"><b>*</b></span></label>
                                    <input type="text" class="form-control" id="gap_between_two_patient" name="gap_between_two_patient" aria-describedby="inputGroupPrepend" value="{{ $doc->gap_between_two_patient }}" required>
                                </div>
                                <div class="col-md-12">
                                        <div>
                                            <label class="form-label">Consultation Fees <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group autocomplete">
                                            <select class="form-control multi-select-product" id="product_id" multiple="multiple" name="product_id[]">
                                            @foreach($appointFees as $row)
                                            <option value="{!! $row->product_id??'' !!}" selected>{!! (isset($row->getProduct)&&$row->getProduct)?$row->getProduct->name:'' - ( (isset($row->getProductPrice)&&$row->getProductPrice)?$row->getProductPrice->mrp:'') !!}</option>
                                            @endforeach
                                            </select>
                                            <div class="input-group-append" style="margin: auto 10px;">
                                                <a class="btn btn-success add_btn" href="{{route('products.create')}}?redirect_back=true&type=doctor&division=OPD">+ </a>
                                            </div>
                                        </div>
                                        <span class="text-danger error_product_id" style="display:none;">This field is required.</span>
                                    </div>
                            </div>
                            <div class="card-body g-3 row additional_fields">
                                <h5 class="mb-0">Additional Information</h5>
                                <a href="javascript:void(0)" class="hiddenReferral fw-bold" id="add_reference">
                                    <i class="bx bx-plus"></i> Add Additional Information
                                </a>
                                <hr class="mb-0">

                                {{-- Specialist In --}}
                                <div class="col-md-6 references" style="display:none;">
                                    <label for="specialist_in" class="form-label">Specialist In </label>
                                    <input type="text" class="form-control" id="specialist_in" name="specialist_in" aria-describedby="inputGroupPrepend" value="{{ $doc->specialist_in }}">
                                    <span class="text-danger error_specialist_in" style="display:none;">This field
                                        is required.</span>
                                </div>

                                {{-- Medical License No --}}
                                <div class="col-md-6 references" style="display:none;">
                                    <label for="medical_license_no" class="form-label">Medical License No </label>
                                    <input type="text" class="form-control" id="medical_license_no" name="medical_license_no" aria-describedby="inputGroupPrepend" value="{{ $doc->medical_license_no }}">
                                    <span class="text-danger error_medical_license_no" style="display:none;">This
                                        field is required.</span>
                                </div>

                                {{-- API Salt Key --}}
                                <div class="col-md-6 references" style="display:none;">
                                    <label for="api_salt_key" class="form-label">API Salt Key </label>
                                    <input type="text" class="form-control" id="api_salt_key" name="api_salt_key" aria-describedby="inputGroupPrepend" value="{{ $doc->api_salt_key }}">
                                    <span class="text-danger error_api_salt_key" style="display:none;">This field
                                        is required.</span>
                                </div>

                                {{-- Priority --}}
                                <div class="col-md-6 references" style="display:none;">
                                    <label for="priority" class="form-label">Priority</label>
                                    <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $doc->priority !!}" readonly>
                                    <span class="text-danger error_priority" style="display:none;">This field is
                                        required.</span>
                                </div>
                                <div class="col-md-6 references" style="display:none;">
                                    <label for="language_id" class="form-label">Language <span class="text-danger"><b></b></span></label>
                                    <select class="single-select form-control" name="language_id">
                                        <option value=" "> Select Language</option>
                                        @foreach ($languages as $list)
                                        <option value="{{ $list->id }}" {!! (isset($doc->language_id) && $doc->language_id==$list->id)?'selected':''  !!}>{{ $list->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6 references" style="display:none;">
                                    <label for="experience" class="form-label">Experience <span class="text-danger"><b></b></span></label>
                                    <input type="text" class="form-control" placeholder="Experience" name="experience">
                                </div>
                                <div class="col-md-6 references" style="display:none;">
                                    <label for="convert_to_sale" class="form-label">Convert To Sale</label>
                                    <input type="checkbox" name="convert_to_sale" value="{!! ($doc->convert_to_sale==1)?1:0; !!}" {!! ($doc->convert_to_sale==1)?'checked':''; !!}>
                                </div>
                            </div>

                            <div class="card-body g-3 row">
                                <div class="col-12" align="center">
                                    <div class="d-grid gap-2 with-100">
                                        <button class="btn btn-primary save_doctor">Save Doctor</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body g-3 row">
                            <div class="col-md-12">
                                <table class="table table-bordered border align-middle" style="width:100%" id="tableshift">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="thbutton">#</th>
                                            <th>Shifts (Allow All Shifts)</th>
                                            <td class="thbutton" style="color:#6c757d"><b>Status</b>
                                                <div class="parent-checkbox d-sm-flex">
                                                    <input type="checkbox" class='header-checkbox' class="form-control" id="check-all">
                                                </div>
                                            </td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php $doctor_shift_ids = explode(',', $doctor_shifts->shifts);
                                        $doctor_days = explode(',', $doctor_days->days) ?? [];
                                        @endphp
                                        @if(count($appointment_shifts) > 0)
                                        @foreach ($appointment_shifts as $key => $shift)
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td>{{ ucfirst($shift->name) }}</td>
                                            <td class="text-center">
                                                <input class="body-checkbox shifts_click" data-shift_id="{{$shift->id}}" type="checkbox" {!! in_array($shift->id, $doctor_shift_ids) ? 'checked' : '' !!} name="shift_id[]" value="{{$shift->id}}">
                                            </td>
                                        </tr>
                                        @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body g-3 row">
                            <div class="col-md-12">
                                <table class="table table-bordered border align-middle" style="width:100%" id="tabledays">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="thbutton">#</th>
                                            <th>Days (Allow All Days)</th>
                                            <td class="thbutton" style="color:#6c757d">
                                                <b>Status</b>
                                                <input type="checkbox" class='header-checkbox' class="form-control" id="check-all-days">
                                            </td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach (daysOfWeek() as $key => $day)
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td>
                                                {!! $day !!}
                                            </td>
                                            <td class="text-center">
                                                <input class="body-checkbox days_click" data-day_id="{{$key}}" type="checkbox" name="day_id[]" value="{{ $key }}" {!! in_array($key, $doctor_days) ? 'checked' : '' !!}>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script>
    $(document).on('change', '#check-all', function() {
        var parent = $('#tableshift');
        if ($(this).is(':checked')) {
            parent.find('input[type="checkbox"]').prop('checked', true);
            parent.find('.ui-switcher').attr('aria-checked', true);
        } else {
            parent.find('input[type="checkbox"]').prop('checked', false);
            parent.find('.ui-switcher').attr('aria-checked', false);
        }
    });

    $(document).on('change', '#check-all-days', function() {
        var parent = $('#tabledays');
        if ($(this).is(':checked')) {
            parent.find('input[type="checkbox"]').prop('checked', true);
            parent.find('.ui-switcher').attr('aria-checked', true);
        } else {
            parent.find('input[type="checkbox"]').prop('checked', false);
            parent.find('.ui-switcher').attr('aria-checked', false);
        }
    });

    $(document).on('click', '#add_reference', function() {
        if ($('#add_reference').hasClass('hiddenReferral')) {
            $('.references').show();
            $('#add_reference').html('<i class="bx bx-minus"></i> Hide Additional Information');
            $('#add_reference').removeClass('hiddenReferral');
        } else {
            $('.references').hide();
            $('#add_reference').html('<i class="bx bx-plus"></i> Add Additional Information');
            $('#add_reference').addClass('hiddenReferral');
        }
    });

    $('.single-select-clients').select2({
        theme: 'bootstrap4',
        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(this).data('placeholder'),
        allowClear: Boolean($(this).data('allow-clear')),
        ajax: {
            url: "{!! route('get-Accounts') !!}",
            dataType: 'json',
            delay: 250,
            processResults: function(data) {
                return {
                    results: $.map(data, function(item) {
                        return {
                            text: item.name,
                            id: item.id
                        }
                    })
                };
            },
            cache: true
        }
    });

    $('.multi-select-tests').select2({
        theme: 'bootstrap4',
        dropdownParent: $("#test_items"),
        placeholder: "Select Test Items",
        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        allowClear: Boolean($(this).data('allow-clear')),
    });



    $(document).on('click', '#save_doctor', function() {
        $('#commonModalLabel').text('Add New Contact');
        $('.save_button_span').text('Save Contact');
        $.ajax({
            url: "{!! route('enquiry-contacts-model') !!}",
            success: function(data) {
                $('#commonModal').addClass('contact');
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
                reinitializeTelInput();
            }
        })
    })

    $(document).on('submit', '.save_doctor', function(e) {
        e.preventDefault();

        $('.error_account_id').hide();
        $('.error_opd_schedule_types_id').hide();
        $('.error_shift_id').hide();
        $('.error_organization_department_id').hide();
        $('.qualification').hide();
        var error = 0;

        if ($('select[name="account_id"]').val() == null || $('select[name="account_id"]')
            .val() == '') {
            $('.error_account_id').show();
            error = 1;
        }
        if ($('select[name="schedule_types_id"]').val() == null || $('select[name="schedule_types_id"]')
            .val() ==
            '') {
            $('.opd_schedule_types_id').show();
            error = 1;
        }
        if ($('select[name="shift_id"]').val() == null || $('select[name="shift_id"]').val() == '') {
            $('.error_shift_id').show();
            error = 1;
        }
        // if ($('input[name="organization_department_id"]').val() == null || $('input[name="organization_department_id"]').val() == '') {
        //     $('.error_organization_department_id').show();
        //     error = 1;
        // }
        // if ($('input[name="qualification"]').val() == null || $('input[name="qualification"]').val() == '') {
        //     $('.error_qualification').show();
        //     error = 1;
        // }
        if (error == 0) {

            let formdata = new FormData($('#doctor')[0]);


        }
        error = 1;
    })


    $(document).ready(function() {
        $('.multi-select-product').select2({
            theme: 'bootstrap4',
            dropdownParent: $("#product_id"),
            placeholder: "Search Product Items",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            allowClear: Boolean($(this).data('allow-clear')),
        });

      

        $('#product_id').select2({
            minimumInputLength: 2,
            ajax: {
                url: "{{ route('doctor-fee-search-products') }}",
                type: 'POST',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search_text: params.term,
                    }
                },
                processResults: function(data) {
                    return {
                        results: $.map(data.result, function(item) {
                            return {
                                id: item.id,
                                text: item.name + " - (" + item.mrp + ")",
                            }
                        })
                    }
                },
            }

        });
    })

</script>
@endsection
