<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Serial No</th>
                <th>Name</th>
                <th>Department</th>
                <th class="thbutton"> Doctor Shift</th>
                @if(in_array('opd-doctor-prescription-list', $authRolePermissions))
                <th class="thbutton"> Prescription</th>
                @endif
                @if(in_array('opd-doctor-holiday-list', $authRolePermissions))
                <th class="thbutton"> Holiday Settings</th>
                @endif
                <th class="thbutton">Web Booking</th>
                <th class="thbutton">App Booking</th>
                <th class="thbutton">Status</th>
                @if(in_array('doctor-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('doctor-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{{ $list->getAccount->name ?? '-' }}<br>
                           {{-- <b>{!! $list->getAccount->account_contact?$list->getAccount->account_contact->qualifications:'' !!}</b>--}}
                        </td>
                        <td>{{ $list->getOrganizatioDepartment->name ?? '-' }}</td>
                        <td>
                            <div class="btn-group" style="width: 100%">
                                <a href="{{ route('appointment-doctor-shifts.index', ['id' => $list->id]) }}" class="btn btn-success" style="color: white">Settings</a>
                            </div>
                        </td>
                        @if(in_array('opd-doctor-prescription-list', $authRolePermissions))
                        <td>
                            <div class="btn-group" style="width: 100%">
                                <a href="{{ route('doctor-prescription.index', ['id' => $list->id]) }}" class="btn btn-success" style="color: white">Settings</a>
                            </div>
                        </td>
                        @endif
                        @if(in_array('opd-doctor-holiday-list', $authRolePermissions))
                        <td>
                            <div class="btn-group" style="width: 100%">
                                <a href="{{ route('doctor-holiday-shifts.index', ['id' => $list->id]) }}" class="btn btn-success" style="color: white">Settings</a>
                            </div>
                        </td>
                        @endif
                        <td class="text-center">
                            <input class="body-checkbox web_booking_click" data-shift_id="{{$list->id}}" type="checkbox" {!! $list->web_booking=='1' ? 'checked' : '' !!} name="shift_id[{{ $list->id }}]">
                        </td>
                        <td class="text-center">
                            <input class="body-checkbox app_booking_click" data-shift_id="{{$list->id}}" type="checkbox" {!! $list->app_booking=='1' ? 'checked' : '' !!} name="shift_id[{{ $list->id }}]">
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{ $i }}">
                                <input class="form-check-input{{ $i }} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{ $i }}" data-url="{{ route('doctor.changestatus') }}" data-id="{{ $list->id }}" data-status="{{ $list->status == '0' ? '1' : '0' }}"
                                    {{ $list->status == '1' ? 'checked' : '' }}>
                            </div>
                        </td>
                        @if(in_array('doctor-edit', $authRolePermissions))
                        <td class="text-center">
                            <a href="{{route('doctor.edit',$list->id)}}" class="btn btn-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        @endif
                        @if(in_array('doctor-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('doctor.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="11">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
    {!! $data->onEachSide(0)->render('doctor.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

