@extends('layouts.app')
@section('title','Documents Type')
@section('activePage','Documents Type')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Documents Type</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        <li class="breadcrumb-item"><a href="#"> </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">Documents Type</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      @if(auth()->user()->can('document-types-create'))
        <button type="button" class="btn btn-success" id="create"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
      @endif
    </div>
  </div>
</div>
<!--end breadcrumb-->

<div class="card shadow-none radius-5 min-height">
  <div class="card-header py-3">
   <div class="row g-3">
     <div class="col-lg-3 col-md-6 me-auto">
       <div class="ms-auto position-relative">
         <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
         <input class="form-control ps-5" type="search" id="search" placeholder="Search License">
       </div>
     </div>
     <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length">
       <select class="form-select sorting" id="" name="example_length" aria-controls="example">
         <option value="10">Show: 10</option>
         <option value="30">Show: 30</option>
         <option value="50">Show: 50</option>
       </select>
     </div>
   </div>
 </div>
 <div class="card-body" id="tables">
  
   @include('document-types.table')
   
   <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
   <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
   <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
 </div>

 <script>
  $(document).ready(function(){
    function clear_icon(){
      $('#id_icon').html('');
      $('#post_title_icon').html('');
    }

    $(document).on('click', '#create', function(){
      $('#commonModalLabel').text('Add New Documents Type');
      $('.save_button_span').text('Save Documents Type');
      $.ajax({
        url:"{!! route('document-types.create') !!}",
        success:function(data){
          $('#commonModal').find('.modal-body').html('');
          $('#commonModal').find('.modal-body').html(data);

          $('.single-select').select2({
              theme: 'bootstrap4',
              width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
              placeholder: $(this).data('placeholder'),
              allowClear: Boolean($(this).data('allow-clear')),
          });
        }
      })
    })

    $(document).on('click', '.edit', function(){
      $('#commonModalLabel').text('Edit Documents Type');
      $('.save_button_span').text('Update Documents Type');
      var id = $(this).data('id');
      var url = `{!! route('document-types.edit', ':id') !!}`.replace(':id', id);

      $.ajax({
        url:url,
        success:function(data){
          $('#commonModal').find('.modal-body').html('');
          $('#commonModal').find('.modal-body').html(data);


          $('.single-select').select2({
              theme: 'bootstrap4',
              width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
              placeholder: $(this).data('placeholder'),
              allowClear: Boolean($(this).data('allow-clear')),
          });
        }
      })
    })

    $(document).on('click', '.save_button', function(event){
      event.preventDefault();
      var error = 0;
      $('.error_country_id').hide();
      $('.error_license_code').hide();
      $('.error_license_type_name').hide();

      var country_id        = $('#commonModal').find('form').find('select[name="country_id"]').val();
      var license_code      = $('#commonModal').find('form').find('input[name="license_code"]').val();
      var license_type_name = $('#commonModal').find('form').find('input[name="license_type_name"]').val();

      if (country_id == '') {
        $('.error_country_id').show();
        error = 1;
      }
      if (license_type_name == '') {
        $('.error_license_type_name').show();
        error = 1;
      }
      if (license_code == '') {
        $('.error_license_code').show();
        error = 1;
      }

      if (error == 0) {
        $('#commonModal').find('form').submit();
      }
    })

    function fetch_data(page, sort_type, sort_by, query){
      $.ajax({
        url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query,
        success:function(data){
          $('#tables').html('');
          $('#tables').html(data);
          $(document).ready(function(){$.switcher();});
        }
      })
    }
    $('body').on('keyup change input', '#search', function(){
      var query = $('#search').val();
      var column_name = $('.sorting').val();
      var sort_type = $('#hidden_sort_type').val();
      var page = 1?1:(this).attr('href').split('page=')[1];
      fetch_data(page, sort_type, column_name, query);
    });
    $('body').on('change', '.sorting', function(){

      var column_name = $(this).val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      fetch_data(page, reverse_order, column_name, query);
    });
    $('body').on('click', '.pager a', function(event){
      event.preventDefault();
      console.log('url', $(this).attr('href'));
      var page = $(this).attr('href').split('page=')[1];
      $('#hidden_page').val(page);
      var column_name = $('.sorting').val()?$('.sorting').val():'';
      var sort_type = $('#hidden_sort_type').val();
      var query = $('#search').val()?$('#search').val():'';
      $('li').removeClass('active');
      $(this).parent().addClass('active');
      fetch_data(page, sort_type, column_name, query);
    });
  });
</script>
@endsection