<form class="row g-3 auto-width edit_doubt_sessions" id="edit_doubt_sessions_form" enctype='multipart/form-data' action="{!! route('doubt-sessions.update' , $doubt_sessions->id)  !!}">
    @csrf
    @method('POST')
           
        <div class="col-md-6">
            <label for="subject" class="form-label"> Subject </label>
            <input type="text" name="subject" id="subject" class="form-control" value="{!! $doubt_sessions->subject!!}">
        </div>

        <div class="col-md-6">
            <label for="description" class="form-label"> Description </label>
            <input type="text" name="description" id="description" class="form-control" value="{!! $doubt_sessions->description!!}">
        </div>

        <div class="col-md-6">
            <label for="scheduled_date" class="form-label">Scheduled Date</label>
            <input type="datetime-local" name="scheduled_date" id="scheduled_date" class="form-control" value="{!! $doubt_sessions->scheduled_date !!}">
        </div>

        <div class="col-md-6">
            <label for="class_id" class="form-label">Classes</label>
            <div class="input-group">
                <select class="form-control" name="class_id" id="class_id">
                    <option value="">Select Classes</option>
                    @foreach($classes as $class)
                    <option value="{!! $class->id !!}" {!! $class->id == $doubt_sessions->class_id ? 'selected' : '' !!}>{!! $class->class_name!!}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="col-md-6">
            <label for="course_id" class="form-label">Courses</label>
            <div class="input-group">
                <select class="form-control" name="course_id" id="course_id">
                    <option value="">Select Course</option>
                    @foreach($courses as $course)
                    <option value="{!! $course->id !!}" {!! $course->id == $doubt_sessions->course_id ? 'selected' : '' !!}>{!! $course->course_title !!}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="col-md-6">
            <label for="user_id" class="form-label">Students</label>
            <div class="input-group autocomplete">
                <input type="text" id="user_id" class="user-select form-control" placeholder="Search User" value="{!! $accounts->name !!}">
                <ul class="searchResult"></ul>
                <input type="hidden" name="user_id" value="{!! $accounts->name !!}">
            </div>
        </div>
</form>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script type="text/javascript">
    
$(document).ready(function(){
    $('.user-select').autocomplete({
    autoFocus: true,
    minLength: 0,
    source: function(request, response) {
        if (request.term.length < 2) {
            $('[name="user_id"]').val('');
            return false;
        }

        $.ajax({
            url     : "{!!  route('users-search-accounts')  !!}",
            type    : 'POST',
            dataType: 'json',
            data    : {
                search_text: request.term
            },
            success: function(json) {
                if (json.error) {
                    $('[name="user_id"]').val('');
                    return false;
                }
                response($.map(json.result, function(item) {
                    return {
                        id           : item.id,
                        name         : item.name,
                        code         : item.code,
                        gender       : item.gender,
                        phone_no     : item.phone_no,
                        date_of_birth: item.date_of_birth,
                    };
                }));
            }
        });
    },
    select: function(event, ui) {
        event.preventDefault();
        var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
        var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
        var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
        var code     = ui.item.code != null ? ', ' + ui.item.code : '';

        $(this).val(ui.item.name + code + gender + age + phone_no + "");
        $('[name="user_id"]').val(ui.item.id);
        return false;
    }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
        var gender   = item.gender != null ? ', ' + item.gender : '';
        var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
        var code     = item.code != null ? ', ' + item.code : '';

        return $("<li>")
            .append("<a>" + item.name + code + gender + age + phone_no + "</a>")
            .appendTo(ul);
    };
});

</script>

