<form class="row g-3 auto-width" action="{{ route('e-way-bill-api-settings.update', $api->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <!--Base Url -->
    <div class="col-md-12">
        <label for="base_url" class="form-label">Base Url <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="base_url" name="base_url" aria-describedby="inputGroupPrepend" required placeholder="Base Url" value="{{$api->base_url}}">
        <span class="text-danger error_base_url" style="display: none;">This field is required.</span>
    </div>
    <!--Company -->
      <div class="col-md-6">
        <div>
            <label for="company_id" class="form-label">Company <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            
            <select class="single-select form-control" name="company_id">
                @foreach ($company as $list)
                <option value="{{ $list->id }}" {{ $list->id == $api->company_id ? 'selected' : '' }}>
                    {{ $list->name }}
                </option>
            @endforeach
            </select>
        </div>
        <span class="text-danger error_company_id" style="display: none;">This field is required.</span>
    </div>
    <!--Email -->
    <div class="col-md-6">
        <label for="email" class="form-label">Email <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="email" name="email" aria-describedby="inputGroupPrepend" required placeholder="Email" value="{{$api->email}}">
        <span class="text-danger error_email" style="display: none;">This field is required.</span>
    </div>
    <!--User Name -->
    <div class="col-md-6">
        <label for="user_name" class="form-label">User Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="user_name" name="user_name" aria-describedby="inputGroupPrepend" required placeholder="User Name" value="{{$api->user_name}}">
        <span class="text-danger error_user_name" style="display: none;">This field is required.</span>
    </div>
    <!--Password -->
    <div class="col-md-6">
        <label for="password" class="form-label">Password</label>
        <input type="password" class="form-control" id="password" name="password" aria-describedby="inputGroupPrepend" required placeholder="Password" value="{{$api->password}}">
        <span class="text-danger error_password" style="display: none;">This field is required.</span>
    </div> 
    <!--Client Secret -->
    <div class="col-md-6">
        <label for="client_secret" class="form-label">Client Secret</label>
        <input type="text" class="form-control" id="client_secret" name="client_secret" aria-describedby="inputGroupPrepend" required placeholder="Client Secret"  value="{{$api->client_secret}}">
        <span class="text-danger error_client_secret" style="display: none;">This field is required.</span>
    </div>
     <!--Client ID -->
    <div class="col-md-6">
        <label for="client_id" class="form-label">Client ID</label>
        <input type="text" class="form-control" id="client_id" name="client_id" aria-describedby="inputGroupPrepend" required placeholder="Client ID"  value="{{$api->client_id}}">
        <span class="text-danger error_client_id" style="display: none;">This field is required.</span>
    </div>
   <!-- Api Type-->
   <div class="col-md-6">
    <label for="api_type" class="form-label">API Type <span class="text-danger"><b>*</b></span></label>
    <select class="form-select" aria-label="api_type" name="api_type">
        <option value="Sandbox" {{ matchSelected($api->api_type,'Sandbox') }}>Sandbox</option>
        <option value="Live" {{ matchSelected($api->api_type,'Live') }}>Live</option>
    </select>
    <span class="text-danger error_api_type" style="display:none;">This field is required.</span>
    </div>
    <!--GSTIN -->
    <div class="col-md-6">
        <label for="gstin" class="form-label">GSTIN</label>
        <input type="text" class="form-control" id="gstin" name="gstin" aria-describedby="inputGroupPrepend" required placeholder="GSTIN"  value="{{$api->gstin}}">
        <span class="text-danger error_gstin" style="display: none;">This field is required.</span>
    </div>
</form>