 <div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th>Sl No</th>
                <th>Name</th>
                <th>Phone No</th>
                <th>Date</th>
                <th>Type</th>
                <th>Category</th>
                <th>Source</th>
                <th>Quality</th>
                <th class="thbutton">Status</th>
                <th class="thbutton">WA</th>
                @if(in_array('enquiry-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('enquiry-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>
                            <a href="{!! route('enquiries.show', $list->id) !!}">{{$list->name}}</a> <br> {{$list->organization}}</td>
                        <td>
                            {{$list->phone_no}}
                        </td>
                        <td>
                             @php $auth_format = \Session::get('company_data')['date_format'] ?? ''; @endphp

                            {{ date($auth_format, strtotime($list->enquiry_date)) }} <br>
                            @php
                                $enquiryDate = \Carbon\Carbon::createFromTimeStamp(strtotime($list->enquiry_date));
                                $now = \Carbon\Carbon::now();
                            @endphp

                            @if ($enquiryDate->isSameDay($now))
                                Today
                            @else
                                {{ $enquiryDate->diffInDays($now) }} days ago
                            @endif
                        </td>
                        <td>{{$list->enquiry_type_name}}</td>
                        <td>{{$list->category_name}}</td>
                        <td>{{$list->enquiry_source_name}}</td>
                        <td class="text-center"><span class="badge badge-pill" style="background: {!!$list->qualities_bg_color!!}; color: {!!$list->qualities_color!!}">{{$list->enquiry_quality_name}}</span></td>
                        <td class="text-center"><span class="badge badge-pill" style="background: {!!$list->bg_color!!}; color: {!!$list->color!!}">{{$list->enquiry_status_name}}</span></td>
                        <td class="text-center">
                            @if($list->whatsapp_no != '')
                            <a class="btn btn-success btn-sm" href="https://wa.me/{{$list->whatsapp_no}}?text=Hello%20{{$list->name}}!" target="_blank"><i class="bi bi-whatsapp text-white"></i></a>
                            @endif
                        </td>
                        @if(in_array('enquiry-edit', $authRolePermissions))
                        <td>
                            <a href="{{route('enquiries.edit',$list->id)}}" class="btn btn-outline-secondary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </a>
                        </td>
                        @endif
                        @if(in_array('enquiry-delete', $authRolePermissions))
                        <td>
                            <a data-url="{{route('enquiries.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="11">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('enquiries.pagination') !!}    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

