<form class="row g-3 auto-width" action="{{ route('enquiry-category-fields.update', $field->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-6">
        <label for="field" class="form-label">Field Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" name="field" aria-describedby="inputGroupPrepend" required value="{{$field->field}}">
        <span class="text-danger error_field" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="type">Field type <span class="text-danger"><b>*</b></span></label>
        <select name="type" class="form-control">
            <option value="text" {{ $field->type == 'text' ? 'selected' : '' }}>Text</option>
            <option value="textarea" {{ $field->type == 'textarea' ? 'selected' : '' }}>Text area</option>
            <option value="radio" {{ $field->type == 'radio' ? 'selected' : '' }}>Radio</option>
            <option value="checkbox" {{ $field->type == 'checkbox' ? 'selected' : '' }}>Checkbox</option>
            <option value="select" {{ $field->type == 'select' ? 'selected' : '' }}>Select dropdown</option>
            <option value="date" {{ $field->type == 'date' ? 'selected' : '' }}>Date</option>
            <option value="hidden" {{ $field->type == 'hidden' ? 'selected' : '' }}>Hidden</option>
        </select>
        <span class="text-danger error_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{{$field->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="length" class="form-label">Length <span class="text-danger"><b>*</b></label>
        <input type="number" class="form-control" name="length" value="{{$field->length}}" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_length" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="default_value" class="form-label">Default value</label>
        <input type="text" class="form-control" name="default_value" value="{{$field->default_value}}" aria-describedby="inputGroupPrepend" required>
    </div>
    <div class="col-md-12">
        <label for="select_options" class="form-label">Select options</label>
        <textarea name="select_options" class="form-control">{{ $field->select_options }}</textarea>
        <p> Note: (Please write comma seperated options if type is radio or select dropdown.)</p>
        <span class="text-danger error_select_options" style="display:none;">This field is required.</span>
    </div>
</form>