@foreach($fields as $field)
    @if($field->type != 'hidden')
    <div class="col-md-12">
        <label for="{!! $field->id !!}" class="form-label"><strong>{!! $field->field !!}</strong></label>
    @endif
        
        @if($field->type == 'text')
            <input type="text" class="form-control" maxlength="{!! $field->length != '' ? $field->length : '' !!}" name="{!! $field->id !!}" id="{{ $field->field }}" value="{!! $field->default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}/>
        @elseif($field->type == 'textarea')
            <textarea class="form-control" name="{!! $field->id !!}" id="{{ $field->field }}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} maxlength="{!! $field->length != '' ? $field->length : '' !!}" {!! $field->is_menditory == 1 ? 'required' : '' !!}>{!! $field->default_value !!}</textarea>
        @elseif($field->type == 'radio')
            <br>
            @php
                $options = [];
                $options = explode(',', $field->select_options);
            @endphp
            @foreach($options as $option)
                <input type="radio" id="{!! $field->id !!}_{{ $option }}" name="{!! $field->id !!}" value="{{ $option }}" {!! $field->default_value == $option ? 'selected checked' : '' !!} {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                <label for="{!! $field->id !!}_{{ $option }}">{{ $option }}</label>
                <br>
            @endforeach
        @elseif($field->type == 'checkbox')
            <input type="checkbox" class="checkbox_input" id="{{ $field->id }}" {!! $field->default_value == true || $field->default_value == 1 || $field->default_value == 'on' ? 'selected checked' : '' !!} {!! $field->is_readonly == 1 ? 'readonly' : '' !!}/>
            <input type="hidden" name="{!! $field->id !!}" class="checkbox_value" value="{!! $field->default_value == true || $field->default_value == 1 || $field->default_value == 'on' ? '1' : '0' !!}">
        @elseif($field->type == 'select')
            @php
                $options = [];
                $options = explode(',', $field->select_options);
            @endphp
            <select class="form-control" name="{!! $field->id !!}" id="{{ $field->field }}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                <option value="">Select</option>
                @foreach($options as $option)
                    <option value="{{ $option }}" {!! $field->default_value == $option ? 'selected' : '' !!}>{{ $option }}</option>
                @endforeach
            </select>
        @elseif($field->type == 'hidden')
            <input type="hidden" name="{!! $field->id !!}" value="{!! $field->default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!}>
        @elseif($field->type == 'date')
            <input type="date" class="form-control" name="{!! $field->id !!}" id="{{ $field->field }}" value="{!! $field->default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
        @endif

    @if($field->type != 'hidden')
    </div>
    @endif
@endforeach