@extends('layouts.app')
@section('title','Category Fields')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

   <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Enquiry Category Field
      </div>
      <div class="col-md-6">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb justify-content-md-end mb-0">
            <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="31" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
            <li class="breadcrumb-item" aria-current="page">Enquiry</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Enquiry Categories</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Enquiry Category Field</li>
          </ol>
        </nav>
      </div>
    </div>
    <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
      <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row gx-2">
          <div class="col-lg-3 col-md-3 col-8">
              <div class="position-relative">
                  <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                  <input class="form-control ps-5" type="search" id="search" placeholder="Search">
              </div>
          </div>

          <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
          </div>

          <div class="col-lg-7 col-md-7">
            <div class="ms-auto float-md-end">

              <div class="btn-group">
                  <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
              </div>

              <div class="btn-group">
                @if(in_array('enquiry-category-fields-create', $authRolePermissions))
                  <div class="btn-group">
                   <button type="button" class="btn btn-primary" id="create"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New Fields</button>
                  </div>
                @endif
              </div>

            </div>
          </div>
        </div>
      </div>

    <div class="card-body" id="tables">

      @include('enquiry-category-fields.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>

  <script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }

    $(document).ready(function(){
      function clear_icon(){
        $('#id_icon').html('');
        $('#post_title_icon').html('');
      }

      function fetch_data(page, sort_type, sort_by, query){
        $.ajax({
          url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&id={!! $id !!}",
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

      $(document).on('click', '#create', function(){
        $('#commonModalLabel').text('Add New field for Category {!! $category->category_name !!}');
        $('.save_button_span').text('Save Category field');

        $.ajax({
          url:"{!! route('enquiry-category-fields.create', $id) !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        })
      })

      $(document).on('click', '.edit', function(){
        $('#commonModalLabel').text('Edit Category field');
        $('.save_button_span').text('Update Category field');
        var id = $(this).data('id');
        var url = `{!! route('enquiry-category-fields.edit', ':id') !!}`.replace(':id', id);

        $.ajax({
          url:url,
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        })
      })

      $(document).on('click', '.save_button', function(event){
        event.preventDefault();
        $('.error_type').hide();
        $('.error_field').hide();
        $('.error_length').hide();
        $('.error_priority').hide();
        $('.error_is_readonly').hide();
        $('.error_default_data').hide();
        $('.error_select_options').hide();
        var error          = 0;
        var field          = $('#commonModal').find('form').find('input[name="field"]').val().trim();
        var type           = $('#commonModal').find('form').find('select[name="type"]').find(":selected").val();
        var select_options = $('#commonModal').find('form').find('[name="select_options"]').val();
        var length       = $('#commonModal').find('form').find('input[name="length"]').val();
        var priority     = $('#commonModal').find('form').find('input[name="priority"]').val();
        var default_data = $('#commonModal').find('form').find('input[name="default_data"]').val();
        var is_readonly  = $('#commonModal').find('form').find('select[name="is_readonly"]').find(":selected").val();

        if (field == '') {
          $('.error_field').show();
          error = 1;
        }
        if (type == '') {
          $('.error_type').show();
          error = 1;
        }
        if (select_options == '' && (type == 'radio' || type == 'select')) {
          $('.error_select_options').show();
          error = 1;
        }
        if (length == '') {
          $('.error_length').show();
          error = 1;
        }
        if (priority == '') {
          $('.error_priority').show();
          error = 1;
        }
        if (default_data == '') {
          $('.error_default_data').show();
          error = 1;
        }
        if (is_readonly == '' && (is_readonly == 'Yes' || is_readonly == 'No')) {
          $('.error_is_readonly').show();
          error = 1;
        }
        if (error == 0) {
          $('#commonModal').find('form').submit();
        }
        error = 1;
      })

       /******** searching ********/
        $(document).on('keyup', '#search', delay(function() {
            var query = $('#search').val();

            if (query.length < 2 && query.length != 0) {
                return;
            }

            var column_name = $('.sorting').val();
            var sort_type   = $('#hidden_sort_type').val();
            var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
            fetch_data(page, sort_type, column_name, query);
        }, 700));


      $('body').on('change', '.sorting', function(){
        var column_name   = $(this).val();
        var order_type    = $(this).data('sorting_type');
        var reverse_order = '';
        var page          = 1?1:(this).attr('href').split('page=')[1];
        var query         = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
      });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page        = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type   = $('#hidden_sort_type').val();
        var query       = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');
        fetch_data(page, sort_type, column_name, query);
      });
    });
  </script>
@endsection
