@extends('layouts.app')
@section('title','Students Import')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .card {
        margin-bottom: 0rem;
    }
    .form-control {
        height: 33px !important;
    }
</style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Students Import </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb justify-content-md-end mb-0">
                <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="75" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                <li class="breadcrumb-item" aria-current="page">Students</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Students</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Upload Excel</li>
              </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">

            @include('layouts.partials.nav-menu')

            <div class="row gx-2">

                <div class="col-lg-12 col-md-12">
                    <div class="ms-auto float-md-end">

                        <div class="btn-group">
                            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>

                        <div class="btn-group">
                            <a href="{!! asset('sample.xlsx') !!}" download class="btn btn-success"><i class="bi bi-download"></i> Download Excel Format</a>
                        </div>
                    </div>
              </div>
            </div>

        </div>

        <input type="hidden" name="hidden_page" id="hidden_page" value="1"/>
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name"/>
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc"/>
    </div>
    <!-- end main -->

    <div class="row auto">
        <div class="col-xl-12 mx-auto">
            <div class=" shadow-none radius-5 min-height">
                <div class="">
                    <div class="">
                        <form class="row g-3 auto-width form" action="{{ route('students.import-store') }}" enctype="multipart/form-data" method="POST">
                            @csrf
                            @method('post')
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                        <h5 class="mb-0">Upload Students From Excel</h5>
                                        <hr class="mb-0">

                                        <div class="col-md-12">
										    <label for="users">Upload Excel File
										    	<span class="text-danger"><b>*</b></span>
										    </label>

										    <input type="file" class="form-control import_package" name="file"/>
										    </div>
										    <span class="text-danger error_import_package" style="display:none;">This field is required.</span>
										</div>

                                        <div class="col-12 d-flex justify-content-center mb-3">
                                            <button type="submit" name="submit" style="width: 50%;" class="btn btn-primary import_button"><i class="bi bi-upload "></i> Upload Students
                                            </button>
                                        </div>

                                        <div class="col-12 justify-content-center mb-3">
                                            <div style="" class="accordion-item">
                                                <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                                    Guidelines For Students Upload:
                                                  </button>
                                                </h2>
                                                <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                                                  <div class="accordion-body">
                                                    <div class="col-md-12">
                                                      1. Your CSV data should be in the format below. The first line of your CSV file should be the column headers as in the table example. Also make sure that your file is UTF-8 to avoid unnecessary encoding problems.<br>
                                                      2. If the column you are trying to import is date make sure that is formatted in format Y-m-d (2018-06-06).<br>
                                                      3. Duplicate Admission Number (unique) rows will not be imported.<br>
                                                      4. For student Gender use Male, Female value.<br>
                                                      5. For student Blood Group use O+, A+, B+, AB+, O-, A-, B-, AB- value.<br>
                                                      <!-- 6. For RTE use Yes, No value.<br> -->
                                                    <!-- 7. For If Guardian Is user father,mother,other value.<br> -->
                                                    6. Category name comes from other table so for category, enter Category Id (Category Id can be found on category page ).<br>
                                                    7. Student house comes from other table so for student house, enter Student House Id (Student House Id can be found on student house page ).
                                                    <div class="table-responsive">
                                                      <table class="table">
                                                        <thead>
                                                          <tr>
                                                            <th>Admission No</th>
                                                            <th>Name</th>
                                                            <th>Gender</th>
                                                            <th>Marital Status</th>
                                                            <th>Date Of Birth</th>
                                                            <th>Category</th>
                                                            <th>Phone No.</th>
                                                            <th>Email</th>
                                                            <th>Blood Group</th>
                                                            <th>Address</th>
                                                            <th>House</th>
                                                            <!-- <th>Height</th> -->
                                                            <!-- <th>Weight</th> -->
                                                            <!-- <th>Measurement Date  </th> -->
                                                            <!-- <th>Father Name</th> -->
                                                            <!-- <th>Father Phone</th> -->
                                                            <!-- <th>Father Occupation</th> -->
                                                            <!-- <th>Mother Name</th> -->
                                                            <!-- <th>Mother Phone</th> -->
                                                            <!-- <th>Mother Occupation</th> -->
                                                            <!-- <th>If Guardian Is</th> -->
                                                            <!-- <th>Guardian Name</th>
                                                            <th>Guardian Relation</th>
                                                            <th>Guardian Email</th>
                                                            <th>Guardian Phone</th>
                                                            <th>Guardian Occupation</th>
                                                            <th>Guardian Address</th> -->
                                                            <!-- <th>Permanent Address</th> -->
                                                            <!-- <th>Bank Account No</th>
                                                            <th>Bank Name</th>
                                                            <th>IFSC Code</th>
                                                            <th>National Identification No</th>
                                                            <th>Local Identification No </th>
                                                            <th>RTE</th>
                                                            <th>Previous School Details</th>
                                                            <th>Note</th> -->
                                                          </tr>
                                                        </thead>
                                                      </table>
                                                    </div>
                                                  <hr>
                                                  </div>
                                                  </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>

/*$(document).on('change', '.import_package', function(){

	var ext = this.value.match(/\.(.+)$/)[1];

    if(ext != 'xls' && ext != 'xlsx'){
        toastr.error('File must be type of xls & xlsx.');
        this.value = '';
    }
    
	const size = (this.files[0]).size;
         
    if (size > 5e+6) {
        toastr.error('File must be less than 5 MB');
        this.value = '';
    }

	var formData = new FormData($('.form')[0]);

    $('#commonModalLabel').text('Excel File Preview');
    $('.save_button_span').text('Close');
    $('.bx-save').switchClass('bx bx-save', 'bi bi-x-lg');
    $('.save_button').attr('data-bs-dismiss','modal');
    $('.modal-dialog').css('max-width', '1000px')
    $.ajax({
        url:"{!! route('test-packages.import-preview') !!}",
        type:'POST',
       	data: formData,
       	contentType: false,
      	processData: false,
        success:function(data){
            if (data.success === false){
                $('.import_package').val('');
                toastr.error(data.message);
            } else {
                $('#commonModal').modal('show');
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        }
    });
});*/

/*$(document).on('click', '.import_button', function(event){
	$('.error_import_package').hide();
	var error = 0;

	if ($('input[name="packages"]').val() == '') {
		$('.error_import_package').show();
		error = 1;
	}

	if (error == 0) {
		$('.form').submit();
	}

	error = 1;
});*/

</script>
@endsection