<form class="row g-3 auto-width edit_file" action="{{ route('file-manager.update', $file->id) }}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label for="name" class="form-label">Title <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required placeholder="Title" value="{!! $file->name !!}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="file" class="form-label">File <span class="text-danger"><b>*</b></span></label>
        <input type="file" class="form-control" id="file" name="file" aria-describedby="inputGroupPrepend" required placeholder="Title">
        <span class="text-danger error_file" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="details" class="form-label">Details</label>
        <textarea class="form-textarea" name="details" placeholder="Details">{!! $file->details !!}</textarea>
        <span class="text-danger error_details" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="file_type_id" class="form-label">File Type</label>
        <select class="form-select" name="file_type_id">
            <option value="">Select</option>
            @foreach(fileTypes() as $key => $value)
                <option value="{!! $key !!}" {!! $file->file_type_id == $key ? 'selected' : '' !!}>{!! ucfirst($value) !!}</option>
            @endforeach
        </select>
        <span class="text-danger error_file_type_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="category_id" class="form-label">Category</label>
        <select class="form-select" name="category_id">
            <option value="">Select</option>
            @foreach(fileCategories() as $key => $value)
                <option value="{!! $key !!}" {!! $file->category_id == $key ? 'selected' : '' !!}>{!! ucfirst($value) !!}</option>
            @endforeach
        </select>
        <span class="text-danger error_category_id" style="display:none;">This field is required.</span>
    </div>
</form>
