<style>
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
</style>
<form class="row g-3 auto-width" method="post" action="{{ route('findings.store') }}">
    @csrf
    @method('post')
    <div class="col-md-12">
        <label for="symptoms_title" class="form-label">Name<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control name" name="name" aria-describedby="inputGroupPrepend" placeholder="name">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="category" class="form-label">Category<span class="text-danger"><b>*</b></span></label>
        <div class="input-group mb-3">
            <select style="width: 50%" class="form-control category" name="finding_category_id">
                @foreach($finding_categories as $finding_category)
                    <option value="{{ $finding_category->id }}">{{ $finding_category->category }}</option>
                @endforeach
            </select>

            @if(auth()->user()->can('finding-categories-create'))
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_finding_category" type="button"> + </button>
            </div>
            @endif
        </div>
        <span class="text-danger error_category" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="priority" class="form-label">Priority<span class="text-danger"><b>*</b></span></label>
        <input type="number" value="{{ $priority }}" class="form-control" name="priority" disabled aria-describedby="inputGroupPrepend">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" name="description" placeholder="Description"></textarea>
    </div>
</form>