<form class="row g-3 auto-width" method="post" action="{{ route('findings.update', $data->id) }}">
    @csrf
    @method('put')
    <div class="col-md-12">
        <label for="symptoms_title" class="form-label">Name<span class="text-danger"><b>*</b></span></label>
        <input type="text" value="{{ $data->name }}" class="form-control name" name="name" aria-describedby="inputGroupPrepend" placeholder="name">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="type" class="form-label">Category<span class="text-danger"><b>*</b></span></label>
        <select class="form-control category" name="finding_category_id">
            @foreach($finding_categories as $finding_category)
                <option {{ ($data->finding_category_id == $finding_category->id) ? 'selected' : '' }} value="{{ $finding_category->id }}">{{ $finding_category->category }}</option>
            @endforeach
        </select>
        <span class="text-danger error_category" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="priority" class="form-label">Priority<span class="text-danger"><b>*</b></span></label>
        <input type="number" value="{{ $data->priority }}" class="form-control" name="priority" aria-describedby="inputGroupPrepend">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" name="description" placeholder="Description">{{ $data->description }}</textarea>
    </div>
</form>