@extends('layouts.app')
@section('title','Incentive/Discount Setting')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .customCheck .ui-switcher {
      width: 63px;
    }
    .customCheck .ui-switcher[aria-checked=true]:after {
      background-color: #ffffff;
      content: '\0020';
      display: inline-block;
      position: absolute;
      top: 4px;
      height: 18px;
      /* width: 16px; */
      border-radius: 50%;
      transition: left 0.25s;
      left: 45px !important;
  }
  .customCheck .ui-switcher[aria-checked=false]:before {
      color: #da2a2a90;
      content: 'Patient';
      right: 19px;
      font-size: 12px;
      font-weight: 700;
  }
  .customCheck .ui-switcher[aria-checked=true]:before {
      color: #12bf2490;
      content: 'Self';
      left: 7px;
      font-size: 12px;
      font-weight: 700;
  }
    /* .ui-switcher::after {
    content: "self";
  } */
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Incentive/Discount Setting
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="26" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Settings</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Incentive/Discount Setting</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')
    <div class="row gx-2">
      <div class="col-lg-3 col-md-3 col-8">
          <div class="position-relative">
              <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
              <input class="form-control ps-5" type="search" id="search" placeholder="Search">
          </div>
      </div>

      <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
        <i class="bi bi-funnel"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
      </div>

      <div class="col-lg-7 col-md-7">
        <div class="ms-auto float-md-end">

          <!-- <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div> -->


          <div class="btn-group">
            @if(in_array('incentive-setting-create', $authRolePermissions))
              <button type="button" class="btn btn-primary" id="create" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
              @endif
          </div>
        </div>
      </div>
    </div>
  </div>

    <div class="card-body" id="tables">

      @include('incentive-settings.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
    @endsection
    @section('js')
    <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
  <script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }

    $(document).ready(function(){
      function clear_icon(){
        $('#id_icon').html('');
        $('#post_title_icon').html('');
      }

      function fetch_data(page, sort_type, sort_by, query){
        $.ajax({
          url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query,
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

      $(document).on('click', '#create_insentive_slab', function() {
        $('#commonModalLabel').text('Add New Incentive Slab');
        $('.save_button_span').text('Save Incentive Slab');
        $.ajax({
            url: "{!! route('incentive-slabs.create') !!}",
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        })
    })

      $(document).on('click', '#create', function(){
        $('#commonModalLabel').text('Add New Incentive Setting');
        $('.save_button_span').text('Save Incentive Setting');
        $.ajax({
          url:"{!! route('incentive-settings.create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            //autocomplete ajax
            $('.account-select').autocomplete({
              autoFocus: false,
              minLength: 0,
              source: function(request, response) {
                  if (request.term.length < 2) {
                      $('[name="account_id"]').val('');
                      return false;
                  }

                  $.ajax({
                    url: '{{ route("incentive-settings.searchAccount") }}',
                      type: 'POST',
                      dataType: 'json',
                      data: {
                          search_text: request.term
                      },
                      success: function(json) {
                          if (json.error) {
                              $('[name="account_id"]').val('');
                              return false;
                          }
                          response($.map(json.result,
                              function(item) {
                                  return {
                                      id: item.id,
                                      name: item.name,
                                  };
                              }));
                      }
                  });
              },
              select: function(event, ui) {
                  event.preventDefault();
                  $(this).val(ui.item.name);
                  $('[name="account_id"]').val(ui.item.id);
                  return false;
              }
          }).data("ui-autocomplete")._renderItem = function(ul, item) {
              return $("<li>").append("<a>" + item.name + "</a>").appendTo(ul);
          };


          function formatDate(date) {
                    const options = { day: 'numeric', month: 'numeric', year: 'numeric' };
                    return new Date(date).toLocaleDateString(undefined, options);
                }

            var currentDate = new Date().toISOString().split('T')[0];
            $('#date_upto').datepicker().val(formatDate(currentDate));

          }
        })
      })

      $(document).on('click', '.edit', function(){
        $('#commonModalLabel').text('Edit Incentive Setting');
        $('.save_button_span').text('Update Incentive Setting');
        var id = $(this).data('id');
        var url = `{!! route('incentive-settings.edit', ':id') !!}`.replace(':id', id);

        $.ajax({
          url:url,
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);

            $('#date_upto').datepicker({
            format: 'dd/mm/yy'
          })
          function formatDate(date) {
                    const options = { day: 'numeric', month: 'numeric', year: 'numeric' };
                    return new Date(date).toLocaleDateString(undefined, options);
                }

                var currentDate = new Date().toISOString().split('T')[0];
                $('#date_upto').datepicker().val(formatDate(currentDate));
          }
        })
      })


        $(document).on('click', '.save_button', function(event) {
            event.preventDefault();
            var error = 0;

            if ($('#commonModal').find('form').hasClass('insentive_slab')) {
                $('.error_slab_name').hide();
                $('.error_company_id').hide();
                $('.error_account_type_id').hide();
                if ($('#commonModal').find('form').find('input[name="slab_name"]').val().trim() == '') {
                    $('.error_slab_name').show();
                    error = 1;
                    setTimeout(function () {
                        $('.error_slab_name').hide();
                        }, 3000);
                    }
                    if ($('#commonModal').find('form').find('[name="calculation_type"]').val() == '') {
                        $('.error_calculation_type').show();
                            error = 1;
                            setTimeout(function () {
                            $('.error_calculation_type').hide();
                            }, 3000);

                    }
                    if ($('select[name="account_type_id"]').val() == null || $('select[name="account_type_id"]').val() == '') {
                        $('.error_account_type_id').show();
                        error = 1;
                        setTimeout(function () {
                            $('.error_account_type_id').hide();
                            }, 3000);

                    }

                    if (error == 0) {
                        let formdata = new FormData($('#commonModal').find('form')[0]);
                        $.ajax({
                                url: $('#commonModal').find('form').attr('action'),
                                data: formdata,
                                processData: false,
                                contentType: false,
                                type: 'POST',
                                success: function(response) {
                                    if (response.success === true) {
                                        toastr.success(response.message, 'Success.');

                                        // hide modal
                                        $('#commonModal').modal('hide');
                                        $('#commonModal').find('.modal-body').html('');
                                        setTimeout(function() {
                                            $('#create').trigger('click');
                                        }, 1000);
                                    } else {
                                        toastr.error(response.message, 'Error!');
                                    }
                                }
                            })
                            .fail(function(jqXHR, textStatus, errorThrown) {
                                console.log('AJAX request failed:', textStatus, errorThrown);
                                toastr.error('An error occurred during the request.', 'Error!');

                                // hide modal
                                $('#commonModal').modal('hide');
                                $('#commonModal').find('.modal-body').html('');
                            });
                    }
            }
            else
            {
                $('.error_received_by').hide();
                $('.error_slab_id').hide();
                $('.error_account_id').hide();
                    if ($('select[name="slab_id"]').val() == null || $('select[name="slab_id"]').val() == '') {
                    $('.error_slab_id').show();
                    error = 1;
                    setTimeout(function () {
                    $('.error_slab_id').hide();
                    }, 3000);

                    }
                    if ($('input[name="account_id"]').val() == null || $('input[name="account_id"]').val() == '') {
                    $('.error_account_id').show();
                    error = 1;
                    setTimeout(function () {
                    $('.error_account_id').hide();
                    }, 3000);

                }
                if (error == 0) {
                    let formdata = new FormData($('#commonModal').find('form')[0]);

                    $.ajax({
                            url: $('#commonModal').find('form').attr('action'),
                            data: formdata,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            success: function(response) {
                                if (response.success === true) {
                                    toastr.success(response.message, 'Success.');

                                    // hide modal
                                    $('#commonModal').modal('hide');
                                    $('#commonModal').find('.modal-body').html('');
                                        var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val()?$('.sorting').val():'';
                                        var sort_type   = $('#hidden_sort_type').val();
                                        var query       = $('#search').val()?$('#search').val():'';

                                        fetch_data(page, sort_type, column_name, query);
                                } else {
                                    toastr.error(response.message, 'Error!');
                                }
                            }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');

                        // hide modal
                        $('#commonModal').modal('hide');
                        $('#commonModal').find('.modal-body').html('');
                    });
                }
            }
        })


       /******** searching ********/
        $(document).on('keyup', '#search', delay(function() {
            var query = $('#search').val();

            if (query.length < 2 && query.length != 0) {
                return;
            }

            var column_name = $('.sorting').val();
            var sort_type   = $('#hidden_sort_type').val();
            var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
            fetch_data(page, sort_type, column_name, query);
        }, 700));


      $('body').on('change', '.sorting', function(){
        var column_name   = $(this).val();
        var order_type    = $(this).data('sorting_type');
        var reverse_order = '';
        var page          = 1?1:(this).attr('href').split('page=')[1];
        var query         = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
      });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page        = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type   = $('#hidden_sort_type').val();
        var query       = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');
        fetch_data(page, sort_type, column_name, query);
      });

      /*********change status**********/
      $("body").on("click",'.changeStatusCustom', function(event){
          dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
          var UrlValue     = $(this).data('url');
          var status       = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to change status?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              if (result.isConfirmed) {
                  $.ajax({
                      url     : UrlValue,
                      method  : 'post',
                      data    :dataString,
                      headers:
                      {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      beforeSend: function( xhr ) {
                          // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                      },
                      success : function(response){
                          if(response.success){
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              $(this).Toastshow('success',ErroMsg);

                              var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                              var column_name = $('.sorting').val()?$('.sorting').val():'';
                              var sort_type   = $('#hidden_sort_type').val();
                              var query       = $('#search').val()?$('#search').val():'';

                              fetch_data(page, sort_type, column_name, query);
                          } else {
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              if (ErroMsg === '') {
                                  ErroMsg = "Something went wrong!";
                              }
                              $(this).Toastshow('error',ErroMsg);

                              if (status == 1) {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                              } else {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                              }
                          }
                      },
                      error: function (data) {
                          console.log("error ",data);

                          if (status == 1) {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                          } else {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                          }
                      }
                  });
              }
              else if (result.isDenied) {
                var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                var column_name = $('.sorting').val()?$('.sorting').val():'';
                var sort_type   = $('#hidden_sort_type').val();
                var query       = $('#search').val()?$('#search').val():'';

                fetch_data(page, sort_type, column_name, query);
              }
              //return false;
          });
      //return false;
      });
      /*********change RecievedByCustom status**********/
      $("body").on("click",'.changeRecievedByCustom', function(event){
          dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
          var UrlValue     = $(this).data('url');
          var status       = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to change Recieved By status?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              if (result.isConfirmed) {
                  $.ajax({
                      url     : UrlValue,
                      method  : 'post',
                      data    :dataString,
                      headers:
                      {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      beforeSend: function( xhr ) {
                          // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                      },
                      success : function(response){
                          if(response.success){
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              $(this).Toastshow('success',ErroMsg);

                              var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                              var column_name = $('.sorting').val()?$('.sorting').val():'';
                              var sort_type   = $('#hidden_sort_type').val();
                              var query       = $('#search').val()?$('#search').val():'';

                              fetch_data(page, sort_type, column_name, query);
                          } else {
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              if (ErroMsg === '') {
                                  ErroMsg = "Something went wrong!";
                              }
                              $(this).Toastshow('error',ErroMsg);

                              if (status == 1) {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                              } else {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                              }
                          }
                      },
                      error: function (data) {
                          console.log("error ",data);

                          if (status == 1) {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                          } else {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                          }
                      }
                  });
              }
              else if (result.isDenied) {
                var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                var column_name = $('.sorting').val()?$('.sorting').val():'';
                var sort_type   = $('#hidden_sort_type').val();
                var query       = $('#search').val()?$('#search').val():'';

                fetch_data(page, sort_type, column_name, query);
              }
              //return false;
          });
      //return false;
      });

      /*********delete data**********/
      $("body").on("click",'.deleteDataCustom', function(event){
          dataString    = {"id":$(this).data('id')};
          var UrlValue  = $(this).data('url');
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to delete this?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              /* Read more about isConfirmed, isDenied below */
              if (result.isConfirmed) {
                  $.ajax({
                  url     : UrlValue,
                  method  : 'post',
                  data    :{
                    "_token": $('meta[name="csrf-token"]').attr('content'),
                    "id": $(this).data('id')
                  },
                  headers:
                  {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  beforeSend: function( xhr ) {
                      // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                  },
                  success : function(response){
                      if(response.success){
                          var ErroMsg = $(this).printErrorMsg(response.message);

                          $(this).Toastshow('success',ErroMsg);

                          var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val()?$('.sorting').val():'';
                          var sort_type   = $('#hidden_sort_type').val();
                          var query       = $('#search').val()?$('#search').val():'';

                          fetch_data(page, sort_type, column_name, query);
                      }else{
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error',ErroMsg);
                      }
                  },
                  error: function (data) {
                    console.log("error ",data);
                  }
              });
              }
          });
      });
    });
  </script>
@endsection
