<form class="row g-3 auto-width" action="{{ route('incentive-slab-details.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
    {{-- Slab --}}
    <div class="col-md-6">
        <div>
            <label for="slab_id" class="form-label">Slab <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="slab_id">
                @foreach ($slab as $list)
                    <option value="{{ $list->id }}">{{ $list->slab_name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_slab_id" style="display: none;">This field is required.</span>
    </div>
    {{-- Calculation Type --}}
    <div class="col-md-6">
        <label for="calculation_type" class="form-label">Calculation Type </label>
        <select class="form-select" aria-label="calculation_type" name="calculation_type" id="calculation_type">
            <option selected value="">Select Calculation Type</option>
            <option value="percentage">PERCENTAGE</option>
            <option value="quantity">QUANTITY</option>
        </select>
        <span class="text-danger error_calculation_type" style="display:none;">This field is required.</span>
    </div>
    {{-- Product --}}
    <div class="col-md-6">
        <div>
            <label for="product_id" class="form-label">Product <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="product_id">
                @foreach ($product as $list)
                    <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_product_id" style="display: none;">This field is required.</span>
    </div>
    {{-- Percentage --}}
    <div class="col-md-6" id="percentage_field" style="display: none;">
        <label for="percentage" class="form-label">Percentage %</label>
        <input type="number" class="form-control" id="percentage" name="percentage" aria-describedby="inputGroupPrepend" required>
    </div>
    {{-- Price --}}
    <div class="col-md-6" id="price_field" style="display: none;">
        <label for="price" class="form-label">Price</label>
        <input type="number" class="form-control" id="price" name="price" aria-describedby="inputGroupPrepend" required>
    </div>
</form>

<script>
    document.getElementById('calculation_type').addEventListener('change', function () {
        var selectedOption = this.value;
        if (selectedOption === 'percentage') {
            document.getElementById('percentage_field').style.display = 'block';
            document.getElementById('price_field').style.display = 'none';
        } else if (selectedOption === 'quantity') {
            document.getElementById('percentage_field').style.display = 'none';
            document.getElementById('price_field').style.display = 'block';
        } else {
            document.getElementById('percentage_field').style.display = 'none';
            document.getElementById('price_field').style.display = 'none';
        }
    });
</script>
