@extends('layouts.app')
@section('title', 'Incentive Slab Details')
@section('pages')
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }

        .card {
            margin-bottom: 0rem;
        }

        .form-control {
            height: 33px !important;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Incentive Slab Details </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="79" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item" aria-current="page">Incentive Slab Details</li>
                    <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Incentive Slab Details
                    </li>
                    {{-- <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Upload Excel</li> --}}
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">
                <div class="col-lg-6 col-md-6"> <!-- Adjust the column widths as needed -->
                    <h5 class="mb-0">Upload Incentive Slab Details <small>Excel File</small></h5>
                </div>
                <div class="col-lg-6 col-md-6 text-end"> <!-- Adjust the column widths as needed -->
                    <div class="btn-group">
                        <a href="{{route('incentive-slab-details.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        <button type="button" class="btn btn-success" id="download_file" data-bs-toggle="modal" data-bs-target="#commonModal">Download File</button>
                    </div>
                </div>
            </div>
        </div>

        <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
    <!-- end main -->

    <div class="row auto">
        <div class="col-xl-12 mx-auto">
            <div class=" shadow-none radius-5 min-height">
                <div class="">
                    <div class="">
                        <form class="row g-3 auto-width form" action="{{ route('incentive-slab-details-import') }}" enctype="multipart/form-data" method="POST">
                            @csrf
                            @method('post')

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body g-3 row">
                                      
                                        <hr class="mb-0">
                                        <div class="col-md-3"></div>
                                        
                                        <div class="col-md-6">
                                            <label for="incentive_slab">Select Incentive Slab <span class="text-danger"><b>*</b></span>
                                            </label>
                                            <select class="single-select form-control" name="incentive_slab">
                                                <option selected value="">Select Incentive Slab</option>
                                                @foreach ($incentive_slab as $list)
                                                    <option value="{{ $list->id }}" {!! !empty($id) && $id == $list->id ? 'selected' : '' !!}>{{ $list->slab_name }}</option>
                                                @endforeach
                                            </select>                                           
                                            <span class="text-danger error_incentive_slab" style="display: none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-3"></div>
                                        <div class="col-md-3"></div>
                                        <div class="col-md-6">
                                            <label for="users">Upload Excel File <span class="text-danger"><b>*</b></span>
                                            </label>
                                            <input type="file" class="form-control import_excel" name="incentive_slab_details" />
                                            <span class="text-danger error_import_excel" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-3"></div>
                                    </div>
                                    <div class="col-12 d-flex justify-content-center mb-3" >
                                        <a style="width: 20%;" class="btn btn-secondary import_button"> <i class="bi bi-upload "></i> Upload Incentive Settings </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection

@section('js')

    <script>
        $(document).ready(function() {
            $(document).on('click', '#download_file', function() {
                $('#commonModalLabel').text('Select Types For Download ');
                $('.save_button_span').text('Download ');
                $.ajax({
                    url: "{!! route('incentive-slab-details-export-view') !!}",
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);
                    }
                })
            })
            $(document).on('click', '.save_button', function(event) {
                event.preventDefault();
                $('.error_product_group').hide();
                $('.error_product_brand').hide();
                $('.error_product_category').hide();
                var error = 0;
                if (error == 0) {
                    let formdata = new FormData($('#commonModal').find('form')[0]);
                    $('#incentive_slab_details').submit();
                }
                error = 1;
            })
        });
        $(document).on('click', '.import_button', function(event) {
            $('.error_import_package').hide();
            $('.error_incentive_slab').hide();
            var error = 0;
            if ($('select[name="incentive_slab"]').val() == null || $('select[name="incentive_slab"]').val() == '') {
            $('.error_incentive_slab').show();
            error = 1;
            }
            if ($('.import_excel').val() == '') {
                $('.error_import_excel').show();
                error = 1;
            }

            if (error == 0) {
                $('.form').submit();
            }
            error = 1;
        });
    </script>
@endsection
