<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Serial No</th>
                <th>Slab</th>
                <th>Product</th>
                <th>Product Price</th>
                <th>Cal.Type</th>
                <th>Percentage %</th>
                <th>Rate / Value</th>
                <th>Other Charges</th>
                <th class="thbutton">Status</th>
                @if(in_array('incentive-slab-details-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('incentive-slab-details-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td>{{$data->firstItem() + $key}}</td>
                        <td>{{ ucfirst($list->getSlab->slab_name ?? '') }} </td>
                        <td>{{$list->getProduct->name}}</td>
                        <td>{{$list->getProduct->getProductPrice->sale_price ?? ''}}</td>
                        <td>{{ ucfirst($list->calculation_type) }}</td>
                        <td>{{ ucfirst($list->percentage) }}</td>
                        <td>{{ ucfirst($list->price) }}</td>
                        <td>{{ $list->other_charges }}</td>
                        <td>
                            <div class="form-check form-check-inline{{ $i }}">
                                <input class="form-check-input{{ $i }} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{ $i }}" data-url="{{ route('incentive-slab-details.changestatus') }}" data-id="{{ $list->id }}" data-status="{{ $list->status == '0' ? '1' : '0' }}" {{ $list->status == '1' ? 'checked' : '' }}>
                            </div>
                        </td>
                        @if(in_array('incentive-slab-details-edit', $authRolePermissions))
                        <td>
                            <button data-id="{{ $list->id }}" class="btn btn-warning edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('incentive-slab-details-delete', $authRolePermissions))
                        <td>
                            <a data-url="{{route('incentive-slab-details.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="5">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="row align-items-center mt-2">
    <div class="col-md-6">
        {!! $data->onEachSide(0)->render('incentive-slab-details.pagination') !!}
    </div>

    <div class="col-md-2"></div>

    <div  class="col-md-4 d-flex justify-content-right" style="justify-content: flex-end;">
        {{-- @if(in_array('accounts-import', $authRolePermissions)) --}}
        <a class="btn btn-outline-primary" href="{!! route('incentive-slab-details-export-create') !!}"><i class="bi bi-cloud-download"></i>Import/Export</a>
        {{-- @endif --}}

    </div>
</nav>
</div>

