@extends('layouts.app')
@section('title', 'Incentive/Discount Slab Details')
@section('pages')
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> {!! $slab->slab_name !!} | {!! $slab->getType->type_name ?? '' !!}
        </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="26"
                            data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item" aria-current="page">Incentive/Discount Slab</li>
                    <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Incentive/Discount Slab
                        Details</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <div class="card style_table shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">

                <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length">
                    <i class="bi bi-funnel"></i>
                    <select class="form-select group_id" id="group_id" name="example_length" aria-controls="example">
                        <option value=""> - Select Group - </option>
                        @foreach ($group as $value)
                            <option value="{!! $value->id !!}">{!! $value->name !!}</option>
                        @endforeach
                    </select>
                </div>
        <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select brand_id" id="brand_id" name="example_length" aria-controls="example">
                <option value=""> - Select Brand - </option>
                @foreach ($brand as $value)
                    <option value="{!! $value->id !!}">{!! $value->name !!}</option>
                @endforeach
            </select>
        </div>
        <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select category_id" id="category_id" name="example_length" aria-controls="example">
                <option value=""> - Select Category - </option>
                @foreach ($category as $value)
                    <option value="{!! $value->id !!}">{!! $value->name !!}</option>
                @endforeach
            </select>
        </div>
        <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select division_id" id="division_id" name="example_length" aria-controls="example">
                <option value=""> - Select Business Division - </option>
                @foreach ($business_division as $value)
                    <option value="{!! $value->id !!}">{!! $value->name !!}</option>
                @endforeach
            </select>
        </div>
        <div class="col-lg-3 col-md-3 col-3 dataTables_length" id="example_length">
        </div>

                <div class="col-lg-1 col-md-1">
                    <div class="ms-auto float-md-end">
                        <div class="btn-group">
                            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i
                                    class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <form action="{!! route('incentive-slabs.store-details', $id) !!}" method="POST">
            @csrf
            @method('post')
            <div class="card-body" id="tables">
                @include('incentive-slabs.details.table')

                <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
                <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
                <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).on('keyup', '.main-percentage', function() {
            var value = allNumeric($(this).val());

            $('.type').val('percentage');
            $('.percentage').val(value);
            $('.main-percentage').val(value);

            $('.price').val('');
            $('.main-price').val('');
        });

        $(document).on('keyup', '.main-price', function() {
            var value = allNumeric($(this).val());
            $('.type').val('quantity');

            $('.price').val(value);
            $('.main-price').val(value);

            $('.percentage').val('');
            $('.main-percentage').val('');
        });

        function allNumeric(inputtxt) {
            onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
            if (onlyNumbers.length > 16) {
                onlyNumbers = onlyNumbers.substring(0, 16);
            }
            return onlyNumbers;
        }

        $(document).on('change', '.type', function() {
            var parent = $(this).parent().parent();

            if ($(this).val() == 'quantity') {
                parent.find('.percentage').val('');
            } else {
                parent.find('.price').val('');
            }
        });

        $(document).on('keyup', '.price', function() {
            var parent = $(this).parent().parent();

            parent.find('.price').prop('disabled', false);
            parent.find('.percentage').val('');
            parent.find('.type').val('quantity');
        });
        $(document).on('keyup', '.percentage', function() {
            var parent = $(this).parent().parent();

            parent.find('.percentage').prop('disabled', false);
            parent.find('.price').val('');
            parent.find('.type').val('percentage');
        });

         /***************** Global Delay Fucntion ***************/
         function delay(callback, ms) {
            var timer = 0;
            return function() {
                var context = this,
                    args = arguments;
                clearTimeout(timer);
                timer = setTimeout(function() {
                    callback.apply(context, args);
                }, ms || 0);
            };
        }

        $(document).ready(function() {
            function clear_icon() {
                $('#id_icon').html('');
                $('#post_title_icon').html('');
            }

            function fetch_data(page, sort_type, sort_by, query){
                var brand_id    = $('.brand_id').val();
                var group_id    = $('.group_id').val();
                var category_id = $('.category_id').val();
                var division_id = $('.division_id').val();

                $.ajax({
                  url:"?page=" + page + "&sortby=" + sort_by + "&sorttype=" + sort_type + "&query=" + query + "&brand_id=" + brand_id + "&group_id=" + group_id + "&category_id=" + category_id + "&division_id=" + division_id,
                  success:function(data){
                    $('#tables').html('');
                    $('#tables').html(data);
                    $(document).ready(function(){
                        $.switcher('.changeStatusCustom');
                    });
                  }
                })
            }

            $('body').on('change', '.sorting', function() {

                var column_name = $(this).val();
                var reverse_order = '';
                var query         = $('#search').val() ? $('#search').val() : '';
                var page        = $('.pager').find('.active a').attr('href') == undefined ?
                    1 : $('.pager').find('.active a').attr('href').split('page=')[1];

                fetch_data(page, reverse_order, column_name, query);
            });

            $(document).on('change', '.brand_id, .group_id, .category_id, .division_id', function() {
                var column_name = $('.sorting').val();
                var order_type  = $('#hidden_sort_type').val();
                var page        = $('.pager').find('.active a').attr('href') == undefined ?
                    1 : $('.pager').find('.active a').attr('href').split('page=')[1];

                var query = $('#search').val() ? $('#search').val() : '';

                fetch_data(page, order_type, column_name, query);
            });

            $('body').on('click', '.pager a', function(event) {
                event.preventDefault();
                var page = $(this).attr('href').split('page=')[1];
                $('#hidden_page').val(page);
                var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                var sort_type   = $('#hidden_sort_type').val();
                var query       = $('#search').val() ? $('#search').val() : '';
                $('li').removeClass('active');
                $(this).parent().addClass('active');
                fetch_data(page, sort_type, column_name, query);
            });

            /******** searching ********/
            $(document).on('keyup', '#search', delay(function() {
                var query = $('#search').val();

                if (query.length < 2 && query.length != 0) {
                    return;
                }

                var column_name = $('.sorting').val();
                var sort_type   = $('#hidden_sort_type').val();
                var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
                fetch_data(page, sort_type, column_name, query);
            }, 700));
        });
    </script>
@endsection
