<form class="row g-3 auto-width" action="{{ route('incentive-slabs.update', $slab->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    {{-- Name --}}
    <div class="col-md-6">
        <label for="slab_name" class="form-label">Slab Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="slab_name" name="slab_name" aria-describedby="inputGroupPrepend" required value="{{$slab->slab_name}}">
        <span class="text-danger error_slab_name" style="display:none;">This field is required.</span>
    </div>
     {{-- Code --}}
     <div class="col-md-6">
        <label for="code" class="form-label">Code </label>
        <input type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" required value="{{$slab->code}}">
    </div>
     {{-- Accounts --}}
     <div class="col-md-6">
        <div>
            <label for="account_type_id" class="form-label">Account Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="account_type_id">
                @foreach ($MasterType as $list)
                    <option value="{{ $list->id }}">{{ $list->type_name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_account_type_id" style="display: none;">This field is required.</span>
    </div>
      {{-- Calaulation Type --}}
    <div class="col-md-6">
        <label for="calculation_type" class="form-label">Calculation Type </label>
        <select class="form-select" aria-label="calculation_type" name="calculation_type" id="calculation_type">
            <option selected value="">Select Calculation Type</option>
            <option value="percentage" {{ matchSelected($slab->calculation_type,'percentage') }}>PERCENTAGE</option>
            <option value="rate_per_piece" {{ matchSelected($slab->calculation_type,'rate_per_piece') }}>Rate Per Piece</option>
          </select>
        <span class="text-danger error_percentage" style="display:none;">This field is required.</span>
    </div>

     {{-- percentage --}}
     <div class="col-md-6" id="percentageField" style="display: {{ $slab->calculation_type === 'percentage' ? 'block' : 'none' }}">
        <label for="percentage" class="form-label">Percentage % </label>
        <input type="number" class="form-control" id="percentage" name="percentage" aria-describedby="inputGroupPrepend" required value="{{$slab->percentage}}">
        </div>
    {{-- price --}}
    <div class="col-md-6" id="priceField" style="display: {{ $slab->calculation_type === 'rate_per_piece' ? 'block' : 'none' }}">
        <label for="price" class="form-label">Price </label>
        <input type="number" class="form-control" id="price" name="price" aria-describedby="inputGroupPrepend" required value="{{$slab->price}}">
    </div>
</form>

<script>
    document.getElementById('calculation_type').addEventListener('change', function() {
        var selectedValue = this.value;
        if (selectedValue === 'percentage') {
            document.getElementById('percentageField').style.display = 'block';
            document.getElementById('priceField').style.display = 'none';
        } else if (selectedValue === 'rate_per_piece') {
            document.getElementById('percentageField').style.display = 'none';
            document.getElementById('priceField').style.display = 'block';
        } else {
            document.getElementById('percentageField').style.display = 'none';
            document.getElementById('priceField').style.display = 'none';
        }
    });

    // Check initially if a calculation type is selected
    window.addEventListener('DOMContentLoaded', function() {
        var selectedValue = document.getElementById('calculation_type').value;
        if (selectedValue === 'percentage') {
            document.getElementById('percentageField').style.display = 'block';
            document.getElementById('priceField').style.display = 'none';
        } else if (selectedValue === 'rate_per_piece') {
            document.getElementById('percentageField').style.display = 'none';
            document.getElementById('priceField').style.display = 'block';
        } else {
            document.getElementById('percentageField').style.display = 'none';
            document.getElementById('priceField').style.display = 'none';
        }
    });
</script>
