<div id="print_div">
    <div class="pathology-bill">
<div class="row">
<div class="col-2" style="width: 20%">
    <p>Date : {!! formatedDate(date('Y-m-d')) !!}</p>
</div>
<div class="col-7" style="text-align: center;">
    <p style="color:#0b5ed7;font-size:18px;margin-bottom: -4px !important"><b>{!! $company->name ?? '' !!}</b></p>
    <p style="font-size: 14px;"><b>STOCK OUT STATEMENT</b></p>
    <p style="padding-bottom: 5px;font-size: 11px;"><b><span style="color: #698aff;">Stock OUT</span> List</b>
    <b>From <span style="color:#698aff;" id="">{{$from_date?formatedDate($from_date):formatedDate(date('Y-m-d H:i:s'))}}</span> TO <span style="color:#698aff;" id="">{{$to_date?formatedDate($to_date):formatedDate(date('Y-m-d H:i:s')) }}</span>
            </b></p>
</div>
<div class="col-2" style="text-align: right; width:20%">
    <p>Time : {!! formatedTime(date('H:i:s')) !!}</p>
</div>
</div>

<div>
    <table class="table table-borderless report-container">
        <tbody class="report-content">
            <tr>
                <td class="report-content-cell">
                    <div class="row">
                        <div class="col-12">

                            <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                <thead>
                                  <tr class="text-uppercase">
                                    <th style="text-align: left;">Sl.</th>
                                    <th style="text-align: left;">Date</th>
                                    <th style="text-align: left;">Voucher No</th>
                                    <!-- <th style="text-align: left;">Transaction Mode</th> -->
                                    <th style="text-align: right;">Taxable Amt.</th>
                                    <th style="text-align: right;">Tax Amt.</th>
                                    <th style="text-align: right;">Total</th>
                                    <th style="text-align: right;">Dis./Adjust</th>
                                    <th style="text-align: right;">Net Amt.</th>
                                   
                                  </tr>
                                </thead>
                                <tbody>
                                  @if(isset($invoices) && count($invoices) > 0)
                                    @php
                                      $ac_receipt_column = 'ac_receipt_'; 
                                      $i                 = 1;
                                      $grand_total       = 0;
                                      $texable = $tex_amt = $total = $disc = $net = $due = $ac_receipt = 0;
                                    @endphp
                                    @foreach($invoices as $invoice)
                                      <tr class="border-1">
                                        <td style="text-align: left;">{!! $i !!}</td>
                                        <td style="text-align: left;">{!! ($invoice->invoice_date ? formatedDateTime($invoice->invoice_date) : '') !!}</td>
                                        <td style="text-align: left;">{!! $invoice->main_invoice_no ?? '' !!}</td>
                                        @php
                                          $tax_amount = $invoice->tax_percentage != 0 ? taxAmountCalculate($invoice->tax_percentage, $invoice->billing_amount) : 0;
                                          $texable    += $invoice->billing_amount - $tax_amount + $invoice->discount_amount;
                                          $tex_amt    += $tax_amount;
                                          $total      += $invoice->billing_amount + $invoice->discount_amount;
                                          $disc       += $invoice->discount_amount;
                                          $net        += $invoice->billing_amount;
                                          $ac_receipt += $invoice->ac_receipt_amount;
                                          $deduct  = 0;
                                          $deduct += $invoice->ac_receipt_amount;
                                          $due += $invoice->billing_amount - $deduct;
                                        @endphp
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->billing_amount - $tax_amount + $invoice->discount_amount) !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($tax_amount) !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->billing_amount + $invoice->discount_amount) ?? '' !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->discount_amount) ?? '0' !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->billing_amount) ?? '0' !!}</td>
                                      
                                      </tr>
                                      @php
                                        $i += 1;
                                      @endphp
                                    @endforeach
                                    <tr>
                                      <td colspan="2"></td>
                                      <td style="text-align: left;"><b>Total</b></td>
                                      <td style="text-align: right;"><b>{!! convertDecimelPoint($texable) !!}</b></td>
                                      <td style="text-align: right;"><b>{!! convertDecimelPoint($tex_amt) !!}</b></td>
                                      <td style="text-align: right;"><b>{!! convertDecimelPoint($total) !!}</b></td>
                                      <td style="text-align: right;"><b>{!! convertDecimelPoint($disc) !!}</b></td>
                                      <td style="text-align: right;"><b>{!! convertDecimelPoint($net) !!}</b></td>
                                    </tr>
                                  @else
                                    <tr>
                                      <td colspan="14" style="text-align: center;">Stock Not Available</td>
                                    </tr>
                                  @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>
</div>
</div>
@if(count($invoices)>0)
<div class="row">
  <div class="col-md-6" style="text-align: right;">
      <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
  </div>

  <div class="col-md-6" style="text-align: left;">
      <a href="javascript:;" class="btn btn-outline-primary export-statement"><i class="bi bi-download"></i> Export</a>
  </div>
</div>
@endif
