@extends('layouts.app')
@section('title', ($accountJournal->voucherMaster->voucherType->voucher_title ?? '') . $accountJournal->voucher_no . ' - '. ($accountJournal->transaction_date ? formatedDate($accountJournal->transaction_date) : ''))
@section('pages')

<div id="btn_back" class="card-header py-3">
  <div class="row gx-2">

    <div class="col-lg-6 col-md-6 col-6">
        <div class="position-relative">
            <h5>{!! $accountJournal->voucherMaster->voucherType->voucher_title ?? 'CONTRA VOUCHER' !!} | {!! $accountJournal->voucher_no !!}</h5>
        </div>
    </div>
    <div class="col-lg-6 col-md-6">
      <div class="ms-auto float-md-end">

        <div class="btn-group">
            <a href="{{ route('contra-vouchers.index') }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            <!-- <button id="btn_pdf" type="button" class="btn btn-primary btn-lg"> Download PDF <i class="bi bi-download text-white"></i></button> -->
        </div>
      </div>
    </div>
  </div>
</div>

<div id="print_div">
    @include('invoice-formats.partials.style')
    <div>
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = $accountJournal->company; @endphp

                                    @include('invoice-formats.partials.header-company')

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row border border-dark text-uppercase info-table" style="padding-top: 2px; padding-bottom: 2px;margin-right:0px;margin-left:0px;">
                                                    <div class="col-4 font-12" style="text-align: left;"><b>Voucher No : {!! $accountJournal->voucher_no ?? '' !!}</b></div>
                                                    <div class="col-4 text-center font-12"><b>Voucher Date : {!! ($accountJournal->transaction_date ? formatedDate($accountJournal->transaction_date) : '') !!}</b></div>
                                                    <div class="col-4 text-right font-12" style="text-align: right;"><b>Ref No :</b> {!! $accountJournal->reference !!}</div> 
                                                </div>
                                                {{-- <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-borderless table-sm mb-1" id="account_to">
                                                            <tbody>
                                                                <tr>
                                                                    <td>
                                                                        <div class="row border border-dark" style="padding-top: 2px; padding-bottom: 0px;line-height:1.2; margin-right:0px;margin-left:0px">
                                                                            <div class="col-8 border-right border-dark" style="font-size:12px;">
                                                                                <table class="table table-borderless mb-1 w-100">
                                                                                    <tbody>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left; width: 20%">Voucher No</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px"><b>{!! $accountJournal->voucher_no ?? '' !!}</b></td>
                                                                                        </tr>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Voucher Date</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px">{!! ($accountJournal->transaction_date ? formatedDate($accountJournal->transaction_date) : '') !!}</td>
                                                                                        </tr>
                                                                                        @if(isset($accountJournal->reference))
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Reference</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px">{!! $accountJournal->reference ?? '' !!}</td>
                                                                                        </tr>
                                                                                        @endif
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Financial Year</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px">{!! $accountJournal->financialYear->financial_year_name ?? '' !!}</td>
                                                                                        </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                            <div class="col-4 border-right border-dark" style=" font-size:12px; margin-top: 10px">
                                                                                @php
                                                                                    $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
                                                                                @endphp
                                                                                <img class="barcodeStyle" src="data:image/png;base64,{{ base64_encode($generatorPNG->getBarcode($accountJournal->voucher_no ?? '', $generatorPNG::TYPE_CODE_128)) }}" height="90" width="200">
                                                                                <br>
                                                                                <h4>{!! $accountJournal->voucher_no ?? '' !!}</h4>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div> --}}
                                                <div class="row mt-n3">
                                                    <div class="col-12 text-center">
                                                        <h4 class="text-bold my-auto">{!! $accountJournal->voucherMaster->voucherType->voucher_title ?? 'JOURNAL VOUCHER' !!}
                                                        </h4>
                                                    </div>
                                                </div>
                                                                                    
                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th style="text-align: left; width: 5%">Sl.No</th>
                                                                    <th style="text-align: left;">Date</th>
                                                                    <th style="text-align: left;">Account</th>
                                                                    <th style="text-align: right;">Debit</th>
                                                                    <th style="text-align: right;">Credit</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                              @php $i = 1; @endphp
                                                              @if(isset($accountJournal->contraVoucherTransaction)&&count($accountJournal->contraVoucherTransaction)>0)
                                                                @foreach($accountJournal->contraVoucherTransaction as $key => $transactions)
                                                                  <tr>
                                                                    <td style="text-align: left;">{{ $i }}</td>
                                                                    <td style="text-align: left;">{{ formatedDate($transactions->transaction_date) }}</td>
                                                                    <td style="text-align: left;">{!! isset($transactions->transaction_type)&&$transactions->transaction_type=='CREDIT' ? "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" : "" !!} {{$transactions->account->name}}</td>
                                                                    <td style="text-align: right;">{{isset($transactions->transaction_type)&&$transactions->transaction_type=='DEBIT' ? convertDecimelPoint($transactions->amount) : "" }}</td>
                                                                    <td style="text-align: right;">{{isset($transactions->transaction_type)&&$transactions->transaction_type=='CREDIT' ? convertDecimelPoint($transactions->amount) : "" }}</td>
                                                                  </tr>
                                                                @endforeach
                                                              @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>

                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                                <div class="row mt-n3">
                                                    <div class="col-6 text-left">
                                                        @if(isset($accountJournal->voucherTerm))
                                                            {!! $accountJournal->voucherTerm->terms_and_condition ?? '' !!}
                                                        @endif
                                                        <br>
                                                    </div>
                                                    <div class="col-6 text-right" style="text-align: right;">
                                                        <p>
                                                            <span style="font-size: 16px;text-align: right;">
                                                                <b>{!! $accountJournal->company->name ?? '' !!}</b>
                                                            </span>
                                                            <br> <br>
                                                            Authorised Signatory <br>
                                                            Prepared by: {!! $accountJournal->user->name ?? '' !!}<br>
                                                            <b style="font-size: 10px">Note: Digitally Generated Voucher, Signature Not Required</b>
                                                        </p>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div style="width:100%; text-align: center; ">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
    </div>
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click','#btn_print',function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click','#btn_pdf',function(e) {
            /*html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });*/
            downloadPDF();
        });
        function downloadPDF() {
            const doc = new jsPDF();
            const element = document.getElementById('print_div');

            doc.html(element, {
                callback: function (pdf) {
                    pdf.save('print_div_content.pdf');
                }
            });
        }
    });
</script>
@endsection