@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. $sale_invoice->main_invoice_no . ' - '. ($sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@php $pageTitle =  $sale_invoice->main_invoice_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp
<div class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>IPD Invoice of {!! $sale_invoice->getPatient->account_title->name ?? '' !!} {!! $sale_invoice->getPatient->name ?? '' !!} (
                    {!! $sale_invoice->getPatient->code ?? '' !!}) <br>
                   {{-- Batch NO: {!! $sale_invoice->getBatchs[0]->invoice_batch_no ?? '' !!} --}}
                </h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <a href="{{ request()->get('redirect_route') != '' ? route(request()->get('redirect_route')) : route('ipd-admissions.show',$sale_invoice->ipd_admission_id) }}" class="btn btn-outline-secondary me-1">
                        <i class="bx bx-arrow-back ms-0 me-1"></i>Back
                    </a>
                    {{-- @if(in_array('ipd-admission-create', $authRolePermissions)) --}}
                      {{-- <a href="{{ route('ipd-admissions.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> New Admission</a> --}}
                      {{-- @endif --}}
                        {{-- @if(!is_null($ipd_id ?? ''))
                            <div class="float-md-end" style="margin-right: 10px">
                                <a href="{{ route('ipd-billings.create', $ipd_id ?? '') }}" class="btn btn-info new-bill">
                                    <i class="bx bx-plus text-white"></i> New Intent
                                </a>
                            </div>
                        @endif --}}
                </div>
            </div>
        </div>
    </div>
</div>
    <div id="print_div">
        <div class="pathology-bill">
            <div class="row mt-2">
                <style type="text/css">
                    .category_name {
                        font-size: 13px;
                        font-weight: bold;
                        padding-top: 5px;
                        margin-left: 10px;
                    }
                    .date {
                        font-size: 14px;
                        font-weight: bold;
                        padding-top: 5px;
                        /*margin-left: 15px;*/
                    }
                    @page {
                      size: A4;
                      margin: 0 auto;
                      margin-bottom: 0.5cm;
                      margin-top: 0.5cm;
                    }
                    @media print {
                        .report-footer {
                            color: black;
                            background-color: transparent;
                            position: fixed;
                            bottom: 0;
                            left: 0;
                            right: 0;
                            border-top: solid black 1px;
                        }
                        
                        .report-container {
                            width: 100%;
                            margin-bottom: 60px; /* Adjust according to the footer height */
                            page-break-inside: auto;
                        }

                        .report-header, .report-content, .report-footer {
                            page-break-inside: avoid;
                        }

                        .report-footer {
                            page-break-before: always; /* Move tfoot to the next page if necessary */
                        }

                        tr {
                            page-break-inside: avoid;
                            page-break-after: auto;
                        }

                        .report-content {
                            page-break-after:always
                        }
                    }
                </style>
                <div class="col-md-12 col-xs-12 p-1">
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-borderless report-container">
                                        @php $company = @$sale_invoice->getCompany;@endphp
                                        <thead class="report-header">
                                            <tr>
                                                <th class="report-header-cell" style="font-weight: normal;">
                                                    <x-CompanyLetterHead :company="$company" />
                                                    @php $voucherType = 'PATHOLOGY_LAB_BILLING'; @endphp
                                                    @php $saleInvoice = $sale_invoice; @endphp
                                                    @php $voucherTitle = $voucher_type->voucher_title; @endphp
                                                    @include('components.ipd-specific-print-voucher-details')
                                                </th>
                                            </tr>
                                        </thead>
                                        @php
                                            $discount = isset($sale_invoice->getSaleInvoiceDiscounts) && $sale_invoice->getSaleInvoiceDiscounts!=''?$sale_invoice->getSaleInvoiceDiscounts->discount_amount:'';

                                            if($discount>0 || $voucher_type->tax_applicable == '1')
                                            {
                                                $rowspan = 2;
                                            }else{
                                                $rowspan = 1;
                                            }

                                            $patient        = $sale_invoice->getPatient ?? null;
                                            $patientAddress = $patient->first_account_address ?? null;
                                            $patientState   = $patientAddress->state->name ?? '';
                                            $company        = @$sale_invoice->getCompany;
                                            $comapnyState   = $company->getCompanyAddress->getComapnyState->name ?? '';
                                        @endphp
                                        <tbody class="report-content">
                                            <tr>
                                                <td class="report-content-cell  text-left">
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <table class="table table-bordered-print w-100" id="quotation_products">
                                                                <thead>
                                                                    <tr class="text-uppercase">
                                                                        <th width="2%" class="text-center" rowspan="{!! $rowspan !!}">Sl.No</th>
                                                                        <th width="15%" rowspan="{!! $rowspan !!}">Item Name &amp; Details</th>
                                                                        <th width="15%" rowspan="{!! $rowspan !!}">Consultant Name</th>
                                                                        <th width="10%" rowspan="{!! $rowspan !!}">Batch No</th>
                                                                        @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                        <th class="text-center" rowspan="{!! $rowspan !!}">HSN/SAC</th>
                                                                        @endif
                                                                        <th width="7%" class="" rowspan="{!! $rowspan !!}">Date/Time</th>
                                                                        <th width="5%" class="text-end" rowspan="{!! $rowspan !!}">MRP</th>
                                                                        <th width="3%" class="text-end" rowspan="{!! $rowspan !!}">Qty</th>
                                                                        <th width="3%" class="text-end" rowspan="{!! $rowspan !!}">UOM</th>
                                                                        <th width="4%" class="text-end" rowspan="{!! $rowspan !!}">Rate</th>
                                                                        @if($discount>0)
                                                                        <th width="10%" class="text-center" colspan="2">Discount</th>
                                                                        @endif
                                                                        @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                        <th class="text-end" rowspan="2">Taxable Amt</th>
                                                                            @if($patientState == $comapnyState)
                                                                                <th class="text-center" colspan="2">CGST</th>
                                                                                <th class="text-center" colspan="2">SGST</th>
                                                                            @else
                                                                                <th class="text-center" colspan="2">IGST</th>
                                                                            @endif
                                                                        <th class="text-center" colspan="2">CESS</th>
                                                                        @endif
                                                                        <th width="5%" class="text-end" rowspan="2">Total</th>
                                                                    </tr>
                                                                    <tr class="text-uppercase font-weight-bold">
                                                                        @if($discount>0)
                                                                        <td width="2%" class="text-end">%</td>
                                                                        <td width="3%" class="text-end">Amt</td>
                                                                        @endif
                                                                        @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                            @if($patientState == $comapnyState)
                                                                                <td width="2%" class="text-end">%</td>
                                                                                <td width="3%" class="text-end">Amt</td>
                                                                                <td width="2%" class="text-end">%</td>
                                                                                <td width="3%" class="text-end">Amt</td>
                                                                            @else
                                                                                <td width="2%" class="text-end">%</td>
                                                                                <td width="3%" class="text-end">Amt</td>
                                                                            @endif
                                                                        <td width="2%" class="text-end">%</td>
                                                                        <td width="3%" class="text-end">Amt</td>
                                                                        @endif
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @php
                                                                        $total_bill = 0;
                                                                        $total_sum_gst_amount = 0;
                                                                        $total_discountAmount = 0;
                                                                    @endphp

                                                                    @foreach($sale_invoice_details as $category => $details)
                                                                        <tr>
                                                                            <td colspan="25" class="text-center">
                                                                                <span class="category_name">{{ $details['category_name'] }}</span>
                                                                            </td>
                                                                        </tr>

                                                                        @php
                                                                            $total_gst_amount = 0;
                                                                            $IGST = $CGST = $SGST = $CESS = 0;
                                                                            $totalMrp = 0;
                                                                            $totalQnt = 0;
                                                                            $totalValue = 0;
                                                                            $totalValueAmount = 0;
                                                                            $totalDiscountAmount = 0;
                                                                            $totalAmount = 0;
                                                                            $IgstAmount = $CgstAmount = $SgstAmount = $CessAmount = 0;
                                                                            $totalIgstAmount = $totalCgstAmount = $totalSgstAmount = $totalCessAmount = 0;
                                                                            $mrp = 0;
                                                                        @endphp

                                                                        @foreach ($details['sale_invoice_details'] as $key => $value)
                                                                            @php
                                                                            
                                                                                $totalMrp +=$value->price;
                                                                                $totalQnt+=$value->main_qty;
                                                                                $totalValue+=$value->price*$value->main_qty;
                                                                                $totalValueAmount = $value->price*$value->main_qty;
                                                                                $totalDiscountAmount+=$value->discount_amount;
                                                                                $mrp = ($value->main_qty>0)?$value->customer_amount/$value->main_qty:0;
                                                                            @endphp

                                                                            <tr>
                                                                                <td class="text-center">{{ $key + 1 }}</td>
                                                                                <td>{{ $value->product_name ?? '' }}</td>
                                                                                <td>{{ $value->consultant_name ?? '' }}</td>
                                                                                <td>{{ $value->invoice_batch_no ?? '' }}</td>
                                                                                @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                                <td class="text-center">{!! $value->getProduct->hsncode ?? '' !!}</td>
                                                                                @endif
                                                                                <td>{{ isset($value->batch_date) && $value->batch_date != '' ? formatedDate($value->batch_date) : '' }}
                                                                                    {{ isset($value->batch_date) && $value->batch_date != '' ? formatedTime($value->batch_date) : '' }} 
                                                                                </td>

                                                                                <td class="text-end">{{ isset($mrp) ? convertDecimelPoint($mrp) : '' }}</td>
                                                                                <td class="text-end">{{ isset($value->main_qty) ? convertDecimelPoint($value->main_qty) : '' }}</td>
                                                                                <td class="text-end">{{ $value->primary_unit_code ?? '' }}</td>
                                                                                <td class="text-end">{{ isset($value->price) ? convertDecimelPoint($value->price) : '' }}</td>
                                                                                @if($discount > 0)
                                                                                    <td class="text-end">{{ $value->discount_percentage ?? '' }}</td>
                                                                                    <td class="text-end">{{ isset($value->discount_amount) ? convertDecimelPoint($value->discount_amount) : '' }}</td>
                                                                                @endif

                                                                                @php
                                                                                    $gst = $value->getProduct->getTaxMaster->total_percentage ?? 0;
                                                                                    $gst_amount = taxAmountCalculate($gst, $totalValueAmount);
                                                                                    $total_gst_amount += $gst_amount;
                                                                                @endphp
                                                                                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                                    <td class="text-end">{{ convertDecimelPoint($totalValueAmount - $value->discount_amount) }}</td>

                                                                                    @php
                                                                                        if (isset($value->getProduct->getTaxMaster->getTaxMasterSub)) {
                                                                                            foreach ($value->getProduct->getTaxMaster->getTaxMasterSub as $tax) {
                                                                                                if ($tax->name == 'IGST') {
                                                                                                    $IGST = $tax->percentage ?? 0;
                                                                                                    $IgstAmount = taxAmountCalculate($tax->percentage, $totalValueAmount);
                                                                                                    $totalIgstAmount += $IgstAmount;
                                                                                                } elseif ($tax->name == 'CGST') {
                                                                                                    $CGST = $tax->percentage ?? 0;
                                                                                                    $CgstAmount = taxAmountCalculate($tax->percentage, $totalValueAmount);
                                                                                                    $totalCgstAmount += $CgstAmount;
                                                                                                } elseif ($tax->name == 'SGST') {
                                                                                                    $SGST = $tax->percentage ?? 0;
                                                                                                    $SgstAmount = taxAmountCalculate($tax->percentage, $totalValueAmount);
                                                                                                    $totalSgstAmount += $SgstAmount;
                                                                                                } elseif ($tax->name == 'CESS') {
                                                                                                    $CESS = $tax->percentage ?? 0;
                                                                                                    $CessAmount = taxAmountCalculate($tax->percentage, $totalValueAmount);
                                                                                                    $totalCessAmount += $CessAmount;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    @endphp
                                                                                   
                                                                                    @if($patientState == $comapnyState)
                                                                                    <td class="text-end">{{ $CGST }}</td>
                                                                                    <td class="text-end">{{ $CgstAmount ? convertDecimelPoint($CgstAmount) : 0.00 }}</td>
                                                                                    <td class="text-end">{{ $SGST }}</td>
                                                                                    <td class="text-end">{{ $SgstAmount ? convertDecimelPoint($SgstAmount) : 0.00 }}</td>
                                                                                    @else
                                                                                    <td class="text-end">{{ $IGST }}</td>
                                                                                    <td class="text-end">{{ $IgstAmount ? convertDecimelPoint($IgstAmount) : 0.00 }}</td>
                                                                                    @endif
                                                                                    <td class="text-end">{{ $CESS }}</td>
                                                                                    <td class="text-end">{{ $CessAmount ? convertDecimelPoint($CessAmount) : 0.00 }}</td>
                                                                                @endif
                                                                                <td class="text-end">{{ convertDecimelPoint($totalValueAmount + $gst_amount - $value->discount_amount) ?? '' }}</td>
                                                                                @php
                                                                                    $newAmount = $totalValueAmount + $gst_amount - $value->discount_amount;
                                                                                    $totalAmount += $newAmount;
                                                                                @endphp
                                                                            </tr>
                                                                        @endforeach
                                                                        <tr>
                                                                            <td></td>
                                                                            @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                                <td></td>
                                                                            @endif
                                                                            <td align="right" colspan="3"><b>TOTAL</b></td>
                                                                            @if(request()->segment(1) != 'pathology-invoice')
                                                                                <td></td>
                                                                            @endif
                                                                            <td align="right"><b>{{-- {{ $totalMrp ? convertDecimelPoint($totalMrp) : '' }} --}}</b></td>
                                                                            <td align="right"><b>{{ $totalQnt ? convertDecimelPoint($totalQnt) : '' }}</b></td>
                                                                            <td></td>
                                                                            <td></td>
                                                                            @if($discount > 0)
                                                                                <td></td>
                                                                                <td align="right"><b>{{ $totalDiscountAmount ? convertDecimelPoint($totalDiscountAmount) : '' }}</b></td>
                                                                            @endif
                                                                            @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                                @if($patientState == $comapnyState)
                                                                                <td align="right"><b>{{ $total_gst_amount ? convertDecimelPoint($total_gst_amount) : '' }}</b></td>
                                                                                <td></td>
                                                                                <td align="right"><b>{{ $totalCgstAmount ? convertDecimelPoint($totalCgstAmount) : 0.00 }}</b></td>
                                                                                <td></td>
                                                                                @else
                                                                                <td align="right"><b>{{ $totalSgstAmount ? convertDecimelPoint($totalSgstAmount) : 0.00 }}</b></td>
                                                                                <td></td>
                                                                                @endif
                                                                                <td align="right"><b>{{ $totalIgstAmount ? convertDecimelPoint($totalIgstAmount) : 0.00 }}</b></td>
                                                                                <td></td>
                                                                                <td align="right"><b>{{ $totalCessAmount ? convertDecimelPoint($totalCessAmount) : 0.00 }}</b></td>
                                                                            @endif
                                                                            <td align="right"><b>{{ $totalAmount ? convertDecimelPoint($totalAmount) : 0.00 }}</b></td>
                                                                        </tr>

                                                                        @php
                                                                            $total_bill += $totalAmount;
                                                                            $total_sum_gst_amount += $total_gst_amount;
                                                                            $total_discountAmount += $totalDiscountAmount;
                                                                        @endphp
                                                                    @endforeach
                                                                    @php
                                                                        $total_billing_amount = $total_bill;
                                                                        $total_received_amount = $total_received_amount->total_amount;
                                                                    @endphp
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        
                                    </table>
                                    
                                    <div class="row mt-n2">
                                        <div class="col-4">
                                            <table class="table" id="payment_summary">
                                                <tbody>
                                                    <tr>
                                                        <td colspan="4"><b>TRANSACTION SUMMARY</b></td>
                                                    </tr>
                                                    <tr>
                                                        <td width="3%"><b>SL.NO</b></td>
                                                        <td width="30%"><b>Date</b></td>
                                                        {{--<td class="text-start"><b>Mode</b> </td>--}}
                                                        <td class="text-start"><b>Mode</b> </td>
                                                        <td width="5%" style="text-align: right;"><b>Amount</b></td>
                                                    </tr>
                                                    @php $totalReceivedAmount = 0; @endphp
                                                    @foreach($transactionHistory as $key => $list)
                                                    <tr>
                                                        <td>{!! $key+1 !!}</td>
                                                        <td style="text-align: left;">{!! $list['transactionDate'] !!}</td>
                                                        {{--<td>
                                                            {!! $list['transactionMode'] !!} 
                                                           
                                                        </td>--}}
                                                        <td>
                                                            {!! $list['paymentMode']??'' !!}   
                                                            @if($list['advanceReceived']=='Yes')
                                                            (Advance)
                                                            @endif
                                                        </td>
                                                        <td class="text-right text-end">
                                                            @php $totalReceivedAmount+=$list['amount'] @endphp
                                                            {!! $list['amount'] !!}
                                                        </td>
                                                    </tr>

                                                    @endforeach
                                                    @php
                                                        $gst_amount = $total_sum_gst_amount ?? 0;
                                                        $grand_total = $total_billing_amount - (Integer)$total_discountAmount ?? 0;
                                                    @endphp
                                                    <tr>
                                                        <td colspan="3" class="text-start"><b>Total Received</b></td>
                                                        <td class="text-end"><b>{!! convertDecimelPoint($totalReceivedAmount) !!}</b></td>
                                                    </tr>
                                                    @php $returnAmount = isset($returnTransactionSummery['totalBilling'])? $returnTransactionSummery['totalBilling'] :0; @endphp
                                                    <tr>
                                                        <td colspan="3" class="text-start"><b>Balance Amount</b></td>
                                                        <td class="text-end"><b>{!! convertDecimelPoint(round($total_billing_amount - $totalReceivedAmount - $returnAmount)) !!}</b></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="col-4">
                                        </div>
                                        <div class="col-4">
                                            <table class="table tr mb-1" id="billing_summary">
                                                <tbody>
                                                    <tr>
                                                        <td colspan="2"><b>VOUCHER SUMMARY</b></td>
                                                    </tr>
                                                    <tr>
                                                        <td>BASIC
                                                            AMOUNT</td>
                                                        <td class="text-right text-end">
                                                            {!! convertDecimelPoint( $total_billing_amount) !!}</td>
                                                    </tr>
                                                    @if($gst_amount>0)
                                                    <tr>
                                                        <td>TOTAL TAX
                                                        </td>
                                                        <td class="text-right text-end">
                                                            {!! convertDecimelPoint($gst_amount) ?? '' !!}</td>
                                                    </tr>
                                                    @endif
                                                    <tr>
                                                        <td>
                                                            SUBTOTAL
                                                        </td>
                                                        <td class="text-right text-end">
                                                            {!! convertDecimelPoint($total_billing_amount + $gst_amount) ?? '' !!}</td>
                                                    </tr>
                                                    @if($total_discountAmount>0)
                                                    <tr>
                                                        <td>SPECIAL
                                                            DISCOUNT</td>
                                                        <td class="text-right text-end">
                                                            {!! convertDecimelPoint($total_discountAmount) ?? '' !!}</td>
                                                    </tr>
                                                    @endif
                                                    @if(isset($returnTransactionSummery['totalBilling']))
                                                    <tr>
                                                        <td>RETURN TOTAL</td>
                                                        <td class="text-right text-end">
                                                            <b>{!! $returnTransactionSummery['totalBilling'] !!}</b>
                                                        </td>
                                                        @php  $grand_total = $grand_total-$returnTransactionSummery['totalBilling']; @endphp 
                                                    </tr>
                                                    @endif
                                                    <tr>
                                                        <td><b>GRAND
                                                                TOTAL</b></td>

                                                        <td class="text-right text-end">
                                                            <b>{!! convertDecimelPoint(round($grand_total)) !!}</b>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                        </div>

                                        <x-BillFooter :saleInvoice="$sale_invoice" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="text-center">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Billing Summary </button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
