@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. $discharge_invoice->get_admission_details->ipd_admission_no . ' - '. ($discharge_invoice->get_admission_details->admission_date_time ? formatedDate($discharge_invoice->get_admission_details->admission_date_time) : '') . ' - ' . ($discharge_invoice->get_admission_details->contacts->name ?? ''))

@section('pages')
    <div id="print_div">

        <style type="text/css">
            .text-left {
                text-align: left !important;
            }
            table#quotation_products, table#quotation_products th, table#quotation_products td {
              border: 1px solid black;
              border-collapse: collapse;
            }
            table#bank_details, table#bank_details th, table#bank_details td {
                text-align: left !important;
            }
            .table>tbody>tr>td:first-child {
                color: #212529;
            }
        </style>

        <div id="btn_back" class="card-header py-3">
          <div class="row gx-2">
            <div style="text-align: center;" class="col-lg-10 col-md-10">
                <h5>IPD Discharge Invoice of {!! $discharge_invoice->get_admission_details->contacts->name .' ('. $discharge_invoice->get_admission_details->contacts->code .')' !!}</h5>
            </div>
            <div class="col-lg-2 col-md-2">
              <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <a href="{{ route('ipd-billings.index') }}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="row mt-2">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell">
                                                <div class="row text-left p-0" id="header">
                                                    <div class="col-8" style="line-height: 1.2;padding-bottom:5px">
                                                        <h3 class="m-0 p-0">{!! $discharge_invoice->get_admission_details->contacts->company->name ?? '' !!}</h3>
                                                        <p class="p-0 m-0 font-weight-normal font-12">ADDRESS: {!! $discharge_invoice->get_admission_details->contacts->company->getCompanyAddress->address_1 ?? '' !!}</p>
                                                        <p class="p-0 m-0 font-weight-normal font-12">STATE: {!! $discharge_invoice->get_admission_details->contacts->company->getCompanyAddress->getComapnyState->name ?? '' !!}</p>
                                                        <p class="p-0 m-0 font-weight-normal font-12">MOBILE: {!! $discharge_invoice->get_admission_details->contacts->company->mobile_number ?? '' !!}{!! $discharge_invoice->get_admission_details->contacts->company->phone_number ? ', '. $discharge_invoice->get_admission_details->contacts->company->phone_number : '' !!}</p>
                                                        <p class="p-0 m-0 font-weight-normal font-12">EMAIL: {!! $discharge_invoice->get_admission_details->contacts->company->email ?? '' !!}{!! $discharge_invoice->get_admission_details->contacts->company->website ? ', ' . $discharge_invoice->get_admission_details->contacts->company->website : '' !!}</p>
                                                    </div>
                                                    <div class="col-4 text-right ">
                                                        @if(isset($discharge_invoice->get_admission_details->contacts->company->logo) && $discharge_invoice->get_admission_details->contacts->company->logo != '')
                                                          <img class="img-thumbnail border-0" src="{!! $discharge_invoice->get_admission_details->contacts->company->logo !!}" alt="Upload Letter Head Logo" height="90" width="200">
                                                        @else
                                                          <img class="img-thumbnail border-0" src="https://master.cloudpatholab.com/uploads/letterheads/images/1/c7ba6041869fc6929fe5e9c6e4be52bf.png" alt="Upload Letter Head Logo" height="90" width="200">
                                                        @endif
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                    </thead>

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell text-left">
                                                <div class="row border border-dark border-bottom-0 m-0 pb-1" style="border:1px solid #000;">
                                                    <div class="col-4 font-12"><b>Admission No :</b> {!! $sale_invoice->main_invoice_no ?? '' !!}</div>
                                                    <div class="col-4 text-left font-12"><b>Admission Dt :</b> {!! $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '' !!}</div>
                                                    <div class="col-4 text-right font-12"><b>Discharge Dt :</b> {!! $sale_invoice->getPaymentTerm->payment_term_name  ?? '' !!}</div>
                                                </div>
                                                <div class="row border border-dark border-bottom-0 m-0 pb-1" style="border:1px solid #000;">
                                                    <div class="col-4 font-12"><b>Discharge Type :</b> {!! $sale_invoice->main_invoice_no ?? '' !!}</div>
                                                    <div class="col-4 text-left font-12"><b>Bed Type :</b> {!! $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '' !!}</div>
                                                    <div class="col-4 text-right font-12"><b>Bed No :</b> {!! $sale_invoice->getPaymentTerm->payment_term_name ?? '' !!}</div>
                                                </div>
                                                @php
                                                    $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                                                    $age           = $date_of_birth != '' ? age($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                                                @endphp
                                                <div class="row">
                                                    <div class="col-12">
                                                        <div class="row border border-dark py-1 m-0" style="line-height:1.2;">
                                                            <div class="col-4 border-right border-dark" style="font-size:12px;">
                                                                <span style="font-size: 13px;border-bottom:1px solid #555;">
                                                                Patient Details:
                                                                </span>
                                                                <p class="mb-0 pt-1"><b>{!! $sale_invoice->getPatient->account_title->name ?? '' !!} {!! $sale_invoice->getPatient->name ?? '' !!} ({!! $sale_invoice->getPatient->code ?? '' !!})</b></p>
                                                                <p class="mb-0 ">Gender : {!!
                                                                $sale_invoice->getPatient->account_contact->gender->name ?? '' !!}</p>
                                                                <p class="mb-0 ">Age : {!!
                                                                $age !!} Years</p>
                                                                <p class="mb-0 ">{!! $sale_invoice->getPatient->first_account_address->address_line1 ?? '' !!}</p>
                                                                <p class="mb-0 ">State Name : {!! $sale_invoice->getPatient->first_account_address->state->name ?? '' !!}</p>
                                                            </div>
                                                            <div class="col-4 border-right border-dark" style="font-size:12px;">
                                                                <p class="mb-0 ">Phone No : {!! $sale_invoice->getPatient->account_contact->phone_no ?? '' !!}</p>
                                                                <p class="mb-0 ">Email : {!! $sale_invoice->getPatient->account_contact->email ?? '' !!}</p>
                                                                <p class="mb-0">Reff No. : {!! $sale_invoice->reff_no ?? '' !!}</p>
                                                                <p class="mb-0">Delivery Date : {!! $sale_invoice->getSaleInvoiceDelivery->delivery_date ?? '' !!}</p>
                                                                <p class="mb-0">Delivery Agent : Self</p>
                                                            </div>
                                                            <div class="col-4 text-center pt-1 pb-1" style="width:auto !important;">
                                                                <div class="mb-3">
                                                                    {!! DNS1D::getBarcodeHTML($sale_invoice->main_invoice_no, 'C93') !!}
                                                                    <br>
                                                                    <h4>{!! $sale_invoice->main_invoice_no ?? '' !!}</h4>
                                                                </div>
                                                           </div>
                                                        </div>
                                                        <table class="table table-borderless table-sm" id="account_to">
                                                            <tbody>
                                                                <tr>

                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="row mt-n3">
                                                    <div class="col-12 text-center">
                                                        <h4 class="text-bold">{!! $voucher_type->voucher_title ?? '' !!}
                                                            <input type="hidden" name="saleid" value="{!! $sale_invoice->main_invoice_no !!}" id="saleid">
                                                        </h4>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100" id="quotation_products" border='1' style="border:1px solid #000;">
                                                            <thead>
                                                                <tr>
                                                                    <th>Sl.No</th>
                                                                    <th>ITEM NAME & DETAILS </th>
                                                                    <th>HSN/SAC</th>
                                                                    <th>MRP</th>
                                                                    <th>QTY</th>
                                                                    <th>Dis(%)</th>
                                                                    <th>PRICE</th>
                                                                    <th>GST%</th>
                                                                    <th>IGST</th>
                                                                    <th>CGST</th>
                                                                    <th>SGST</th>
                                                                    <th>CESS</th>
                                                                    <th>BASIC</th>
                                                                    <th>TOTAL</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>

                                                                @php
                                                                    $total_gst_amount = 0;
                                                                    $IGST = $CGST = $SGST = 0;
                                                                @endphp
                                                                @foreach($sale_invoice->getSaleInvoiceDetails as $key => $value)
                                                                    <tr>
                                                                        <td>{!! $key + 1 !!}</td>
                                                                        <td>{!! $value->getProduct->name ?? '' !!}</td>
                                                                        <td>{!! $value->getProduct->hsncode ?? '' !!}</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! isset($value->getProduct->getProductPrice->mrp) ? convertDecimelPoint($value->getProduct->getProductPrice->mrp) : '' !!}</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! isset($value->main_qty) ? convertDecimelPoint($value->main_qty) : '' !!}
                                                                        </td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! isset($value->discount_amount) ? convertDecimelPoint($value->discount_amount) : '' !!} ({!! $value->discount_percentage ?? '' !!})</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! convertDecimelPoint($value->basic_amount) !!}</td>
                                                                        @php
                                                                            $gst = $value->getProduct->getTaxMaster->total_percentage ?? 0;
                                                                            $gst_amount = ($gst > 0 ? (($gst / 100) * $value->total_amount) : 00);
                                                                            $total_gst_amount +=$gst_amount
                                                                        @endphp
                                                                        <td style="text-align: right !important;">{!! $gst !!}% ({!! convertDecimelPoint($gst_amount) !!})</td>
                                                                        @php
                                                                            if (isset($value->getProduct->getTaxMaster->getTaxMasterSub)) {
                                                                                foreach($value->getProduct->getTaxMaster->getTaxMasterSub as $tax) {
                                                                                    if ($tax->name == 'IGST') {
                                                                                        $IGST = $tax->percentage ?? 0;
                                                                                    } else if ($tax->name == 'CGST') {
                                                                                        $CGST = $tax->percentage ?? 0;
                                                                                    } else if ($tax->name == 'SGST') {
                                                                                        $SGST = $tax->percentage ?? 0;
                                                                                    }
                                                                                }
                                                                            }
                                                                        @endphp
                                                                        <td style="text-align: right !important;">{!! $IGST !!}%</td>
                                                                        <td style="text-align: right !important;">{!! $CGST !!}%</td>
                                                                        <td style="text-align: right !important;">{!! $SGST !!}%</td>
                                                                        <td style="text-align: right !important;">{!! convertDecimelPoint($value->tax_cess_amount) ?? '' !!}</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! convertDecimelPoint($value->total_amount) ?? '' !!}</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! convertDecimelPoint($value->total_amount + $gst_amount) ?? '' !!}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="row mt-n2">
                                                    <div class="col-4">
                                                        <table class="table tr" id="bank_details">
                                                            <tbody>
                                                                <tr>
                                                                    <td colspan="2"><b>BANK DETAILS</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>ACCOUNT NAME</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->account_holder_name ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>ACCOUNT NUMBER</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->account_number ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>IFSC</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->ifsc_code ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BANK NAME</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->bank_name ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BRANCH NAME</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->bank_branch ?? '' !!}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-4">
                                                        <table class="table tr" id="bank_details">
                                                            <tbody>
                                                                <tr>
                                                                    <td colspan="2"><b>PAYMENT SUMMARY</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>TOTAL BILLING AMOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->billing_amount) ? convertDecimelPoint($sale_invoice->billing_amount) : '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>TOTAL RECEIVED AMOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->received_amount) ? convertDecimelPoint($sale_invoice->received_amount) : '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>SPECIAL DISCOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->discount_amount) ? convertDecimelPoint($sale_invoice->discount_amount) : '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BALANCE</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->due_amount) ? convertDecimelPoint($sale_invoice->due_amount) : '' !!}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-4">
                                                        <table class="table tr" id="bank_details">
                                                            <tbody>
                                                                <tr>
                                                                    <td colspan="2"><b>BILLING SUMMARY</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BASIC AMOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->billing_amount) ? convertDecimelPoint($sale_invoice->billing_amount) : '' !!}</td>
                                                                </tr>
                                                                @php
                                                                    $gst_amount = $gst_amount ?? 0;
                                                                @endphp
                                                                <tr>
                                                                    <td>TOTAL TAX</td>
                                                                    <td style="text-align: right !important;">{!! convertDecimelPoint($gst_amount) ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td><b>SUBTOTAL</b></td>
                                                                    <td style="text-align: right !important;">{!! convertDecimelPoint($sale_invoice->billing_amount + $gst_amount) ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>SPECIAL DISCOUNT</td>
                                                                    <td style="text-align: right !important;">{!! convertDecimelPoint($sale_invoice->discount_amount) ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td><b>GRAND TOTAL</b></td>
                                                                    @php
                                                                        $grand_total = $sale_invoice->billing_amount + $gst_amount - $sale_invoice->discount_amount ?? 0;
                                                                    @endphp
                                                                    <td style="text-align: right !important;"><b>{!! convertDecimelPoint($grand_total) !!}</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="2">
                                                                        <sub>Amount (in words) : {!! convertAmountToWords($grand_total) !!}</sub></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>

                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                                <div class="row mt-n3">
                                                    <div class="col-5">
                                                        <span style="font-weight:bold;">Terms and Conditions:</span>
                                                        <div class="p-2 border">
                                                            <p>E. & O.E. Subject to Agartala Juridictions Only. Goods or Service Once sold Item will not Be taken Back. Interest @ 18% p.a. Will be charged if the payment is not madewith the stipulated time. </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-3 text-center align-self-end pb-3">
                                                        <hr>
                                                        <p><b>Customer Signature</b></p>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <table class="table table-borderless" id="company_regards">
                                                            <tbody>
                                                                <tr>
                                                                    <td style="font-size: 16px;padding-bottom: 30px;">
                                                                        <b>META MINT PRIVATE LIMITED</b>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="font-size: 12px; text-align: right;">
                                                                        Authorised Signatory
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="font-size: 12px; text-align: right;">Note: Digitally Generated Invoice, Signature Not Required</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <button id="btn_print" type="button" class="btn btn-primary">Print Invoice</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $('#btn_print').click(function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
        });

        $('#btn_pdf').click(function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });
</script>
@endsection
