@extends('layouts.app')

@section('title', $voucher_type->name . ' - ' . (isset($sale_invoice->main_invoice_no) ? $sale_invoice->main_invoice_no:'' ). ' - ' . (isset($sale_invoice->invoice_date) ? formatedDate($sale_invoice->invoice_date) : '') . ' - ' . (isset($sale_invoice->getPatient->name) ?? ''))

@section('pages')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
    <link href="{{ asset('admin/css/print.css') }}" rel="stylesheet" />
    @php
        $pageTitle = isset($sale_invoice->main_invoice_no)??'' . ' - ' . (isset($ipd_id->getPatient->name) ?? '') . '-' . (isset($sale_invoice->invoice_date) ? formatedDate($sale_invoice->invoice_date) : '');
    @endphp

    <style>
        .table-container {
            max-width: 1000px;
            margin: auto;
            border-radius: 8px;
            overflow: hidden;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 2px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #f4f4f4;
            color: #555;
        }

        h6 {
            margin: 0;
        }


        .left-column, .right-column {
            width: 50%;
            vertical-align: top;
        }
        #print_div {
            width: 1000px;
            margin: 0 auto;
        }
    </style>

    <div class="card-header py-3">
        <div class="row gx-2">
            <div class="col-lg-6 col-md-6 col-6">
                <div class="position-relative">
                    <h5>IPD Invoice of {!! $ipd_id->getPatient->account_title->name ?? '' !!} {!! $ipd_id->getPatient->name ?? '' !!} (
                        {!! $ipd_id->getPatient->code ?? '' !!}) <br>
                        {{-- Batch NO: {!! $sale_invoice->getBatchs[0]->invoice_batch_no ?? '' !!} --}}
                    </h5>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="ms-auto float-md-end">
                    <div class="btn-group">
                        @if(empty($ipd_admission->status))
                        <button  class="btn btn-warning edit_patient me-1" title="Edit" id="edit_patient" type="button" data-id="{{ $ipd_admission->patient_id }}" data-bs-toggle="modal" data-bs-target="#commonModal">
                            <i class="bi bi-pencil-square"></i> Edit Patient
                        </button>
                        @endif
                        @if(isset($ipd_admission->patient_id))
                        <a href="{{ route('ipd-billings-summary', $ipd_id) }}" class="btn btn-outline-secondary me-1">
                            <i class="bx bx-printer ms-0 me-1"></i> Bill Summary
                        </a>
                        @endif
                        <a href="{{ request()->get('redirect_route') != '' ? route(request()->get('redirect_route')) : route('ipd-admissions.show', $ipd_id) }}" class="btn btn-outline-secondary me-1">
                            <i class="bx bx-arrow-back ms-0 me-1"></i> Back
                        </a>
                       
                        {{-- @if(in_array('ipd-admission-create', $authRolePermissions)) --}}
                        {{-- <a href="{{ route('ipd-admissions.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> New Admission</a> --}}
                        {{-- @endif --}}
                        {{-- @if(!is_null($ipd_id ?? ''))
                            <div class="float-md-end" style="margin-right: 10px">
                                <a href="{{ route('ipd-billings.create', $ipd_id ?? '') }}" class="btn btn-info new-bill">
                                    <i class="bx bx-plus text-white"></i> New Intent
                                </a>
                            </div>
                        @endif --}}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="print_div">
        <div class="pathology-bill">
            <div class="row mt-2">
                <div class="col-md-12 col-xs-12 p-1">
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-borderless report-container">
                                        @php
                                            $company = @$ipd_id->getCompany;
                                        @endphp
                                        <thead class="report-header">
                                            <tr>
                                                <th class="report-header-cell" style="font-weight: normal;">
                                                    <x-CompanyLetterHead :company="$company" />
                                                    @php $voucherType = 'IPD_ADMISSION'; @endphp
                                                    @php $saleInvoice = $sale_invoice; @endphp
                                                </th>
                                            </tr>
                                        </thead>
                                        <tfoot class="report-footer">
                                            <tr>
                                                <td class="report-footer-cell"></td>
                                            </tr>
                                        </tfoot>
                                        <tbody class="report-content">
                                            <tr>
                                                <td class="report-content-cell text-left">
                                                    <div class="row">
                                                        @php
                                                            $discount = isset($sale_invoice->getSaleInvoiceDiscounts) && $sale_invoice->getSaleInvoiceDiscounts != '' ? $sale_invoice->getSaleInvoiceDiscounts->discount_amount : '';

                                                            $patient = $sale_invoice->getPatient ?? null;
                                                            $patientAddress = $patient->first_account_address ?? null;
                                                            $patientState = $patientAddress->state->name ?? '';
                                                            $company = @$sale_invoice->getCompany;
                                                            $comapnyState = $company->getCompanyAddress->getComapnyState->name ?? '';

                                                            if ($discount > 0 || $voucher_type->tax_applicable == '1') {
                                                                $rowspan = 2;
                                                            } else {
                                                                $rowspan = 1;
                                                            }
                                                        @endphp
                                                        <div class="col-12">
                                                            <div class="table-container">
                                                                <table style="width: 100%; border-collapse: collapse;">
                                                                    <tr>
                                                                        <td colspan="2" class="header-cell text-center" style="border-bottom: 2px solid #000;border-top: 2px solid #000; padding: 1px;">
                                                                            <h3>IPD CASE SHEET</h3>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="left-column" style="padding: 10px;">
                                                                            <table style="width: 100%; border-collapse: collapse;">
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;width:20%" > <p style="font-size: 14px; font-weight: bold;">Invoice No:</p></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;width:30%"><p style="font-size: 14px;">{{ $ipd_admission->invoice_no ?? 'N/A' }}</p></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Admission No:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->ipd_admission_no ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Invoice Date:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ formatedDate($ipd_admission->invoice_date) ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;width:25%"><p style="font-size: 14px; font-weight: bold;">Admission Date & Time:</p></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;width:25%">
                                                                                        <p style="font-size: 14px;">
                                                                                            {{ formatedDate($ipd_admission->admission_date_time) ?? 'N/A' }} 
                                                                                            {{ formatedTime($ipd_admission->admission_date_time) ?? 'N/A' }}
                                                                                        </p style="font-size: 14px;">
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Patient Name:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->patient_name ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">UHID:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->code ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Chief Complaint:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;" colspan="3">{{ $ipd_admission->symptoms_title ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;"> Patient Type:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">IPD</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Patient Contact:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->phone_no ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Age/Gender:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">
                                                                                        {{ $ipd_admission->age ? $ipd_admission->age.' Years' : 'N/A' }} 
                                                                                        @if(1>$ipd_admission->age)
                                                                                        {!! $ipd_admission->age_days ? $ipd_admission->age_days.' Days' : ''  !!}
                                                                                        @endif
                                                                                         / {{ $ipd_admission->gender_name ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Marital Status:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->status ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Patient Address:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->address ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Patient Class:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;"></p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Kin Name:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->relative_name ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Relation:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->relation ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Admitting Doctor:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{!! $ipd_admission->doctor_title_name??'' !!} {{ $ipd_admission->doctor_name ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Jt. Admitting Doctor:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $sale_invoice->consultant_name ?? 'Not Available' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Referral No:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->referal_no ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">TPA/Corporate:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->tpa_corporate_id ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Speciality:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;" colspan="3">{!! $ipd_admission->specialty ?? 'Not Available' !!}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Diagnosis/Symptoms</td>
                                                                                    <td colspan="3"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Ward:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->bed_group_name ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Bed No:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->bed_name ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                                <!-- <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Paid Deposit:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $sale_invoice->received_amount ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Due Deposit:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ $ipd_admission->due_amount ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr> -->

                                                                                <tr>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px; font-weight: bold;">Discharge Date:</p style="font-size: 14px;"></td>
                                                                                    <td style="border-bottom: 1px solid #ddd; padding: 3px;"><p style="font-size: 14px;">{{ formatedDate($ipd_admission->discharge_date_time) ?? 'N/A' }}</p style="font-size: 14px;"></td>
                                                                                </tr>
                                                                            </table>
                                                                        </td>
                                                                    

                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        <x-BillFooter :saleInvoice="$sale_invoice" />
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg">
            <i class="bi bi-printer text-white"></i> Print IPD CERTIFICATE
        </button>
    </div>
@endsection


@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script>
    $(document).ready(function() {

    function reinitializeTelInput(countryCode) {
        if ($('#relation_phone').length > 0) {
            var telInput = $('#commonModal').find('#phone_no , #whatsapp_no , #alternative_no, #relation_phone');
        } else {
            var telInput = $('#commonModal').find('#phone_no , #whatsapp_no , #alternative_no');
        }

        telInput.intlTelInput('destroy'); // Destroy the existing instances

        telInput.intlTelInput({
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/utils.js",
            initialCountry: countryCode || '{!! $countryCode ?? '' !!}',
            separateDialCode: true
        });
    }

     /**************** edit patient ********************/
     $(document).on('click', '#edit_patient', function() {
        var id = $(this).data('id');
            $('#commonModalLabel').text('Edit Patient');
            $('.save_button_span').text('Update Patient');

            var url = `{!! route('patient-account-edit', ':id') !!}?redirect_back=ipd_admission`.replace(':id', id);

            $.ajax({
                url: url,
                success: function(data) {
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                    $('[name="date_of_birth"]').datepicker('destroy');

                    $('[name="date_of_birth"]').datepicker({
                        "dateFormat" : "yy-mm-dd",
                        "maxDate": '0',
                        "changeMonth": true,
                        "changeYear": true
                    }).datepicker("setDate",'now')
                    .on('changeDate', function (ev) {
                         $(this).datepicker('hide');
                    })
                    .on('focusout', function (ev) {
                         $(this).datepicker('hide');
                    });
                    reinitializeTelInput();
                }
            });
        
    });

    $(document).on('click','.save_button', function(e) {
        e.preventDefault();

        if ($('#commonModal').find('form').hasClass('update_patient')) {
            console.log('as');
            if ($('#phone_no').val().trim() != '') {
                var dailcode_title = $('.phone_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="phone_no"]').val("+" + dailcode_array[1] + $('#phone_no').val());
            }
            $('#year').trigger("change")

            const yearInput  = $('#year').val();
            const monthInput = $('#month').val();
            const dayInput   = $('#day').val();
            const hourInput  = $('#hour').val();

            if (yearInput == '' & monthInput == '' &  dayInput == '' & hourInput == '' ) {
                toastr.error('Date field is required!', 'Error');
            }

            if ($('#whatsapp_no').val().trim() != '') {
                var dailcode_title = $('.whatsapp_no_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="whatsapp_no"]').val("+" + dailcode_array[1] + $('#whatsapp_no').val());
            }
            if ($('#relation_phone').val().trim() != '') {
                var dailcode_title = $('.relation_phone_col .selected-flag').attr('title');
                var dailcode_array = dailcode_title.split("+");
                $('input[name="relation_phone"]').val("+" + dailcode_array[1] + $('#relation_phone').val());
            }

            $('.error_name').hide();
            $('.error_email').hide();
            $('.error_phone').hide();
            $('.error_country_id').hide();
            $('.error_date_of_birth').hide();
            $('.marital_status_id').hide();
            var error = 0;

            if ($('input[name="name"]').val().trim() == '' || $('[name="account_title_id"]').val() == '') {
              error = 1;
              toastr.error('Name and Title are required!', "Error!");
            }

            if ($('[name="country_id"]').val().trim() == '') {
              error = 1;
              toastr.error('Country field is required!', "Error!");
            }

            if ($('input[name="phone_no"]').val().trim() == '') {
              error = 1;
              toastr.error('Phone No field is required!', "Error!");
            }
            if ($('#age_years').val() == '') {
                toastr.error('Date of birth field is required!', "Error!");
                error = 1;
            }

            if ($('#marital_status').val() == '') {
                toastr.error('Marital Status field is required!', "Error!");
                error = 1;
                setTimeout(function () {
                    $('.marital_status_id').hide();
                }, 3000);
            }

            if ($('input[name="date_of_birth"]').val() == '' &&
                $('input[name="year"]').val() == '' &&
                $('input[name="month"]').val() == '' &&
                $('input[name="day"]').val() == ''
            ) {
                toastr.error('Date of birth field is required!', "Error!");
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#update_patient_form')[0]);

                $.ajax({
                    url: $('#update_patient_form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            // append new category to selection
                            location.reload();
                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');
                });
            }
        }
    });
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
